/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.op.IProgramVariable;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.init.InitConfig;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.util.mergerule.MergeRuleUtils;
import java.util.Arrays;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.html.HTMLDocument;

public class HTMLSyntaxHighlighter {
    private static final int NUM_FORMULAE_IN_SEQ_THRESHOLD = 25;
    private static final int NUM_PROGVAR_THRESHOLD = 10;
    private static final String[] PROP_LOGIC_KEYWORDS = new String[]{"<->", "->", " & ", " | ", "!", "true", "false", "\u2194", "\u2192", "\u2227", "\u2228", "\u00ac", "\u22a4", "\u22a5"};
    private static final String PROP_LOGIC_KEYWORDS_REGEX = HTMLSyntaxHighlighter.concat("|", Arrays.asList(PROP_LOGIC_KEYWORDS), new StringTransformer(){

        @Override
        public String transform(Object input) {
            return Pattern.quote(HTMLSyntaxHighlighter.toHTML((String)input));
        }
    });
    public static final Pattern PROP_LOGIC_KEYWORDS_PATTERN = Pattern.compile(HTMLSyntaxHighlighter.concat("(", PROP_LOGIC_KEYWORDS_REGEX, ")"));
    private static final String PROP_LOGIC_KEYWORDS_REPLACEMENT = "<span class=\"prop_logic_highlight\">$1</span>";
    private static final String[] DYNAMIC_LOGIC_KEYWORDS = new String[]{"\\forall", "\\exists", "TRUE", "FALSE", "\\if", "\\then", "\\else", "\\sum", "bsum", "\\in", "exactInstance", "wellFormed", "measuredByEmpty", "<created>", "<inv>", "\\cup", "\u2200", "\u2203", "\u220a", "\u2205"};
    private static final String DYNAMIC_LOGIC_KEYWORDS_REGEX = HTMLSyntaxHighlighter.concat("|", Arrays.asList(DYNAMIC_LOGIC_KEYWORDS), new StringTransformer(){

        @Override
        public String transform(Object input) {
            return Pattern.quote((String)input);
        }
    });
    public static final Pattern DYNAMIC_LOGIC_KEYWORDS_PATTERN = Pattern.compile(HTMLSyntaxHighlighter.concat("(", DYNAMIC_LOGIC_KEYWORDS_REGEX, ")"));
    private static final String DYNAMIC_LOGIC_KEYWORDS_REPLACEMENT = "<span class=\"dynamic_logic_highlight\">$1</span>";
    private static final String[] JAVA_KEYWORDS = new String[]{"if", "else", "for", "do", "while", "return", "break", "switch", "case", "continue", "try", "catch", "finally", "assert", "null", "throw", "this", "true", "false", "int", "char", "long", "short", "\\Qmethod&#045;frame\\E", "\\Qloop&#045;scope\\E", "boolean", "exec", "ccatch", "\\Q\\Return\\E", "\\Q\\Break\\E", "\\Q\\Continue\\E"};
    public static final String JAVA_KEYWORDS_REGEX = HTMLSyntaxHighlighter.concat("|", Arrays.asList(JAVA_KEYWORDS));
    private static final String DELIMITERS_REGEX = HTMLSyntaxHighlighter.concat("([\\Q{}[]=*/.!,:<>\\E]|", "\\Q&#040;\\E|", "\\Q&#041;\\E|", "\\Q&#059;\\E|", "\\Q&#043;\\E|", "\\Q&#045;\\E|", "\\Q&nbsp;\\E|", "\\Q<br>\\E|", "\\Q<br/>\\E|", "\\Q&lt;\\E|", "\\Q&gt;\\E)");
    private static final Pattern JAVA_KEYWORDS_PATTERN = Pattern.compile(HTMLSyntaxHighlighter.concat(DELIMITERS_REGEX, "(", JAVA_KEYWORDS_REGEX, ")", DELIMITERS_REGEX));
    private static final Pattern MODALITY_PATTERN = Pattern.compile("\\\\(\\[|&lt;).*?\\\\(\\]|&gt;)");
    private static final String JAVA_KEYWORDS_REPLACEMENT = "$1<span class=\"java_highlight\">$2</span>$3";
    private static final String PROGVAR_REPLACEMENT = "$1<span class=\"progvar_highlight\">$2</span>$3";
    private static final Pattern SINGLE_LINE_COMMENT_PATTERN = Pattern.compile("(//.*?)<br>");
    private static final String SINGLE_LINE_COMMENT_REPLACEMENT = "<span class=\"comment_highlight\">$1</span><br>";
    private static final Pattern SEQUENT_ARROW_PATTERN = Pattern.compile("(==>|\u27f9)");
    private static final String SEQUENT_ARROW_REPLACEMENT = "<span class=\"sequent_arrow_highlight\">$1</span>";

    public HTMLSyntaxHighlighter(HTMLDocument document) {
        String propLogicHighlightRule = ".prop_logic_highlight { color: #000000; font-weight: bold; }";
        String foLogicHighlightRule = ".dynamic_logic_highlight { color: #0000C0; font-weight: bold; }";
        String javaHighlightRule = ".java_highlight { color: #7F0055; font-weight: bold; }";
        String progVarHighlightRule = ".progvar_highlight { color: #6A3E3E; }";
        String commentHighlightRule = ".comment_highlight { color: #3F7F5F; }";
        String sequentArrowHighlightRule = ".sequent_arrow_highlight { color: #000000; font-size: 1.7em }";
        document.getStyleSheet().addRule(".prop_logic_highlight { color: #000000; font-weight: bold; }");
        document.getStyleSheet().addRule(".progvar_highlight { color: #6A3E3E; }");
        document.getStyleSheet().addRule(".java_highlight { color: #7F0055; font-weight: bold; }");
        document.getStyleSheet().addRule(".dynamic_logic_highlight { color: #0000C0; font-weight: bold; }");
        document.getStyleSheet().addRule(".comment_highlight { color: #3F7F5F; }");
        document.getStyleSheet().addRule(".sequent_arrow_highlight { color: #000000; font-size: 1.7em }");
    }

    public String process(String plainTextString, Node displayedNode) {
        if (!ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isUseSyntaxHighlighting()) {
            return HTMLSyntaxHighlighter.toHTML(plainTextString);
        }
        try {
            InitConfig initConfig = displayedNode.proof().getInitConfig();
            Object programVariables = displayedNode.getLocalProgVars().size() < 10 ? displayedNode.getLocalProgVars() : (initConfig != null && displayedNode.sequent().size() < 25 ? MergeRuleUtils.getLocationVariablesHashSet((Sequent)displayedNode.sequent(), (Services)initConfig.getServices()) : new HashSet());
            return HTMLSyntaxHighlighter.concat("<div>", this.addSyntaxHighlighting(HTMLSyntaxHighlighter.toHTML(plainTextString), (Iterable<? extends IProgramVariable>)programVariables).replaceAll("<br>", "</div><div>"), "</div>");
        }
        catch (Throwable t) {
            t.printStackTrace();
            return HTMLSyntaxHighlighter.toHTML(plainTextString);
        }
    }

    private String addSyntaxHighlighting(String htmlString, Iterable<? extends IProgramVariable> programVariables) {
        htmlString = PROP_LOGIC_KEYWORDS_PATTERN.matcher(htmlString).replaceAll(PROP_LOGIC_KEYWORDS_REPLACEMENT);
        htmlString = DYNAMIC_LOGIC_KEYWORDS_PATTERN.matcher(htmlString).replaceAll(DYNAMIC_LOGIC_KEYWORDS_REPLACEMENT);
        htmlString = SEQUENT_ARROW_PATTERN.matcher(htmlString).replaceAll(SEQUENT_ARROW_REPLACEMENT);
        Matcher modalityMatcher = MODALITY_PATTERN.matcher(htmlString);
        while (modalityMatcher.find()) {
            String modality = modalityMatcher.group();
            modality = JAVA_KEYWORDS_PATTERN.matcher(modality).replaceAll(JAVA_KEYWORDS_REPLACEMENT);
            modality = SINGLE_LINE_COMMENT_PATTERN.matcher(modality).replaceAll(SINGLE_LINE_COMMENT_REPLACEMENT);
            htmlString = htmlString.replace(modalityMatcher.group(), modality);
        }
        StringTransformer progVarTransformer = new StringTransformer(){

            @Override
            public String transform(Object input) {
                ProgramVariable progVar = (ProgramVariable)input;
                return Pattern.quote(HTMLSyntaxHighlighter.toHTML(progVar.name().toString()));
            }
        };
        String concatenatedProgVars = HTMLSyntaxHighlighter.concat("|", programVariables, progVarTransformer);
        if (!concatenatedProgVars.isEmpty()) {
            htmlString = htmlString.replaceAll(HTMLSyntaxHighlighter.concat(DELIMITERS_REGEX, "(", concatenatedProgVars, ")", DELIMITERS_REGEX), PROGVAR_REPLACEMENT);
        }
        return htmlString;
    }

    private static String toHTML(String plainTextString) {
        return LogicPrinter.escapeHTML((String)plainTextString, (boolean)true);
    }

    private static String concat(String delim, Iterable<? extends Object> strings) {
        return HTMLSyntaxHighlighter.concat(delim, strings, new StringTransformer(){

            @Override
            public String transform(Object input) {
                return input.toString();
            }
        });
    }

    private static String concat(String delim, Iterable<? extends Object> strings, StringTransformer strTransformer) {
        StringBuilder sb = new StringBuilder();
        boolean loopEntered = false;
        for (Object object : strings) {
            sb.append(strTransformer.transform(object));
            sb.append(delim);
            loopEntered = true;
        }
        return loopEntered ? sb.substring(0, sb.length() - delim.length()) : "";
    }

    public static String concat(String ... strings) {
        return HTMLSyntaxHighlighter.concat("", Arrays.asList(strings), new StringTransformer(){

            @Override
            public String transform(Object input) {
                return (String)input;
            }
        });
    }

    private static interface StringTransformer {
        public String transform(Object var1);
    }
}

