/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.nodeviews.InnerNodeViewListener;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.gui.nodeviews.TacletDescriber;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.PosInTerm;
import de.uka.ilkd.key.pp.IdentitySequentPrintFilter;
import de.uka.ilkd.key.pp.InitialPositionTable;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.Range;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.rule.IBuiltInRuleApp;
import de.uka.ilkd.key.rule.IfFormulaInstSeq;
import de.uka.ilkd.key.rule.IfFormulaInstantiation;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.TacletApp;
import java.awt.Color;
import java.awt.Insets;
import javax.swing.JTextArea;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import org.key_project.util.collection.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InnerNodeView
extends SequentView {
    private static final Logger LOGGER = LoggerFactory.getLogger(InnerNodeView.class);
    private static final ColorSettings.ColorProperty RULE_APP_HIGHLIGHT_COLOR = ColorSettings.define("[innerNodeView]ruleAppHighlight", "", new Color(0.5f, 1.0f, 0.5f, 0.4f));
    private static final ColorSettings.ColorProperty IF_FORMULA_HIGHLIGHT_COLOR = ColorSettings.define("[innerNodeView]ifFormulaHighlight", "", new Color(0.8f, 1.0f, 0.8f, 0.5f));
    private static final ColorSettings.ColorProperty SELECTION_COLOR = ColorSettings.define("[innerNodeView]selection", "", new Color(10, 180, 50));
    private static final long serialVersionUID = -6542881446084654358L;
    private InitialPositionTable posTable;
    private InnerNodeViewListener listener;
    public final JTextArea tacletInfo;
    Node node;
    static final Highlighter.HighlightPainter RULEAPP_HIGHLIGHTER = new DefaultHighlighter.DefaultHighlightPainter(RULE_APP_HIGHLIGHT_COLOR.get());
    static final Highlighter.HighlightPainter IF_FORMULA_HIGHLIGHTER = new DefaultHighlighter.DefaultHighlightPainter(IF_FORMULA_HIGHLIGHT_COLOR.get());

    public InnerNodeView(Node node, MainWindow mainWindow) {
        super(mainWindow);
        this.node = node;
        this.listener = new InnerNodeViewListener(this);
        this.filter = new IdentitySequentPrintFilter();
        this.getFilter().setSequent(node.sequent());
        this.setLogicPrinter(new SequentViewLogicPrinter(new ProgramPrinter(), mainWindow.getMediator().getNotationInfo(), mainWindow.getMediator().getServices(), this.getVisibleTermLabels()));
        this.setSelectionColor(SELECTION_COLOR.get());
        this.setBackground(INACTIVE_BACKGROUND_COLOR);
        this.tacletInfo = new JTextArea(TacletDescriber.getTacletDescription(mainWindow.getMediator(), node, this.getFilter()));
        this.tacletInfo.setBackground(this.getBackground());
        this.tacletInfo.setBorder(new CompoundBorder(new MatteBorder(3, 0, 0, 0, Color.black), new EmptyBorder(new Insets(4, 0, 0, 0))));
        this.tacletInfo.setEditable(false);
    }

    private void highlightRuleAppPosition(RuleApp app) {
        try {
            if (app.posInOccurrence() != null) {
                this.highlightPos(app.posInOccurrence(), RULEAPP_HIGHLIGHTER);
            }
            if (app instanceof TacletApp) {
                this.highlightIfFormulas((TacletApp)app);
            } else if (app instanceof IBuiltInRuleApp) {
                this.highlightIfInsts((IBuiltInRuleApp)app);
            }
        }
        catch (BadLocationException badLocation) {
            LOGGER.warn("NonGoalInfoView tried to highlight an area that does not exist.", (Throwable)badLocation);
        }
    }

    private void highlightIfFormulas(TacletApp tapp) throws BadLocationException {
        ImmutableList ifs = tapp.ifFormulaInstantiations();
        if (ifs == null) {
            return;
        }
        for (IfFormulaInstantiation inst2 : ifs) {
            if (!(inst2 instanceof IfFormulaInstSeq)) continue;
            IfFormulaInstSeq inst = (IfFormulaInstSeq)inst2;
            PosInOccurrence pos = new PosInOccurrence(inst.getConstrainedFormula(), PosInTerm.getTopLevel(), inst.inAntec());
            this.highlightPos(pos, IF_FORMULA_HIGHLIGHTER);
        }
    }

    private void highlightIfInsts(IBuiltInRuleApp bapp) throws BadLocationException {
        ImmutableList ifs = bapp.ifInsts();
        for (PosInOccurrence pio : ifs) {
            this.highlightPos(pio, IF_FORMULA_HIGHLIGHTER);
        }
    }

    private Range highlightPos(PosInOccurrence pos, Highlighter.HighlightPainter light) throws BadLocationException {
        ImmutableList path = this.posTable.pathForPosition(pos, this.getFilter());
        if (path != null) {
            Range r = this.posTable.rangeForPath(path);
            this.getHighlighter().addHighlight(r.start() + 1, r.end() + 1, light);
            return r;
        }
        return null;
    }

    @Override
    public String getTitle() {
        if (this.node.leaf()) {
            return "Closed Goal";
        }
        return "Inner Node";
    }

    @Override
    public final synchronized void printSequent() {
        this.removeMouseListener(this.listener);
        InnerNodeView.setLineWidth(this.computeLineWidth());
        this.getLogicPrinter().update(this.getFilter(), InnerNodeView.getLineWidth());
        this.setText(this.getSyntaxHighlighter().process(this.getLogicPrinter().toString(), this.node));
        this.posTable = this.getLogicPrinter().getInitialPositionTable();
        RuleApp app = this.node.getAppliedRuleApp();
        if (app != null) {
            this.highlightRuleAppPosition(app);
        }
        this.updateHidingProperty();
        this.updateHeatMapHighlights();
        this.addMouseListener(this.listener);
    }
}

