/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.nodeviews.DefaultTacletMenuItem;
import de.uka.ilkd.key.gui.nodeviews.TacletMenuItem;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.plaf.SplitPaneUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class InsertionTacletBrowserMenuItem
extends JMenu
implements TacletMenuItem {
    private static final Logger LOGGER = LoggerFactory.getLogger(InsertionTacletBrowserMenuItem.class);
    private static final long serialVersionUID = 1874640339950617746L;
    private static final int MAX_ITEM_NUMBER = 30;
    private Collection<TacletAppListItem> insertionTaclets;
    private List<ActionListener> listenerList = new LinkedList<ActionListener>();
    protected NotationInfo notInfo;
    protected JFrame parent;
    private TacletApp selectedTaclet;
    protected Services services;
    private String baseTitle;

    public InsertionTacletBrowserMenuItem(String title, JFrame parent, NotationInfo notInfo, Services services) {
        super(title);
        this.baseTitle = title;
        this.parent = parent;
        this.notInfo = notInfo;
        this.services = services;
        this.insertionTaclets = this.createInsertionList();
        JMenuItem menuItem = new JMenuItem("Open Dialog");
        menuItem.addActionListener(e -> this.openDialog());
        menuItem.setToolTipText("Browse applicable taclets.");
        this.add(menuItem);
        this.addSeparator();
    }

    protected Collection<TacletAppListItem> createInsertionList() {
        return new LinkedList<TacletAppListItem>();
    }

    public void add(TacletApp app) {
        this.insertionTaclets.add(this.createListItem(app));
        if (this.getItemCount() >= 30) {
            if (this.getItemCount() == 30) {
                JLabel l = new JLabel("For more hidden formulas, see 'Open Dialog'");
                l.setFont(l.getFont().deriveFont(2));
                this.add(l);
            }
            return;
        }
        DefaultTacletMenuItem appItem = new DefaultTacletMenuItem(this, app, this.notInfo, this.services);
        appItem.addActionListener(this::processTacletSelected);
        this.add(appItem);
        this.setText(this.baseTitle + " (" + this.getAppSize() + (this.getAppSize() != 1 ? " items" : " item") + ")");
    }

    @Override
    public void addActionListener(ActionListener listener) {
        this.listenerList.add(listener);
    }

    protected abstract Sequent checkTaclet(Taclet var1);

    @Override
    public TacletApp connectedTo() {
        return this.selectedTaclet;
    }

    public int getAppSize() {
        return this.insertionTaclets.size();
    }

    public boolean isResponsible(Taclet t) {
        return this.checkTaclet(t) != null;
    }

    public void openDialog() {
        JDialog dialog = new JDialog(this.parent, this.getText(), true);
        JList<TacletAppListItem> selectionList = new JList<TacletAppListItem>(this.insertionTaclets.toArray(new TacletAppListItem[0]));
        JScrollPane scrollPane = new JScrollPane(selectionList, 20, 30);
        scrollPane.setPreferredSize(new Dimension(300, 100));
        scrollPane.setMinimumSize(new Dimension(150, 50));
        selectionList.setSelectionMode(0);
        if (this.getAppSize() > 0) {
            selectionList.setSelectedIndex(0);
        }
        JTextArea displayHiddenFormula = new JTextArea();
        TacletAppListItem selectedValue = selectionList.getSelectedValue();
        displayHiddenFormula.setText(selectedValue == null ? "" : selectedValue.longDescription());
        displayHiddenFormula.setCaretPosition(0);
        displayHiddenFormula.setEditable(false);
        selectionList.addListSelectionListener(e -> {
            if (e.getSource() instanceof JList) {
                JList list = (JList)e.getSource();
                if (list.getSelectedIndex() >= 0) {
                    if (list.getSelectedValue() instanceof TacletAppListItem) {
                        displayHiddenFormula.setText(((TacletAppListItem)list.getSelectedValue()).longDescription());
                    }
                } else {
                    displayHiddenFormula.setText("");
                }
                displayHiddenFormula.setCaretPosition(0);
            }
        });
        JScrollPane formulaDisplaySP = new JScrollPane(displayHiddenFormula);
        JSplitPane split = new JSplitPane(1, (Component)scrollPane, (Component)formulaDisplaySP){
            private static final long serialVersionUID = -6688343484818325411L;

            @Override
            public void setUI(SplitPaneUI ui) {
                try {
                    super.setUI(ui);
                }
                catch (NullPointerException e) {
                    LOGGER.debug("Exception thrown by class Main at setUI");
                }
            }
        };
        this.selectedTaclet = null;
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(e -> {
            this.selectedTaclet = null;
            dialog.setVisible(false);
            dialog.dispose();
        });
        JButton applyButton = new JButton("Apply");
        applyButton.addActionListener(e -> {
            TacletAppListItem selectedItem = (TacletAppListItem)selectionList.getSelectedValue();
            this.selectedTaclet = selectedItem == null ? null : selectedItem.getTacletApp();
            dialog.setVisible(false);
            dialog.dispose();
            this.processTacletSelected(new ActionEvent(this, 0, ""));
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout());
        buttonPanel.add(applyButton);
        buttonPanel.add(cancelButton);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)split, "Center");
        dialog.getContentPane().add((Component)buttonPanel, "South");
        dialog.setSize(500, 250);
        dialog.setVisible(true);
    }

    protected void processTacletSelected(ActionEvent e) {
        for (ActionListener al : this.listenerList) {
            al.actionPerformed(e);
        }
    }

    @Override
    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(listener);
    }

    public TacletAppListItem createListItem(TacletApp app) {
        return new TacletAppListItem(app, this.checkTaclet(app.taclet()), this.notInfo, this.services);
    }

    static class TacletAppListItem {
        private final TacletApp app;
        private final NotationInfo notInfo;
        private final Services services;
        private final Sequent seq;

        public TacletAppListItem(TacletApp app, Sequent seq, NotationInfo notInfo, Services services) {
            this.app = app;
            this.seq = seq;
            this.notInfo = notInfo;
            this.services = services;
        }

        public TacletApp getTacletApp() {
            return this.app;
        }

        public String shortDescription() {
            return this.longDescription();
        }

        public String longDescription() {
            LogicPrinter printer = new LogicPrinter(new ProgramPrinter(), this.notInfo, this.services, true);
            printer.setInstantiation(this.app.instantiations());
            printer.printSequent(this.seq);
            return printer.toString();
        }

        public String toString() {
            return this.longDescription();
        }
    }
}

