/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.CopyToClipboardAction;
import de.uka.ilkd.key.gui.nodeviews.EmptySequent;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.gui.nodeviews.SequentViewInputListener;
import de.uka.ilkd.key.gui.nodeviews.SequentViewPanel;
import de.uka.ilkd.key.gui.prooftree.ProofTreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public final class MainFrame
extends JPanel {
    private static final long serialVersionUID = -2412537422601138379L;
    private final MainWindow mainWindow;
    private final JScrollPane scrollPane = new JScrollPane();
    private Component content;

    public Component setContent(Component component) {
        Component oldContent = this.content;
        this.content = component;
        if (component instanceof SequentView) {
            SequentView sequentView = (SequentView)component;
            Point oldSequentViewPosition = this.scrollPane.getViewport().getViewPosition();
            this.scrollPane.setViewportView(new SequentViewPanel(sequentView));
            this.scrollPane.getViewport().setViewPosition(oldSequentViewPosition);
            ProofTreeView ptv = this.mainWindow.getProofTreeView();
            if (ptv != null) {
                ptv.tacletInfoToggle.setSequentView(sequentView);
            }
        } else {
            this.scrollPane.setViewportView(component);
        }
        if (oldContent instanceof SequentView) {
            ((SequentView)oldContent).removeUserSelectionHighlight();
        }
        return oldContent;
    }

    public MainFrame(MainWindow mainWindow, EmptySequent emptySequent) {
        this.mainWindow = mainWindow;
        this.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(30);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(30);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (MainFrame.this.content != null) {
                    for (MouseListener listener : MainFrame.this.content.getMouseListeners()) {
                        if (!(listener instanceof SequentViewInputListener)) continue;
                        listener.mouseClicked(e);
                    }
                }
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                if (MainFrame.this.content instanceof SequentView) {
                    ((SequentView)MainFrame.this.content).removeUserSelectionHighlight();
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        this.getInputMap(2).put(KeyStroke.getKeyStroke(67, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "copy");
        this.getActionMap().put("copy", new CopyToClipboardAction(mainWindow));
        this.setLayout(new BorderLayout());
        this.add(this.scrollPane);
        this.setContent(emptySequent);
    }
}

