/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.io.ProofSaver;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;

public class PosInSequentTransferable
implements Transferable {
    public static DataFlavor POS_IN_SEQUENT_TRANSFER;
    private PosInSequent pis;
    private String stringSelection;

    public PosInSequentTransferable(PosInSequent pis, Services serv) {
        this.pis = pis;
        if (!pis.isSequent()) {
            this.stringSelection = ProofSaver.printTerm((Term)pis.getPosInOccurrence().subTerm(), (Services)serv).toString();
        }
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{POS_IN_SEQUENT_TRANSFER, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor != null && (flavor.equals(POS_IN_SEQUENT_TRANSFER) || flavor.equals(DataFlavor.stringFlavor));
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor != null) {
            if (flavor.equals(POS_IN_SEQUENT_TRANSFER)) {
                return this.pis;
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                return this.stringSelection;
            }
        }
        throw new UnsupportedFlavorException(flavor);
    }

    static {
        try {
            POS_IN_SEQUENT_TRANSFER = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

