/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;

public class SequentHideWarningBorder
extends TitledBorder {
    private static final long serialVersionUID = 5688994897006894795L;
    private static final ColorSettings.ColorProperty ALERT_COLOR = ColorSettings.define("[sequentHideWarningBorder]alert", "", new Color(255, 178, 178));
    private static final Font FONT = new Font("sans-serif", 0, 12);
    private static final String WARNING = "Some formulas have been hidden (by search phrase)";
    private static final int DELTAX = 5;
    private SequentView sequentView;
    private int borderHeight;

    public SequentHideWarningBorder(String title, SequentView sequentView) {
        super(title);
        this.sequentView = sequentView;
        this.borderHeight = this.getBorderInsets((Component)sequentView).top;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        super.paintBorder(c, g, x, y, width, height);
        if (!this.sequentView.isHiding()) {
            return;
        }
        Map desktopHints = (Map)Toolkit.getDefaultToolkit().getDesktopProperty("awt.font.desktophints");
        Graphics2D g2d = (Graphics2D)g;
        if (desktopHints != null) {
            g2d.setRenderingHints(desktopHints);
        }
        g2d.setFont(FONT);
        int strWidth = SwingUtilities.computeStringWidth(g2d.getFontMetrics(), WARNING);
        int lx = (width - strWidth) / 2;
        g2d.setColor(ALERT_COLOR.get());
        g2d.fillRect(lx, 0, strWidth + 10, this.borderHeight);
        g2d.setColor(Color.BLACK);
        g2d.drawString(WARNING, lx + 5, this.borderHeight / 2 + 5);
    }
}

