/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.configuration.Config;
import de.uka.ilkd.key.gui.configuration.ConfigChangeAdapter;
import de.uka.ilkd.key.gui.configuration.ConfigChangeListener;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.nodeviews.CurrentGoalView;
import de.uka.ilkd.key.gui.nodeviews.HTMLSyntaxHighlighter;
import de.uka.ilkd.key.gui.nodeviews.SequentViewChangeListener;
import de.uka.ilkd.key.gui.nodeviews.SequentViewInputListener;
import de.uka.ilkd.key.gui.notification.events.GeneralFailureEvent;
import de.uka.ilkd.key.logic.FormulaChangeInfo;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.PosInTerm;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.pp.IdentitySequentPrintFilter;
import de.uka.ilkd.key.pp.InitialPositionTable;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.Range;
import de.uka.ilkd.key.pp.SequentPrintFilter;
import de.uka.ilkd.key.pp.SequentPrintFilterEntry;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.pp.VisibleTermLabels;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Objects;
import java.util.StringJoiner;
import javax.swing.JEditorPane;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SequentView
extends JEditorPane {
    private static final long serialVersionUID = 6867808795064180589L;
    private static final Logger LOGGER = LoggerFactory.getLogger(SequentView.class);
    public static final Color PERMANENT_HIGHLIGHT_COLOR = new Color(110, 85, 181, 76);
    public static final Color DND_HIGHLIGHT_COLOR = new Color(0, 150, 130, 104);
    protected static final Color UPDATE_HIGHLIGHT_COLOR = new Color(0, 150, 130, 38);
    protected static final Color INACTIVE_BACKGROUND_COLOR = new Color(UIManager.getColor("Panel.background").getRGB());
    private static final ColorSettings.ColorProperty HEATMAP_COLOR = ColorSettings.define("[Heatmap]basecolor", "Base color of the heatmap. Other colors are derived from this one.", new Color(252, 202, 80));
    private static final float HEATMAP_DEFAULT_START_OPACITY = 0.7f;
    public static final String PROP_LAST_MOUSE_POSITION = "lastMousePosition";
    public static final Point OUTSIDE_MOUSE_POSITION = new Point(-1, -1);
    private final MainWindow mainWindow;
    private static int lineWidth;
    private final ConfigChangeListener configChangeListener;
    protected SequentPrintFilter filter;
    private SequentViewLogicPrinter printer;
    private HTMLSyntaxHighlighter syntaxHighlighter;
    public boolean refreshHighlightning = true;
    private final Object defaultHighlight;
    private Object currentHighlight;
    private final Object additionalJavaHighlight;
    public final Object dndHighlight;
    private final HashMap<Color, Highlighter.HighlightPainter> color2Highlight = new LinkedHashMap<Color, Highlighter.HighlightPainter>();
    private Point lastMousePosition = OUTSIDE_MOUSE_POSITION;
    private SequentViewInputListener sequentViewInputListener;
    private Object userSelectionHighlight = null;
    private Range userSelectionHighlightRange = null;
    private PosInSequent userSelectionHighlightPis = null;

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public static void setLineWidth(int i) {
        if (i != 0) {
            lineWidth = i;
        }
    }

    public static int getLineWidth() {
        return lineWidth;
    }

    public VisibleTermLabels getVisibleTermLabels() {
        return this.mainWindow.getVisibleTermLabels();
    }

    protected SequentView(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.setContentType("text/html");
        this.syntaxHighlighter = new HTMLSyntaxHighlighter((HTMLDocument)this.getDocument());
        this.configChangeListener = new ConfigChangeAdapter(this);
        Config.DEFAULT.addConfigChangeListener(this.configChangeListener);
        this.setEditable(false);
        this.setFont();
        this.sequentViewInputListener = new SequentViewInputListener(this);
        this.addMouseMotionListener(this.sequentViewInputListener);
        this.addMouseListener(this.sequentViewInputListener);
        this.setHighlighter(new DefaultHighlighter());
        this.additionalJavaHighlight = this.getColorHighlight(CurrentGoalView.ADDITIONAL_HIGHLIGHT_COLOR.get());
        this.defaultHighlight = this.getColorHighlight(CurrentGoalView.DEFAULT_HIGHLIGHT_COLOR.get());
        this.dndHighlight = this.getColorHighlight(CurrentGoalView.DND_HIGHLIGHT_COLOR.get());
        this.currentHighlight = this.defaultHighlight;
        SequentViewChangeListener changeListener = new SequentViewChangeListener(this);
        this.addComponentListener(changeListener);
        this.addPropertyChangeListener("font", changeListener);
        this.addHierarchyBoundsListener(changeListener);
        this.filter = new IdentitySequentPrintFilter();
        this.setToolTipText("");
        KeYGuiExtensionFacade.installKeyboardShortcuts(this.getMainWindow().getMediator(), this, KeYGuiExtension.KeyboardShortcuts.SEQUENT_VIEW);
        this.printer = new SequentViewLogicPrinter(new ProgramPrinter(null), mainWindow.getMediator().getNotationInfo(), mainWindow.getMediator().getServices(), this.getVisibleTermLabels());
    }

    public final void setFont() {
        Font myFont = UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW");
        if (myFont != null) {
            this.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
            this.setFont(myFont);
        } else {
            LOGGER.debug("KEY_FONT_SEQUENT_VIEW not available. Use standard font.");
        }
    }

    public void unregisterListener() {
        Config.DEFAULT.removeConfigChangeListener(this.configChangeListener);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        if (!ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isShowSequentViewTooltips()) {
            return null;
        }
        PosInSequent pis = this.getPosInSequent(event.getPoint());
        Object text = "";
        if (pis != null && !pis.isSequent()) {
            Term term = pis.getPosInOccurrence().subTerm();
            text = (String)text + "<b>Operator:</b> " + term.op().getClass().getSimpleName() + " (" + term.op() + ")";
            text = (String)text + "<br><b>Sort</b>: " + term.sort();
        }
        StringJoiner extensionStr = new StringJoiner("<hr>", "<hr>", "");
        extensionStr.setEmptyValue("");
        KeYGuiExtensionFacade.getTooltipStrings(this.getMainWindow(), pis).stream().filter(s -> !s.isEmpty()).forEach(extensionStr::add);
        text = (String)text + extensionStr;
        if (((String)text).isEmpty()) {
            return null;
        }
        return "<html>" + (String)text + "</html>";
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Config.DEFAULT.addConfigChangeListener(this.configChangeListener);
        this.updateUI();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.unregisterListener();
    }

    protected void finalize() {
        try {
            this.unregisterListener();
        }
        catch (Throwable e) {
            this.mainWindow.notify(new GeneralFailureEvent(e.getMessage()));
        }
        finally {
            try {
                super.finalize();
            }
            catch (Throwable e) {
                this.mainWindow.notify(new GeneralFailureEvent(e.getMessage()));
            }
        }
    }

    public void removeHighlight(Object highlight) {
        this.getHighlighter().removeHighlight(highlight);
    }

    public void paintHighlight(Range range, Object highlighter) {
        try {
            if (range != null) {
                this.getHighlighter().changeHighlight(highlighter, range.start(), range.end());
            } else {
                this.getHighlighter().changeHighlight(highlighter, 0, 0);
            }
        }
        catch (BadLocationException badLocation) {
            LOGGER.warn("SequentView tried to highlight an area that does not exist: {}", (Object)range);
        }
    }

    public final Object getColorHighlight(final Color color) {
        Object highlight = null;
        if (!this.color2Highlight.containsKey(color)) {
            Highlighter.HighlightPainter painter = new Highlighter.HighlightPainter(){
                final DefaultHighlighter.DefaultHighlightPainter helper;
                {
                    this.helper = new DefaultHighlighter.DefaultHighlightPainter(color);
                }

                @Override
                public void paint(Graphics g, int p0, int p1, Shape bounds, JTextComponent c) {
                    this.helper.paint(g, p0, p1, bounds, c);
                }
            };
            this.color2Highlight.put(color, painter);
        }
        Highlighter.HighlightPainter hp = this.color2Highlight.get(color);
        try {
            highlight = this.getHighlighter().addHighlight(0, 0, hp);
        }
        catch (BadLocationException e) {
            LOGGER.debug("Highlight range out of scope.");
            e.printStackTrace();
        }
        return highlight;
    }

    public abstract String getTitle();

    @Override
    public String getText() {
        try {
            return this.getDocument().getText(0, this.getDocument().getLength());
        }
        catch (BadLocationException e) {
            return super.getText();
        }
    }

    public PosInSequent getLastPosInSequent() {
        if (this.lastMousePosition.equals(OUTSIDE_MOUSE_POSITION)) {
            return PosInSequent.createSequentPos();
        }
        return this.getPosInSequent(this.lastMousePosition);
    }

    protected synchronized PosInSequent getPosInSequent(Point p) {
        String seqText = this.getText();
        if (seqText.length() > 0 && p != null) {
            int characterIndex = this.correctedViewToModel(p);
            return this.printer.getInitialPositionTable().getPosInSequent(characterIndex, this.getFilter());
        }
        return null;
    }

    public SequentViewLogicPrinter getLogicPrinter() {
        return this.printer;
    }

    protected void setLogicPrinter(SequentViewLogicPrinter p) {
        this.printer = p;
    }

    protected HTMLSyntaxHighlighter getSyntaxHighlighter() {
        return this.syntaxHighlighter;
    }

    public String getHighlightedText(PosInSequent pos) {
        if (pos == null) {
            return "";
        }
        String s = "";
        try {
            s = this.getText(pos.getBounds().start() + 1, pos.getBounds().length());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return s;
    }

    public String getHighlightedText() {
        return this.getHighlightedText(this.getPosInSequent(this.getMousePosition()));
    }

    public int correctedViewToModel(Point p) {
        int cursorPosition;
        String seqText = this.getText();
        cursorPosition = (cursorPosition -= (cursorPosition = this.viewToModel(p)) > 0 ? 1 : 0) >= seqText.length() ? seqText.length() - 1 : cursorPosition;
        cursorPosition = cursorPosition >= 0 ? cursorPosition : 0;
        int previousCharacterWidth = this.getFontMetrics(this.getFont()).charWidth(seqText.charAt(cursorPosition));
        int characterIndex = this.viewToModel(new Point((int)p.getX() - previousCharacterWidth / 2, (int)p.getY()));
        return characterIndex - 1;
    }

    public void disableHighlight(Object highlight) {
        try {
            this.getHighlighter().changeHighlight(highlight, 0, 0);
        }
        catch (BadLocationException e) {
            LOGGER.debug("Invalid range for highlight");
            e.printStackTrace();
        }
    }

    public void disableHighlights() {
        this.disableHighlight(this.currentHighlight);
        this.disableHighlight(this.additionalJavaHighlight);
        this.setLastMousePosition(OUTSIDE_MOUSE_POSITION);
    }

    public void setCurrentHighlight(Object tag) {
        this.currentHighlight = tag;
    }

    public Object getCurrentHighlight() {
        return this.currentHighlight;
    }

    public void paintHighlights(Point p) {
        this.paintHighlight(this.getFirstStatementRange(p), this.additionalJavaHighlight);
        this.paintHighlight(this.getHighlightRange(p), this.currentHighlight);
    }

    synchronized Range getHighlightRange(Point p) {
        String seqText = this.getText();
        if (seqText.length() > 0) {
            int characterIndex = this.correctedViewToModel(p);
            Range result = this.printer.getInitialPositionTable().rangeForIndex(characterIndex);
            if (result.end() < 0) {
                LOGGER.debug("SequentView::getHighlightRange rangeForIndex returned invalid range. Result was {}, character index {}, point {}.", new Object[]{result, characterIndex, p});
                LOGGER.debug("Sequence text: {}", (Object)seqText);
                return null;
            }
            result = new Range(result.start() + 1, result.end() + 1);
            return result;
        }
        return null;
    }

    protected synchronized Range getFirstStatementRange(Point p) {
        if (this.getDocument().getLength() > 0) {
            int characterIndex = this.correctedViewToModel(p);
            Range result = this.printer.getInitialPositionTable().firstStatementRangeForIndex(characterIndex);
            if (result == null) {
                return null;
            }
            return new Range(result.start() + 1, result.end() + 1);
        }
        return null;
    }

    protected void updateHeatMapHighlights() {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        int max_age = vs.getMaxAgeForHeatmap();
        if (vs.isShowHeatmap()) {
            if (vs.isHeatmapSF()) {
                if (vs.isHeatmapNewest()) {
                    this.updateHeatmapSFHighlights(max_age, true);
                } else {
                    this.updateHeatmapSFHighlights(max_age, false);
                }
            } else if (vs.isHeatmapNewest()) {
                this.updateHeatmapTermHighlights(max_age, true);
            } else {
                this.updateHeatmapTermHighlights(max_age, false);
            }
        }
    }

    Range getUserSelectionHighlightRange() {
        return this.userSelectionHighlightRange;
    }

    void recalculateUserSelectionRange() {
        if (this.userSelectionHighlight == null) {
            return;
        }
        InitialPositionTable posTable = this.printer.getInitialPositionTable();
        PosInSequent pis = this.userSelectionHighlightPis;
        Range range = posTable.rangeForPath(posTable.pathForPosition(pis.getPosInOccurrence(), this.filter));
        this.removeUserSelectionHighlight();
        try {
            this.userSelectionHighlightPis = pis;
            this.userSelectionHighlightRange = new Range(range.start() + 1, range.end() + 1);
            this.userSelectionHighlight = this.getHighlighter().addHighlight(this.userSelectionHighlightRange.start(), this.userSelectionHighlightRange.end(), new DefaultHighlighter.DefaultHighlightPainter(PERMANENT_HIGHLIGHT_COLOR));
            this.sequentViewInputListener.highlightOriginInSourceView(pis);
        }
        catch (BadLocationException e) {
            LOGGER.debug("Error while setting permanent highlight", (Throwable)e);
        }
    }

    protected void setUserSelectionHighlight(Point point) {
        this.removeUserSelectionHighlight();
        try {
            this.userSelectionHighlightPis = this.getPosInSequent(point);
            this.userSelectionHighlightRange = this.getHighlightRange(point);
            this.userSelectionHighlight = this.getHighlighter().addHighlight(this.userSelectionHighlightRange.start(), this.userSelectionHighlightRange.end(), new DefaultHighlighter.DefaultHighlightPainter(PERMANENT_HIGHLIGHT_COLOR));
            this.sequentViewInputListener.highlightOriginInSourceView(this.userSelectionHighlightPis);
        }
        catch (BadLocationException e) {
            LOGGER.debug("Error while setting permanent highlight", (Throwable)e);
        }
    }

    protected void removeUserSelectionHighlight() {
        if (this.userSelectionHighlight != null) {
            this.getHighlighter().removeHighlight(this.userSelectionHighlight);
        }
        this.userSelectionHighlight = null;
        this.userSelectionHighlightPis = null;
        this.userSelectionHighlightRange = null;
        this.sequentViewInputListener.highlightOriginInSourceView(null);
    }

    protected boolean isInUserSelectionHighlight(Point point) {
        return point == null && this.userSelectionHighlightRange == null || point != null && this.userSelectionHighlightRange != null && Objects.equals(this.userSelectionHighlightRange, this.getHighlightRange(point));
    }

    protected void setUserSelectionHighlight(PosInSequent pis) {
        this.removeUserSelectionHighlight();
        try {
            this.userSelectionHighlightRange = new Range(pis.getBounds().start(), pis.getBounds().end());
            this.userSelectionHighlight = this.getHighlighter().addHighlight(this.userSelectionHighlightRange.start(), this.userSelectionHighlightRange.end(), new DefaultHighlighter.DefaultHighlightPainter(PERMANENT_HIGHLIGHT_COLOR));
            this.sequentViewInputListener.highlightOriginInSourceView(pis);
        }
        catch (BadLocationException e) {
            LOGGER.debug("Error while setting permanent highlight", (Throwable)e);
        }
    }

    public void highlight(Point p) {
        if (p == null) {
            throw new IllegalArgumentException("p is null");
        }
        this.setCurrentHighlight(this.defaultHighlight);
        this.paintHighlights(p);
        this.setLastMousePosition(p);
    }

    private void setLastMousePosition(Point p) {
        Point old = this.lastMousePosition;
        this.lastMousePosition = p;
        this.firePropertyChange(PROP_LAST_MOUSE_POSITION, old, p);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFont();
    }

    public int computeLineWidth() {
        int maxChars = (int)(this.getVisibleRect().getWidth() / (double)this.getFontMetrics(this.getFont()).charWidth('W'));
        if (maxChars > 1) {
            --maxChars;
        }
        return maxChars;
    }

    protected void updateHeatmapSFHighlights(int max_age, boolean newest) {
        if (this.getLogicPrinter() == null) {
            return;
        }
        InitialPositionTable ipt = this.getLogicPrinter().getInitialPositionTable();
        int i = 0;
        ImmutableList entryList = this.filter.getFilteredAntec().append(this.filter.getFilteredSucc());
        if (newest) {
            Object[] sortedArray = new SequentPrintFilterEntry[entryList.size()];
            entryList.toArray(sortedArray);
            Arrays.sort(sortedArray, new Comparator<SequentPrintFilterEntry>(){

                @Override
                public int compare(SequentPrintFilterEntry o1, SequentPrintFilterEntry o2) {
                    int o1age = SequentView.this.computeSeqFormulaAge(SequentView.this.getMainWindow().getMediator().getSelectedNode(), o1.getFilteredFormula(), 1000);
                    int o2age = SequentView.this.computeSeqFormulaAge(SequentView.this.getMainWindow().getMediator().getSelectedNode(), o2.getFilteredFormula(), 1000);
                    return o1age - o2age;
                }
            });
            for (SequentPrintFilterEntry entry : entryList) {
                for (int j = 0; j < max_age && j < sortedArray.length; ++j) {
                    if (!sortedArray[j].equals(entry)) continue;
                    Color color = this.computeColorForAge(max_age, j);
                    ImmutableSLList list = (ImmutableSLList)ImmutableSLList.nil().prepend((Object)0).append((Object)i);
                    Range r = ipt.rangeForPath((ImmutableList)list);
                    Range newR = new Range(r.start() + 1, r.end() + 1);
                    Object tag = this.getColorHighlight(color);
                    this.paintHighlight(newR, tag);
                }
                ++i;
            }
        } else {
            for (SequentPrintFilterEntry entry : entryList) {
                SequentFormula form = entry.getFilteredFormula();
                int age = this.computeSeqFormulaAge(this.getMainWindow().getMediator().getSelectedNode(), form, max_age + 2);
                if (age < max_age) {
                    Color color = this.computeColorForAge(max_age, age);
                    ImmutableSLList list = (ImmutableSLList)ImmutableSLList.nil().prepend((Object)0).append((Object)i);
                    Range r = ipt.rangeForPath((ImmutableList)list);
                    Range newR = new Range(r.start() + 1, r.end() + 1);
                    Object tag = this.getColorHighlight(color);
                    this.paintHighlight(newR, tag);
                }
                ++i;
            }
        }
    }

    protected void updateHeatmapTermHighlights(int max_age, boolean newest) {
        LinkedList<Node> nodeList = new LinkedList<Node>();
        Node node = this.getMainWindow().getMediator().getSelectedNode();
        nodeList.add(node);
        while (node.parent() != null) {
            node = node.parent();
            nodeList.addFirst(node);
        }
        ArrayList<PIO_age> pio_age_list = new ArrayList<PIO_age>();
        Iterator it = nodeList.iterator();
        int age = nodeList.size() - 1;
        while (it.hasNext()) {
            node = (Node)it.next();
            if (node.getNodeInfo().getSequentChangeInfo() != null) {
                Object sf2;
                ImmutableList added_ante = node.getNodeInfo().getSequentChangeInfo().addedFormulas(true);
                ImmutableList added_succ = node.getNodeInfo().getSequentChangeInfo().addedFormulas(false);
                for (Object sf2 : added_ante) {
                    pio_age_list.add(new PIO_age(new PosInOccurrence((SequentFormula)sf2, PosInTerm.getTopLevel(), true), age));
                }
                for (Object sf2 : added_succ) {
                    pio_age_list.add(new PIO_age(new PosInOccurrence((SequentFormula)sf2, PosInTerm.getTopLevel(), false), age));
                }
                ImmutableList modified = node.getNodeInfo().getSequentChangeInfo().modifiedFormulas();
                for (FormulaChangeInfo fci : modified) {
                    PosInOccurrence positionOfMod = fci.getPositionOfModification();
                    pio_age_list.add(new PIO_age(positionOfMod, age));
                    for (PIO_age pair : pio_age_list) {
                        if (!pair.get_pio().sequentFormula().equals((Object)fci.getOriginalFormula())) continue;
                        if (positionOfMod.posInTerm().isPrefixOf(pair.get_pio().posInTerm())) {
                            pair.active = false;
                            continue;
                        }
                        pair.set_pio(new PosInOccurrence(fci.getNewFormula(), pair.get_pio().posInTerm(), pair.get_pio().isInAntec()));
                    }
                }
                for (SequentFormula sf3 : node.getNodeInfo().getSequentChangeInfo().removedFormulas(true)) {
                    for (PIO_age pair : pio_age_list) {
                        if (!pair.get_pio().sequentFormula().equals((Object)sf3) || !pair.get_pio().isInAntec()) continue;
                        pair.active = false;
                    }
                }
                sf2 = node.getNodeInfo().getSequentChangeInfo().removedFormulas(false).iterator();
                while (sf2.hasNext()) {
                    SequentFormula sf3;
                    sf3 = (SequentFormula)sf2.next();
                    for (PIO_age pair : pio_age_list) {
                        if (!pair.get_pio().sequentFormula().equals((Object)sf3) || pair.get_pio().isInAntec()) continue;
                        pair.active = false;
                    }
                }
            }
            --age;
        }
        InitialPositionTable ipt = this.getLogicPrinter().getInitialPositionTable();
        pio_age_list.sort(new Comparator<PIO_age>(){

            @Override
            public int compare(PIO_age o1, PIO_age o2) {
                return o1.age >= o2.age ? 1 : -1;
            }
        });
        if (newest) {
            for (int j = 0; j < pio_age_list.size() && j < max_age; ++j) {
                PIO_age pair = (PIO_age)pio_age_list.get(j);
                if (!pair.active) continue;
                while (j + 1 < pio_age_list.size() && ((PIO_age)pio_age_list.get(j + 1)).get_pio().equals((Object)pair.get_pio())) {
                    pair = (PIO_age)pio_age_list.get(j + 1);
                    pio_age_list.remove(j);
                }
                Color color = this.computeColorForAge(max_age, j);
                ImmutableList pfp = ipt.pathForPosition(pair.get_pio(), this.filter);
                if (pfp == null) continue;
                Range r = ipt.rangeForPath(pfp);
                Range newR = new Range(r.start() + 1, r.end() + 1);
                Object tag = this.getColorHighlight(color);
                this.paintHighlight(newR, tag);
            }
        } else {
            for (PIO_age pair : pio_age_list) {
                if (!pair.active || pair.get_age() > max_age) continue;
                PosInOccurrence pio = pair.get_pio();
                Color color = this.computeColorForAge(max_age, pair.get_age());
                ImmutableList pfp = ipt.pathForPosition(pio, this.filter);
                if (pfp == null) continue;
                Range r = ipt.rangeForPath(pfp);
                Range newR = new Range(r.start() + 1, r.end() + 1);
                Object tag = this.getColorHighlight(color);
                this.paintHighlight(newR, tag);
            }
        }
    }

    private Color computeColorForAge(int max_age, int age) {
        float[] color = HEATMAP_COLOR.get().getRGBColorComponents(null);
        float alpha = 0.7f * (1.0f - (float)age / (float)max_age);
        return new Color(color[0], color[1], color[2], alpha);
    }

    private int computeSeqFormulaAge(Node node, SequentFormula form, int max_age) {
        int age;
        for (age = -1; age < max_age && node != null && node.sequent().contains(form); ++age, node = node.parent()) {
        }
        return age;
    }

    public abstract void printSequent();

    public void setFilter(SequentPrintFilter sequentPrintFilter, boolean forceUpdate) {
        this.filter = sequentPrintFilter;
        Node selectedNode = this.getMainWindow().getMediator().getSelectedNode();
        if (selectedNode != null) {
            this.filter.setSequent(selectedNode.sequent());
        }
        if (forceUpdate) {
            this.printSequent();
        }
        if (this.getParent() != null) {
            this.getParent().revalidate();
        }
    }

    protected SequentPrintFilter getFilter() {
        return this.filter;
    }

    protected void updateHidingProperty() {
        this.updateUI();
        if (this.getParent() != null) {
            this.getParent().repaint();
        }
    }

    public boolean isHiding() {
        if (this.filter == null) {
            return false;
        }
        Sequent originalSequent = this.filter.getOriginalSequent();
        if (originalSequent == null) {
            return false;
        }
        int filteredAntecSize = this.filter.getFilteredAntec() == null ? 0 : this.filter.getFilteredAntec().size();
        int filteredSuccSize = this.filter.getFilteredSucc() == null ? 0 : this.filter.getFilteredSucc().size();
        int orgSize = originalSequent.size();
        int newSize = filteredAntecSize + filteredSuccSize;
        return orgSize != newSize;
    }

    public boolean isMainSequentView() {
        return true;
    }

    class PIO_age {
        PosInOccurrence pio;
        int age;
        boolean active = true;

        public PIO_age(PosInOccurrence pio, int age) {
            this.pio = pio;
            this.age = age;
        }

        public PosInOccurrence get_pio() {
            return this.pio;
        }

        public int get_age() {
            return this.age;
        }

        public void set_pio(PosInOccurrence pio) {
            this.pio = pio;
        }

        public String toString() {
            return "PIO_age [pio=" + this.pio + ", age=" + this.age + ", active=" + this.active + "]";
        }

        public boolean equals(Object o) {
            if (o instanceof PIO_age) {
                PIO_age c = (PIO_age)o;
                if (this.age == c.age && this.pio == c.pio) {
                    return true;
                }
            }
            return false;
        }
    }
}

