/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.NullMultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.docking.DockingHelper;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.nodeviews.InnerNodeView;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.proof.Node;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;

public class SequentViewDock
extends DefaultMultipleCDockable {
    private final SequentView sequentView;
    private final Node node;

    public SequentViewDock(MainWindow mainWindow, Node node) {
        super((MultipleCDockableFactory)NullMultipleCDockableFactory.NULL, new CAction[0]);
        this.node = node;
        this.setCloseable(true);
        this.setRemoveOnClose(true);
        this.setTitleText("Node: " + node.serialNr());
        this.sequentView = new InnerNodeView(node, mainWindow);
        this.sequentView.printSequent();
        JPanel panel = (JPanel)this.getContentPane();
        panel.setLayout(new BorderLayout());
        panel.add(this.sequentView);
        this.addAction(DockingHelper.translateAction(new JumpIntoTreeAction()));
    }

    private class JumpIntoTreeAction
    extends KeyAction {
        private static final long serialVersionUID = 2784076203317037461L;

        JumpIntoTreeAction() {
            this.setName("Jump into Tree");
            this.putValue("SmallIcon", IconFactory.JUMP_INTO_TREE.get());
            this.lookupAcceleratorKey();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SequentViewDock.this.node != null) {
                SequentViewDock.this.sequentView.getMainWindow().getMediator().getSelectionModel().setSelectedNode(SequentViewDock.this.node);
            }
        }
    }

    public static class OpenCurrentNodeAction
    extends MainWindowAction {
        private static final long serialVersionUID = 8488446344747995700L;
        private final Node node;

        public OpenCurrentNodeAction(MainWindow mainWindow, Node node) {
            super(mainWindow);
            this.node = node;
            this.setName("Open Node in Separate Buffer");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SequentViewDock sequentViewDock = new SequentViewDock(this.mainWindow, this.node);
            this.mainWindow.getDockControl().addDockable((MultipleCDockable)sequentViewDock);
            sequentViewDock.setLocation((CLocation)CLocation.base());
            sequentViewDock.setVisible(true);
        }
    }
}

