/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.gui.sourceview.SourceView;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.io.ProofSaver;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

public class SequentViewInputListener
implements MouseMotionListener,
MouseListener {
    private static final ColorSettings.ColorProperty ORIGIN_HIGHLIGHT_COLOR = ColorSettings.define("[SourceView]originHighlight", "Color for highlighting origin of selected term in source view", new Color(252, 202, 80));
    private static final ColorSettings.ColorProperty SUBTERM_ORIGIN_HIGHLIGHT_COLOR = ColorSettings.define("[SourceView]originHighlight", "Color for highlighting origin of subterms of selected term in source view", new Color(252, 228, 169));
    private Set<SourceView.Highlight> originHighlights = new HashSet<SourceView.Highlight>();
    private final SequentView sequentView;
    private boolean showTermInfo = false;
    private static boolean refresh = true;

    public static boolean isRefresh() {
        return refresh;
    }

    public static void setRefresh(boolean refresh) {
        SequentViewInputListener.refresh = refresh;
    }

    SequentViewInputListener(SequentView sequentView) {
        this.sequentView = sequentView;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        this.showTermInfo(me.getPoint());
        if (this.sequentView.refreshHighlightning && refresh && this.sequentView.getDocument().getLength() > 0) {
            this.sequentView.highlight(me.getPoint());
        }
        if (this.sequentView.isInUserSelectionHighlight(null)) {
            this.highlightOriginInSourceView(this.sequentView.getPosInSequent(me.getPoint()));
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.sequentView.refreshHighlightning) {
            this.sequentView.disableHighlights();
        }
        if (this.sequentView.isInUserSelectionHighlight(null)) {
            this.highlightOriginInSourceView(null);
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.sequentView.isMainSequentView()) {
            return;
        }
        if (SwingUtilities.isMiddleMouseButton(e) || e.isControlDown() && SwingUtilities.isLeftMouseButton(e)) {
            Point point = e.getPoint();
            PosInSequent pis = this.sequentView.getPosInSequent(point);
            if (pis == null || pis.isSequent() || this.sequentView.isInUserSelectionHighlight(point)) {
                this.sequentView.removeUserSelectionHighlight();
            } else {
                this.sequentView.setUserSelectionHighlight(point);
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    public void highlightOriginInSourceView(PosInSequent pos) {
        Set<Object> subtermOrigins;
        OriginTermLabel.FileOrigin origin;
        Object or;
        if (!ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().isHighlightOrigin()) {
            pos = null;
        }
        SourceView sourceView = SourceView.getSourceView(this.sequentView.getMainWindow());
        this.originHighlights.forEach(sourceView::removeHighlight);
        this.originHighlights.clear();
        if (pos == null || pos.getPosInOccurrence() == null) {
            return;
        }
        Term term = pos.getPosInOccurrence().subTerm();
        OriginTermLabel label = (OriginTermLabel)term.getLabel(OriginTermLabel.NAME);
        if (label == null) {
            or = OriginTermLabel.getOrigin((PosInSequent)pos);
            origin = or instanceof OriginTermLabel.FileOrigin ? (OriginTermLabel.FileOrigin)or : null;
            subtermOrigins = Collections.emptySet();
        } else {
            or = label.getOrigin();
            origin = or instanceof OriginTermLabel.FileOrigin ? (OriginTermLabel.FileOrigin)or : null;
            subtermOrigins = label.getSubtermOrigins().stream().filter(o -> o instanceof OriginTermLabel.FileOrigin).map(o -> (OriginTermLabel.FileOrigin)o).collect(Collectors.toSet());
        }
        try {
            if (origin != null) {
                this.originHighlights.addAll(sourceView.addHighlightsForJMLStatement(origin.fileName, origin.line, ORIGIN_HIGHLIGHT_COLOR.get(), 20));
            }
            for (OriginTermLabel.FileOrigin subtermOrigin : subtermOrigins) {
                if (subtermOrigin.equals((Object)origin)) continue;
                this.originHighlights.addAll(sourceView.addHighlightsForJMLStatement(subtermOrigin.fileName, subtermOrigin.line, SUBTERM_ORIGIN_HIGHLIGHT_COLOR.get(), 10));
            }
        }
        catch (IOException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    protected void showTermInfo(Point p) {
        MainWindow mainWindow = this.sequentView.getMainWindow();
        if (this.showTermInfo) {
            PosInOccurrence posInOcc;
            PosInSequent mousePos = this.sequentView.getPosInSequent(p);
            String info = null;
            if (mousePos != null && !"".equals(this.sequentView.getHighlightedText(mousePos)) && (posInOcc = mousePos.getPosInOccurrence()) != null) {
                Term t = posInOcc.subTerm();
                String tOpClassString = t.op().getClass().toString();
                String operator = tOpClassString.substring(tOpClassString.lastIndexOf(46) + 1);
                info = operator + ", Sort: " + t.sort() + ", Hash:" + t.hashCode();
                Sequent seq = this.sequentView.getMainWindow().getMediator().getSelectedNode().sequent();
                info = info + ProofSaver.posInOccurrence2Proof((Sequent)seq, (PosInOccurrence)posInOcc);
                StringJoiner extensionStr = new StringJoiner(", ", ", ", "");
                extensionStr.setEmptyValue("");
                KeYGuiExtensionFacade.getTermInfoStrings(this.sequentView.getMainWindow(), mousePos).forEach(extensionStr::add);
                info = info + extensionStr;
            }
            if (info == null) {
                mainWindow.setStandardStatusLine();
            } else {
                mainWindow.setStatusLine(info);
            }
        }
    }
}

