/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.nodeviews.SequentView;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

abstract class SequentViewListener<T extends SequentView>
implements MouseListener {
    public static final int POPUP_DELAY = 400;
    private long lastPopupCloseTime = 0L;
    private final T sequentView;

    SequentViewListener(T sequentView) {
        this.sequentView = sequentView;
    }

    public T getSequentView() {
        return this.sequentView;
    }

    void hideMenu(JMenu menu) {
        menu.setPopupMenuVisible(false);
    }

    long getLastPopupCloseTime() {
        return this.lastPopupCloseTime;
    }

    void showPopup(MouseEvent me, JMenu menu) {
        ((SequentView)this.sequentView).refreshHighlightning = false;
        JPopupMenu popup = menu.getPopupMenu();
        popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                SequentViewListener.this.lastPopupCloseTime = System.currentTimeMillis();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ((SequentView)SequentViewListener.this.sequentView).refreshHighlightning = true;
                SequentViewListener.this.lastPopupCloseTime = System.currentTimeMillis();
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                ((SequentView)SequentViewListener.this.sequentView).refreshHighlightning = false;
            }
        });
        popup.show((Component)this.sequentView, me.getX() - 5, me.getY() - 5);
        popup.requestFocusInWindow();
    }
}

