/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.extension.api.DefaultContextMenuKind;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.gui.utilities.GuiUtilities;
import de.uka.ilkd.key.logic.NameCreationInfo;
import de.uka.ilkd.key.logic.ProgramElementName;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.op.ProgramVariable;
import de.uka.ilkd.key.pp.PosInSequent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

public abstract class SequentViewMenu<T extends SequentView>
extends JMenu {
    private static final long serialVersionUID = -366978815217974621L;
    private static final String COPY_TO_CLIPBOARD = "Copy to clipboard";
    private static final String NAME_CREATION_INFO = "View name creation info";
    private PosInSequent pos;
    private T sequentView;

    public SequentViewMenu() {
    }

    SequentViewMenu(T sequentView, PosInSequent pos) {
        this.sequentView = sequentView;
        this.pos = pos;
        assert (sequentView != null);
        assert (pos != null);
    }

    protected PosInSequent getPos() {
        return this.pos;
    }

    protected T getSequentView() {
        return this.sequentView;
    }

    protected void addExtensionMenu() {
        List<Action> actions = KeYGuiExtensionFacade.getContextMenuItems(DefaultContextMenuKind.SEQUENT_VIEW, this.getPos(), ((SequentView)this.getSequentView()).getMainWindow().getMediator());
        for (Action action : actions) {
            this.add(action);
        }
    }

    protected void addClipboardItem(MenuControl control) {
        JMenuItem item = new JMenuItem(COPY_TO_CLIPBOARD);
        item.addActionListener(control);
        this.add(item);
    }

    protected void createNameCreationInfoSection(MenuControl control) {
        JMenuItem item = new JMenuItem(NAME_CREATION_INFO);
        item.addActionListener(control);
        this.add(item);
    }

    protected class MenuControl
    implements ActionListener {
        protected MenuControl() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (((JMenuItem)e.getSource()).getText().startsWith(SequentViewMenu.COPY_TO_CLIPBOARD)) {
                GuiUtilities.copyHighlightToClipboard(SequentViewMenu.this.sequentView, SequentViewMenu.this.pos);
            } else if (((JMenuItem)e.getSource()).getText().startsWith(SequentViewMenu.NAME_CREATION_INFO)) {
                Term t = SequentViewMenu.this.pos.getPosInOccurrence().subTerm();
                ProgramVariable var = (ProgramVariable)t.op();
                ProgramElementName name = var.getProgramElementName();
                NameCreationInfo info = name.getCreationInfo();
                String message = info != null ? info.infoAsString() : "No information available.";
                JOptionPane.showMessageDialog(null, message, "Name creation info", 1);
            }
        }
    }
}

