/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.gui.SearchBar;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.pp.HideSequentPrintFilter;
import de.uka.ilkd.key.pp.IdentitySequentPrintFilter;
import de.uka.ilkd.key.pp.IllegalRegexException;
import de.uka.ilkd.key.pp.Range;
import de.uka.ilkd.key.pp.RegroupSequentPrintFilter;
import de.uka.ilkd.key.pp.SearchSequentPrintFilter;
import de.uka.ilkd.key.pp.SequentPrintFilter;
import de.uka.ilkd.key.util.Pair;
import java.awt.Color;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;

public class SequentViewSearchBar
extends SearchBar {
    private static final long serialVersionUID = 9102464983776181771L;
    public static final ColorSettings.ColorProperty SEARCH_HIGHLIGHT_COLOR_1 = ColorSettings.define("[sequentSearchBar]highlight_1", "", new Color(0, 140, 255, 178));
    public static final ColorSettings.ColorProperty SEARCH_HIGHLIGHT_COLOR_2 = ColorSettings.define("[sequentSearchBar]highlight_2", "", new Color(0, 140, 255, 100));
    private final List<Pair<Integer, Object>> searchResults;
    private int resultIteratorPos;
    private SequentView sequentView;
    private JCheckBox regExpCheckBox;
    private JComboBox<SearchMode> searchModeBox;

    public SequentViewSearchBar(SequentView sequentView) {
        this.sequentView = sequentView;
        this.searchResults = new ArrayList<Pair<Integer, Object>>();
    }

    public void setSequentView(SequentView sequentView) {
        if (this.sequentView != sequentView) {
            sequentView.setFilter(this.sequentView.getFilter(), false);
        }
        this.sequentView = sequentView;
        this.search();
    }

    public SequentView getSequentView() {
        return this.sequentView;
    }

    public void setSearchMode(SearchMode mode) {
        this.searchModeBox.setSelectedItem((Object)mode);
    }

    @Override
    public void createUI() {
        super.createUI();
        this.regExpCheckBox = new JCheckBox("RegExp", false);
        this.regExpCheckBox.setName("toggleRegExpSearch");
        this.regExpCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SequentViewSearchBar.this.searchField.requestFocus();
                if (SequentViewSearchBar.this.sequentView.getFilter() instanceof SearchSequentPrintFilter) {
                    ((SearchSequentPrintFilter)SequentViewSearchBar.this.sequentView.getFilter()).setRegex(SequentViewSearchBar.this.regExpCheckBox.isSelected());
                }
                SequentViewSearchBar.this.search();
            }
        });
        this.regExpCheckBox.setToolTipText("Evaluate as regular expression");
        this.add(this.regExpCheckBox);
        this.searchModeBox = new JComboBox<SearchMode>(SearchMode.values());
        this.searchModeBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    switch ((SearchMode)((Object)SequentViewSearchBar.this.searchModeBox.getSelectedItem())) {
                        case HIDE: {
                            SequentViewSearchBar.this.sequentView.setFilter((SequentPrintFilter)new HideSequentPrintFilter(SequentViewSearchBar.this.sequentView.getLogicPrinter(), SequentViewSearchBar.this.regExpCheckBox.isSelected()), false);
                            SequentViewSearchBar.this.search();
                            break;
                        }
                        case REGROUP: {
                            SequentViewSearchBar.this.sequentView.setFilter((SequentPrintFilter)new RegroupSequentPrintFilter(SequentViewSearchBar.this.sequentView.getLogicPrinter(), SequentViewSearchBar.this.regExpCheckBox.isSelected()), false);
                            SequentViewSearchBar.this.search();
                            break;
                        }
                        case HIGHLIGHT: {
                            SequentViewSearchBar.this.sequentView.setFilter((SequentPrintFilter)new IdentitySequentPrintFilter(), false);
                            SequentViewSearchBar.this.search();
                            break;
                        }
                        default: {
                            SequentViewSearchBar.this.sequentView.setFilter((SequentPrintFilter)new IdentitySequentPrintFilter(), true);
                        }
                    }
                }
            }
        });
        this.searchModeBox.setToolTipText("<html>Determines search behaviour: <b>" + SearchMode.HIDE.displayName + "</b> only shows sequent formulas that match the search. <b>" + SearchMode.REGROUP.displayName + "</b> arranges the matching formulas around the sequence arrow. <b>" + SearchMode.HIGHLIGHT.displayName + "</b> leaves the sequent unchanged.</html>");
        this.add(this.searchModeBox);
    }

    @Override
    public void searchNext() {
        if (!this.searchResults.isEmpty()) {
            this.resetExtraHighlight();
            ++this.resultIteratorPos;
            this.resultIteratorPos %= this.searchResults.size();
            this.setExtraHighlight(this.resultIteratorPos);
        }
    }

    @Override
    public void searchPrevious() {
        if (!this.searchResults.isEmpty()) {
            this.resetExtraHighlight();
            this.resultIteratorPos += this.searchResults.size() - 1;
            this.resultIteratorPos %= this.searchResults.size();
            this.setExtraHighlight(this.resultIteratorPos);
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (this.sequentView != null) {
            if (vis) {
                this.search();
            } else {
                this.clearSearchResults();
                this.searchModeBox.setSelectedIndex(0);
            }
        }
    }

    @Override
    public boolean search(String search) {
        Pattern p;
        this.clearSearchResults();
        if (this.sequentView.getFilter() instanceof SearchSequentPrintFilter) {
            SearchSequentPrintFilter searchSequentPrintFilter = (SearchSequentPrintFilter)this.sequentView.getFilter();
            searchSequentPrintFilter.setLogicPrinter(this.sequentView.getLogicPrinter());
            searchSequentPrintFilter.setSearchString(this.searchField.getText());
        }
        this.sequentView.printSequent();
        if (this.sequentView == null || this.sequentView.getText() == null || search.equals("") || !this.isVisible()) {
            return true;
        }
        this.resultIteratorPos = 0;
        try {
            p = SearchSequentPrintFilter.createPattern((String)search, (boolean)this.regExpCheckBox.isSelected());
            this.searchField.setToolTipText("");
        }
        catch (IllegalRegexException pse) {
            this.searchField.setToolTipText("Not a valid regular expression!");
            return false;
        }
        if (p == null) {
            return false;
        }
        Matcher m = p.matcher(this.sequentView.getText().replace("\u00a0", " "));
        boolean loopEnterd = false;
        while (m.find()) {
            int foundAt = m.start();
            Object highlight = this.sequentView.getColorHighlight(SEARCH_HIGHLIGHT_COLOR_2.get());
            this.searchResults.add((Pair<Integer, Object>)new Pair((Object)foundAt, highlight));
            this.sequentView.paintHighlight(new Range(foundAt, m.end()), highlight);
            loopEnterd = true;
        }
        return loopEnterd;
    }

    public void searchFor(String searchTerm) {
        if (this.regExpCheckBox.isSelected()) {
            String escaped = searchTerm.replaceAll("[-\\[\\]{}()*+?.,\\\\\\\\^$|#\\\\s]", "\\\\$0");
            this.searchField.setText(escaped);
        } else {
            this.searchField.setText(searchTerm);
        }
        this.setVisible(true);
        this.search();
    }

    private void setExtraHighlight(int resultIndex) {
        this.resetHighlight(resultIndex, this.sequentView.getColorHighlight(SEARCH_HIGHLIGHT_COLOR_1.get()));
        this.sequentView.setCaretPosition((Integer)this.searchResults.get((int)resultIndex).first);
    }

    private void resetExtraHighlight() {
        this.resetHighlight(this.resultIteratorPos, this.sequentView.getColorHighlight(SEARCH_HIGHLIGHT_COLOR_2.get()));
    }

    private void resetHighlight(int resultIndex, Object highlight) {
        int pos = (Integer)this.searchResults.get((int)resultIndex).first;
        this.sequentView.removeHighlight(this.searchResults.get((int)resultIndex).second);
        Pair highlightPair = new Pair((Object)pos, highlight);
        this.sequentView.paintHighlight(new Range(pos, pos + this.searchField.getText().length()), highlight);
        this.searchResults.set(resultIndex, (Pair<Integer, Object>)highlightPair);
    }

    private void clearSearchResults() {
        for (Pair<Integer, Object> result : this.searchResults) {
            this.sequentView.removeHighlight(result.second);
        }
        this.searchResults.clear();
    }

    public static enum SearchMode {
        HIGHLIGHT("Highlight", IconFactory.SEARCH_HIGHLIGHT.get(16.0f)),
        HIDE("Hide", IconFactory.SEARCH_HIDE.get(16.0f)),
        REGROUP("Regroup", IconFactory.SEARCH_REGROUP.get(16.0f));

        private String displayName;
        public final Icon icon;

        private SearchMode(String name, Icon icon) {
            this.displayName = name;
            this.icon = icon;
        }

        public String toString() {
            return this.displayName;
        }
    }
}

