/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.nodeviews;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.logic.op.FormulaSV;
import de.uka.ilkd.key.logic.op.ModalOperatorSV;
import de.uka.ilkd.key.logic.op.Operator;
import de.uka.ilkd.key.logic.op.ProgramSV;
import de.uka.ilkd.key.logic.op.SchemaVariable;
import de.uka.ilkd.key.logic.op.SkolemTermSV;
import de.uka.ilkd.key.logic.op.TermLabelSV;
import de.uka.ilkd.key.logic.op.TermSV;
import de.uka.ilkd.key.logic.op.UpdateSV;
import de.uka.ilkd.key.logic.op.VariableSV;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.SequentPrintFilter;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.pp.VisibleTermLabels;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.rule.NewDependingOn;
import de.uka.ilkd.key.rule.NewVarcond;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.rule.Taclet;
import de.uka.ilkd.key.rule.TacletApp;
import de.uka.ilkd.key.rule.inst.GenericSortInstantiations;
import java.util.Iterator;
import org.key_project.util.collection.ImmutableSet;

class TacletDescriber {
    TacletDescriber() {
    }

    private static void writeSVModifiers(StringBuffer out, SchemaVariable sv) {
        boolean started = false;
        if (sv.isRigid() && !(sv instanceof VariableSV)) {
            if (!started) {
                out.append("[");
            }
            out.append("rigid");
            started = true;
        }
        if (sv instanceof ProgramSV && ((ProgramSV)sv).isListSV()) {
            if (!started) {
                out.append("[");
            } else {
                out.append(", ");
            }
            out.append("list");
            started = true;
        }
        if (started) {
            out.append("]");
        }
    }

    private static void writeTacletSchemaVariable(StringBuffer out, SchemaVariable schemaVar) {
        if (schemaVar instanceof ModalOperatorSV) {
            ModalOperatorSV modalOpSV = (ModalOperatorSV)schemaVar;
            String sep = "";
            for (Operator op : modalOpSV.getModalities()) {
                out.append(sep);
                out.append(op.name());
                sep = ", ";
            }
            out.append(" } ").append(modalOpSV.name());
        } else if (schemaVar instanceof TermSV) {
            out.append("\\term");
        } else if (schemaVar instanceof FormulaSV) {
            out.append("\\formula");
        } else if (schemaVar instanceof UpdateSV) {
            out.append("\\update");
        } else if (schemaVar instanceof ProgramSV) {
            out.append("\\program");
        } else if (schemaVar instanceof VariableSV) {
            out.append("\\variables");
        } else if (schemaVar instanceof SkolemTermSV) {
            out.append("\\skolemTerm");
        } else if (schemaVar instanceof TermLabelSV) {
            out.append("\\termlabel");
        } else {
            out.append("?");
        }
        TacletDescriber.writeSVModifiers(out, schemaVar);
        if (!(schemaVar instanceof FormulaSV || schemaVar instanceof UpdateSV || schemaVar instanceof TermLabelSV)) {
            out.append(" ").append(schemaVar.sort().declarationString());
        }
        out.append(" ").append(schemaVar.name());
    }

    private static void writeTacletSchemaVariablesHelper(StringBuffer out, Taclet t) {
        ImmutableSet schemaVars = t.getIfFindVariables();
        for (NewVarcond nvc : t.varsNew()) {
            schemaVars = schemaVars.add((Object)nvc.getSchemaVariable());
        }
        for (NewDependingOn ndo : t.varsNewDependingOn()) {
            schemaVars = schemaVars.add((Object)ndo.first());
        }
        if (!schemaVars.isEmpty()) {
            out.append("\\schemaVariables {\n");
            Iterator iterator = schemaVars.iterator();
            while (iterator.hasNext()) {
                SchemaVariable schemaVar1;
                SchemaVariable schemaVar = schemaVar1 = (SchemaVariable)iterator.next();
                out.append("  ");
                TacletDescriber.writeTacletSchemaVariable(out, schemaVar);
                out.append(";\n");
            }
            out.append("}\n");
        }
    }

    public static String getTacletDescription(KeYMediator mediator, Node node, SequentPrintFilter filter) {
        RuleApp app = node.getAppliedRuleApp();
        Object s = "";
        if (app != null) {
            s = (String)s + "The following rule was applied on this node: \n\n";
            if (app.rule() instanceof Taclet) {
                SequentViewLogicPrinter logicPrinter = new SequentViewLogicPrinter(new ProgramPrinter(null), mediator.getNotationInfo(), mediator.getServices(), true, TacletDescriber.getVisibleTermLabels());
                logicPrinter.printTaclet((Taclet)app.rule());
                s = (String)s + logicPrinter;
            } else {
                s = (String)s + app.rule();
            }
            if (app instanceof TacletApp) {
                TacletApp tapp = (TacletApp)app;
                if (tapp.instantiations().getGenericSortInstantiations() != GenericSortInstantiations.EMPTY_INSTANTIATIONS) {
                    s = (String)s + "\n\nWith sorts:\n";
                    s = (String)s + tapp.instantiations().getGenericSortInstantiations();
                }
                StringBuffer sb = new StringBuffer("\n\n");
                TacletDescriber.writeTacletSchemaVariablesHelper(sb, tapp.taclet());
                s = (String)s + sb;
            }
        } else {
            s = (String)s + "No rule was applied on this node.";
        }
        return s;
    }

    private static VisibleTermLabels getVisibleTermLabels() {
        return MainWindow.getInstance().getVisibleTermLabels();
    }
}

