/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.notification;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.notification.AbandonNotification;
import de.uka.ilkd.key.gui.notification.ExitKeYNotification;
import de.uka.ilkd.key.gui.notification.GeneralFailureNotification;
import de.uka.ilkd.key.gui.notification.GeneralInformationNotification;
import de.uka.ilkd.key.gui.notification.NotificationEventID;
import de.uka.ilkd.key.gui.notification.NotificationTask;
import de.uka.ilkd.key.gui.notification.ProofClosedNotification;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.proof.ProofEvent;
import java.util.EnumMap;
import java.util.Map;
import javax.swing.JFrame;

public class NotificationManager {
    private Map<NotificationEventID, NotificationTask> notificationTasks = new EnumMap<NotificationEventID, NotificationTask>(NotificationEventID.class);
    private boolean autoMode = false;
    private NotificationListener notificationListener = new NotificationListener();

    public void setDefaultNotification(JFrame comp) {
        this.notificationTasks.clear();
        this.addNotificationTask(new ProofClosedNotification(comp));
        this.addNotificationTask(new GeneralFailureNotification(comp));
        this.addNotificationTask(new GeneralInformationNotification(comp));
        this.addNotificationTask(new AbandonNotification());
        this.addNotificationTask(new ExitKeYNotification());
    }

    public NotificationManager(KeYMediator mediator, JFrame comp) {
        mediator.getUI().getProofControl().addAutoModeListener(this.notificationListener);
        this.setDefaultNotification(comp);
    }

    public void addNotificationTask(NotificationTask task) {
        this.notificationTasks.put(task.getEventID(), task);
    }

    public void removeNotificationTask(NotificationTask task) {
        this.removeNotificationTask(task.getEventID());
    }

    public NotificationTask removeNotificationTask(NotificationEventID eventID) {
        return this.notificationTasks.remove((Object)eventID);
    }

    public boolean inAutoMode() {
        return this.autoMode;
    }

    public void handleNotificationEvent(NotificationEvent event) {
        NotificationTask notificationTask = this.notificationTasks.get((Object)event.getEventID());
        if (notificationTask != null) {
            notificationTask.execute(event, this);
        }
    }

    private class NotificationListener
    implements AutoModeListener {
        private NotificationListener() {
        }

        public void autoModeStarted(ProofEvent e) {
            NotificationManager.this.autoMode = true;
        }

        public void autoModeStopped(ProofEvent e) {
            NotificationManager.this.autoMode = false;
        }
    }
}

