/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.notification;

import de.uka.ilkd.key.gui.notification.NotificationAction;
import de.uka.ilkd.key.gui.notification.NotificationEventID;
import de.uka.ilkd.key.gui.notification.NotificationManager;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class NotificationTask {
    private List<NotificationAction> notificationActions = new ArrayList<NotificationAction>(5);

    public List<NotificationAction> getNotificationActions() {
        return this.notificationActions;
    }

    public void addNotificationAction(NotificationAction action) {
        this.notificationActions.add(action);
    }

    public void execute(NotificationEvent event, NotificationManager manager) {
        if (manager.inAutoMode() && !this.automodeEnabledTask()) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.executeActions(event, manager);
        } else {
            final NotificationEvent eventObject = event;
            final NotificationManager notManager = manager;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    NotificationTask.this.executeActions(eventObject, notManager);
                }
            });
        }
    }

    protected void executeActions(NotificationEvent event, NotificationManager manager) {
        for (NotificationAction action : this.getNotificationActions()) {
            action.execute(event);
        }
    }

    public abstract NotificationEventID getEventID();

    protected boolean automodeEnabledTask() {
        return false;
    }
}

