/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.notification.actions;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.ShowProofStatistics;
import de.uka.ilkd.key.gui.notification.actions.ShowDisplayPane;
import de.uka.ilkd.key.gui.notification.events.NotificationEvent;
import de.uka.ilkd.key.gui.notification.events.ProofClosedNotificationEvent;
import de.uka.ilkd.key.proof.Proof;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.UIManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofClosedJTextPaneDisplay
extends ShowDisplayPane {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProofClosedJTextPaneDisplay.class);

    public ProofClosedJTextPaneDisplay(Frame parentComponent) {
        super(parentComponent);
    }

    @Override
    public synchronized boolean execute(NotificationEvent pcne) {
        if (pcne instanceof ProofClosedNotificationEvent) {
            Proof proof = ((ProofClosedNotificationEvent)pcne).getProof();
            if (proof != null) {
                ShowProofStatistics.Window win = new ShowProofStatistics.Window(MainWindow.getInstance(), proof);
                win.setVisible(true);
            }
        } else {
            this.setMessage("Proof Closed. No statistics available.");
            JEditorPane contentPane = new JEditorPane("text/html", this.getMessage());
            contentPane.setEditable(false);
            contentPane.setBorder(BorderFactory.createEmptyBorder());
            contentPane.setCaretPosition(0);
            contentPane.setBackground(MainWindow.getInstance().getBackground());
            contentPane.setSize(new Dimension(10, 360));
            contentPane.setPreferredSize(new Dimension(contentPane.getPreferredSize().width + 15, 360));
            JScrollPane scrollPane = new JScrollPane(contentPane);
            scrollPane.setBorder(BorderFactory.createEmptyBorder());
            Font myFont = UIManager.getFont("KEY_FONT_PROOF_TREE");
            if (myFont != null) {
                contentPane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
                contentPane.setFont(myFont);
            } else {
                LOGGER.debug("KEY_FONT_PROOF_TREE not available. Use standard font.");
            }
            JOptionPane.showMessageDialog(this.parentComponent, scrollPane, "Proof closed", 1);
        }
        return true;
    }
}

