/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.originlabels;

import bibliothek.gui.dock.common.DefaultSingleCDockable;
import de.uka.ilkd.key.control.TermLabelVisibilityManager;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.NodeInfoVisualizer;
import de.uka.ilkd.key.gui.nodeviews.SequentView;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.IntIterator;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.PosInTerm;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.SequentFormula;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.pp.IdentitySequentPrintFilter;
import de.uka.ilkd.key.pp.InitialPositionTable;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.pp.Range;
import de.uka.ilkd.key.pp.SequentPrintFilter;
import de.uka.ilkd.key.pp.SequentViewLogicPrinter;
import de.uka.ilkd.key.pp.ShowSelectedSequentPrintFilter;
import de.uka.ilkd.key.pp.VisibleTermLabels;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.ProofTreeAdapter;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import de.uka.ilkd.key.proof.ProofTreeListener;
import de.uka.ilkd.key.proof.RuleAppListener;
import de.uka.ilkd.key.proof.event.ProofDisposedEvent;
import de.uka.ilkd.key.proof.event.ProofDisposedListener;
import de.uka.ilkd.key.util.pp.UnbalancedBlocksException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.key_project.util.collection.ImmutableArray;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public final class OriginTermLabelVisualizer
extends NodeInfoVisualizer {
    private static final long serialVersionUID = -9190616436091589798L;
    public static final Color HIGHLIGHT_COLOR = Color.ORANGE;
    public static final String ORIGIN_INFO_TITLE = "Origin information";
    public static final String ORIGIN_TITLE = "Origin of formula";
    public static final String SUBTERM_ORIGINS_TITLE = "Origins of (former) subformulas and subterms";
    public static final int TREE_CELL_GAP = 20;
    public static final int COMPONENT_GAP = 20;
    private TermView view;
    private JTree tree;
    private PosInOccurrence highlight;
    private JButton nodeLinkButton;
    private Action nodeLinkAction = new AbstractAction(){
        private static final long serialVersionUID = -5322782759362752086L;

        @Override
        public void actionPerformed(ActionEvent e) {
            KeYMediator mediator = MainWindow.getInstance().getMediator();
            if (!mediator.getSelectedProof().equals(OriginTermLabelVisualizer.this.getNode().proof())) {
                int choice = JOptionPane.showOptionDialog(OriginTermLabelVisualizer.this, "The proof containing this node is not currently selected. Do you want to select it?", "Switch Proof?", 0, 3, null, null, null);
                if (choice == 0) {
                    mediator.setProof(OriginTermLabelVisualizer.this.getNode().proof());
                } else {
                    return;
                }
            }
            mediator.getSelectionModel().setSelectedNode(OriginTermLabelVisualizer.this.getNode());
            ((DefaultSingleCDockable)MainWindow.getInstance().getDockSequent()).toFront();
        }
    };
    private RuleAppListener ruleAppListener = event -> this.updateNodeLink();
    private ProofTreeListener proofTreeListener = new ProofTreeAdapter(){

        public void proofStructureChanged(ProofTreeEvent e) {
            OriginTermLabelVisualizer.this.updateNodeLink();
        }

        public void proofPruned(ProofTreeEvent e) {
            OriginTermLabelVisualizer.this.updateNodeLink();
        }

        public void proofGoalsChanged(ProofTreeEvent e) {
            OriginTermLabelVisualizer.this.updateNodeLink();
        }

        public void proofExpanded(ProofTreeEvent e) {
            OriginTermLabelVisualizer.this.updateNodeLink();
        }
    };
    private ProofDisposedListener proofDisposedListener = new ProofDisposedListener(){

        public void proofDisposing(ProofDisposedEvent e) {
        }

        public void proofDisposed(ProofDisposedEvent e) {
            OriginTermLabelVisualizer.this.updateNodeLink();
        }
    };
    private Services services;
    private PosInOccurrence termPio;
    private Sequent sequent;

    public OriginTermLabelVisualizer(PosInOccurrence pos, Node node, Services services) {
        super(node, "Origin for node " + node.serialNr() + ": " + (pos == null ? "whole sequent" : LogicPrinter.quickPrintTerm((Term)pos.subTerm(), (Services)services).replaceAll("\\s+", " ")), "Node " + node.serialNr());
        this.services = services;
        this.termPio = pos;
        this.sequent = node.sequent();
        this.setVisible(true);
        this.setLayout(new BorderLayout());
        this.initHeadPane();
        final JSplitPane bodyPane = new JSplitPane(1);
        String borderTitle = pos == null ? "selected sequent" : (pos.isInAntec() ? "selected formula in antecedent" : "selected formula in succedent");
        this.initTree(bodyPane, borderTitle);
        this.initView(bodyPane, borderTitle);
        this.add((Component)bodyPane, "Center");
        this.addAncestorListener(new AncestorListener(){
            private boolean setup = false;

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                OriginTermLabelVisualizer.this.view.removeUserSelectionHighlight();
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                if (!this.setup && bodyPane.getSize() != null && !bodyPane.getSize().equals(new Dimension())) {
                    this.setup = true;
                    bodyPane.getLeftComponent().setMinimumSize(new Dimension());
                    bodyPane.getRightComponent().setMinimumSize(new Dimension());
                    bodyPane.setDividerLocation(1.0);
                    bodyPane.setResizeWeight(1.0);
                    bodyPane.setOneTouchExpandable(true);
                }
                OriginTermLabelVisualizer.this.tree.revalidate();
                OriginTermLabelVisualizer.this.tree.repaint();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
                this.ancestorMoved(event);
            }
        });
    }

    @Override
    public void dispose() {
        if (!this.getNode().proof().isDisposed()) {
            this.getNode().proof().removeRuleAppListener(this.ruleAppListener);
            this.getNode().proof().removeProofTreeListener(this.proofTreeListener);
            this.getNode().proof().removeProofDisposedListener(this.proofDisposedListener);
        }
        this.view.removeUserSelectionHighlight();
        this.ruleAppListener = null;
        this.proofTreeListener = null;
        this.proofDisposedListener = null;
        this.services = null;
        this.termPio = null;
        this.sequent = null;
        super.dispose();
    }

    private void initHeadPane() {
        Node node = this.getNode();
        JPanel headPane = new JPanel();
        headPane.setLayout(new BoxLayout(headPane, 3));
        JPanel top = new JPanel();
        top.setLayout(new BoxLayout(top, 2));
        top.add(new JLabel("Node: "));
        this.nodeLinkButton = new JButton();
        top.add(this.nodeLinkButton);
        headPane.add(top);
        JPanel bot = new JPanel();
        JLabel label = new JLabel("Proof: \"" + node.proof().name().toString() + "\"");
        label.setMinimumSize(new Dimension(top.getWidth(), label.getMinimumSize().height));
        bot.setLayout(new BoxLayout(bot, 2));
        bot.add(label);
        headPane.add(bot);
        this.nodeLinkButton.setAction(this.nodeLinkAction);
        this.updateNodeLink();
        node.proof().addRuleAppListener(this.ruleAppListener);
        node.proof().addProofTreeListener(this.proofTreeListener);
        node.proof().addProofDisposedListener(this.proofDisposedListener);
        this.add((Component)headPane, "First");
    }

    private void initTree(JSplitPane bodyPane, String borderTitle) {
        DefaultTreeModel treeModel = this.buildModel(this.termPio);
        this.tree = new JTree(treeModel);
        this.tree.setCellRenderer(new CellRenderer());
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        this.tree.addTreeSelectionListener(e -> {
            TreeNode source = (TreeNode)this.tree.getLastSelectedPathComponent();
            if (source == null || source.pos == null) {
                this.highlight = null;
                this.highlightInView(null);
            } else {
                this.highlight = source.pos;
                this.highlightInView(source.pos);
            }
            this.revalidate();
            this.repaint();
        });
        final JScrollPane treeScrollPane = new JScrollPane(this.tree, 22, 31);
        treeScrollPane.setBorder(new TitledBorder(borderTitle + " as tree"));
        bodyPane.add(treeScrollPane);
        treeScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OriginTermLabelVisualizer.this.tree.setSize(treeScrollPane.getViewport().getSize());
                OriginTermLabelVisualizer.this.tree.setUI(new BasicTreeUI());
            }
        });
    }

    private void initView(JSplitPane bodyPane, String borderTitle) {
        this.view = new TermView(this.termPio, this.getNode(), MainWindow.getInstance());
        this.view.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PosInSequent pis = OriginTermLabelVisualizer.this.view.getLastPosInSequent();
                if (pis == null || Objects.equals(OriginTermLabelVisualizer.this.highlight, pis.getPosInOccurrence())) {
                    OriginTermLabelVisualizer.this.highlight = null;
                    OriginTermLabelVisualizer.this.view.removeUserSelectionHighlight();
                    OriginTermLabelVisualizer.this.highlightInTree(null);
                } else {
                    OriginTermLabelVisualizer.this.highlight = pis.getPosInOccurrence();
                    ImmutableList<Integer> path = OriginTermLabelVisualizer.this.getPosTablePath(pis.getPosInOccurrence());
                    OriginTermLabelVisualizer.this.highlightInView(pis.getPosInOccurrence());
                    OriginTermLabelVisualizer.this.highlightInTree(OriginTermLabelVisualizer.this.getTreePath(path));
                    OriginTermLabelVisualizer.this.revalidate();
                    OriginTermLabelVisualizer.this.repaint();
                }
            }
        });
        JScrollPane viewScrollPane = new JScrollPane(this.view, 22, 30);
        viewScrollPane.setBorder(new TitledBorder(borderTitle));
        this.view.printSequent();
        bodyPane.add(viewScrollPane);
        viewScrollPane.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                OriginTermLabelVisualizer.this.view.printSequent();
            }
        });
    }

    private void updateNodeLink() {
        Node node = this.getNode();
        if (node.proof().isDisposed() || !node.proof().find(node)) {
            this.nodeLinkButton.setText("DELETED NODE");
            this.nodeLinkAction.setEnabled(false);
            OriginTermLabelVisualizer.unregister(this);
        } else if (this.nodeLinkButton.isEnabled()) {
            this.nodeLinkButton.setText(node.serialNr() + ": " + node.name());
        }
    }

    private PosInOccurrence convertPio(PosInOccurrence pio) {
        if (this.termPio == null) {
            return pio;
        }
        if (pio == null) {
            return new PosInOccurrence(this.termPio.sequentFormula(), this.termPio.posInTerm(), this.termPio.isInAntec());
        }
        PosInTerm completePos = this.termPio.posInTerm();
        IntIterator it = pio.posInTerm().iterator();
        while (it.hasNext()) {
            completePos = completePos.down(it.next());
        }
        return new PosInOccurrence(this.termPio.sequentFormula(), completePos, this.termPio.isInAntec());
    }

    private DefaultTreeModel buildModel(PosInOccurrence pos) {
        TreeNode root = new TreeNode(pos);
        DefaultTreeModel result = new DefaultTreeModel(root);
        this.buildModel(root, pos, result);
        return result;
    }

    private void buildModel(TreeNode parentNode, PosInOccurrence parentPos, DefaultTreeModel treeModel) {
        if (parentPos == null) {
            TreeNode childNode;
            PosInOccurrence childPos;
            int index = 0;
            ImmutableList children = this.sequent.antecedent().asList();
            for (SequentFormula child : children) {
                childPos = new PosInOccurrence(child, PosInTerm.getTopLevel(), true);
                childNode = new TreeNode(childPos);
                treeModel.insertNodeInto(childNode, parentNode, index);
                this.buildModel(childNode, childPos, treeModel);
                ++index;
            }
            children = this.sequent.succedent().asList();
            for (SequentFormula child : children) {
                childPos = new PosInOccurrence(child, PosInTerm.getTopLevel(), false);
                childNode = new TreeNode(childPos);
                treeModel.insertNodeInto(childNode, parentNode, index);
                this.buildModel(childNode, childPos, treeModel);
                ++index;
            }
        } else {
            ImmutableArray children = parentPos.subTerm().subs();
            for (int i = 0; i < children.size(); ++i) {
                TreeNode childNode = new TreeNode(parentPos.down(i));
                treeModel.insertNodeInto(childNode, parentNode, i);
                this.buildModel(childNode, parentPos.down(i), treeModel);
            }
        }
    }

    private void highlightInTree(TreePath path) {
        this.tree.getSelectionModel().setSelectionPath(path);
    }

    private void highlightInView(PosInOccurrence pio) {
        if (pio == null) {
            this.view.removeUserSelectionHighlight();
            return;
        }
        try {
            this.view.setUserSelectionHighlight(PosInSequent.createCfmaPos((PosInOccurrence)pio));
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    private ImmutableList<Integer> getPosTablePath(PosInOccurrence pos) {
        if (pos == null) {
            return ImmutableSLList.nil().prepend((Object)0);
        }
        InitialPositionTable posTable = this.view.posTable;
        ImmutableList path = posTable.pathForPosition(pos, this.view.getFilter());
        if (this.termPio != null) {
            ImmutableList prefixPath = posTable.pathForPosition(this.termPio, this.view.getFilter());
            int n = prefixPath.size();
            for (int i = 0; i < n; ++i) {
                assert (path.head() == prefixPath.head());
                path = path.tail();
                prefixPath = prefixPath.tail();
            }
            path = path.prepend((Object)0).prepend((Object)0);
        }
        return path;
    }

    private TreePath getTreePath(ImmutableList<Integer> posTablePath) {
        posTablePath = this.termPio != null ? posTablePath.tail().tail() : posTablePath.tail();
        TreeNode lastNode = (TreeNode)this.tree.getModel().getRoot();
        TreePath result = new TreePath(lastNode);
        if (posTablePath != null) {
            Iterator iterator = posTablePath.iterator();
            while (iterator.hasNext()) {
                int i = (Integer)iterator.next();
                lastNode = (TreeNode)lastNode.getChildAt(i);
                result = result.pathByAddingChild(lastNode);
            }
        }
        return result;
    }

    private String getTooltipText(PosInOccurrence pio) {
        if (pio == null) {
            return null;
        }
        OriginTermLabel label = (OriginTermLabel)pio.subTerm().getLabel(OriginTermLabel.NAME);
        OriginTermLabel.Origin origin = OriginTermLabel.getOrigin((PosInOccurrence)pio);
        return "<html>Origin of selected term: <b>" + (Comparable)((Object)(origin == null ? "" : origin)) + "</b><hr>Origin of (former) sub-terms:<br>" + (label == null ? "" : label.getSubtermOrigins().stream().map(o -> o + "<br>").reduce("", String::concat));
    }

    private class TermView
    extends SequentView {
        private static final long serialVersionUID = -8328975160581938309L;
        private InitialPositionTable posTable;
        private Node node;

        TermView(final PosInOccurrence pos, Node node, MainWindow mainWindow) {
            super(mainWindow);
            this.posTable = new InitialPositionTable();
            this.node = node;
            NotationInfo ni = new NotationInfo();
            if (OriginTermLabelVisualizer.this.services != null) {
                ni.refresh(OriginTermLabelVisualizer.this.services, NotationInfo.DEFAULT_PRETTY_SYNTAX, NotationInfo.DEFAULT_UNICODE_ENABLED);
            }
            this.setLogicPrinter(new SequentViewLogicPrinter(new ProgramPrinter(), ni, OriginTermLabelVisualizer.this.services, (VisibleTermLabels)new TermLabelVisibilityManager()){

                public void printSequent(SequentPrintFilter filter, boolean finalbreak) {
                    try {
                        ImmutableList antec = filter.getFilteredAntec();
                        ImmutableList succ = filter.getFilteredSucc();
                        this.markStartSub();
                        this.startTerm(antec.size() + succ.size());
                        this.layouter.beginC(1).ind();
                        this.printSemisequent(antec);
                        if (pos == null) {
                            this.layouter.brk(1, -1);
                            this.printSequentArrow();
                            this.layouter.brk(1);
                        }
                        this.printSemisequent(succ);
                        if (finalbreak) {
                            this.layouter.brk(0);
                        }
                        this.markEndSub();
                        this.layouter.end();
                    }
                    catch (IOException e) {
                        throw new RuntimeException("IO Exception in pretty printer:\n" + e);
                    }
                    catch (UnbalancedBlocksException e) {
                        throw new RuntimeException("Unbalanced blocks in pretty printer:\n" + e);
                    }
                }
            });
            if (pos != null) {
                this.setFilter((SequentPrintFilter)new ShowSelectedSequentPrintFilter(pos), true);
            } else {
                this.setFilter((SequentPrintFilter)new IdentitySequentPrintFilter(), true);
            }
        }

        @Override
        protected synchronized PosInSequent getPosInSequent(Point p) {
            PosInSequent pis = super.getPosInSequent(p);
            PosInOccurrence pio = OriginTermLabelVisualizer.this.convertPio(pis == null ? null : pis.getPosInOccurrence());
            return pio == null ? null : PosInSequent.createCfmaPos((PosInOccurrence)pio);
        }

        @Override
        public String getToolTipText(MouseEvent event) {
            PosInSequent pis = this.getPosInSequent(event.getPoint());
            if (pis == null) {
                return null;
            }
            return OriginTermLabelVisualizer.this.getTooltipText(pis.getPosInOccurrence());
        }

        @Override
        public SequentPrintFilter getFilter() {
            return super.getFilter();
        }

        @Override
        public void setUserSelectionHighlight(PosInSequent pis) {
            ImmutableList<Integer> path = OriginTermLabelVisualizer.this.getPosTablePath(pis == null ? null : pis.getPosInOccurrence());
            Range range = OriginTermLabelVisualizer.this.view.posTable.rangeForPath(path);
            range = new Range(range.start() + 1, range.end() + 1);
            pis.setBounds(range);
            super.setUserSelectionHighlight(pis);
        }

        @Override
        public void setUserSelectionHighlight(Point point) {
            super.setUserSelectionHighlight(point);
        }

        @Override
        public void removeUserSelectionHighlight() {
            super.removeUserSelectionHighlight();
        }

        @Override
        public String getTitle() {
            return "Selected term";
        }

        @Override
        public boolean isMainSequentView() {
            return false;
        }

        @Override
        public final synchronized void printSequent() {
            this.getLogicPrinter().update(this.getFilter(), this.computeLineWidth());
            this.setText(this.getSyntaxHighlighter().process(this.getLogicPrinter().toString(), this.node));
            this.posTable = this.getLogicPrinter().getInitialPositionTable();
            this.updateHidingProperty();
        }
    }

    private class TreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -406981141537547226L;
        private PosInOccurrence pos;
        private Term term;

        private TreeNode(PosInOccurrence pos) {
            super(pos);
            this.pos = pos;
            if (pos != null) {
                this.term = pos.subTerm();
            }
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = -7479404026154193661L;

        private CellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            TreeNode node = (TreeNode)value;
            PosInOccurrence pio = node.pos;
            Term term = node.term;
            assert (pio.subTerm().equals(term));
            BasicTreeUI ui = (BasicTreeUI)tree.getUI();
            JLabel termTextLabel = (JLabel)super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            termTextLabel.setMinimumSize(new Dimension());
            termTextLabel.setText(this.getShortTermText(term));
            termTextLabel.setBackground(OriginTermLabelVisualizer.this.getBackground());
            JLabel originTextLabel = new JLabel();
            OriginTermLabel.Origin origin = OriginTermLabel.getOrigin((PosInOccurrence)pio);
            if (origin != null) {
                originTextLabel.setText(this.getShortOriginText(origin));
                originTextLabel.setHorizontalAlignment(11);
            }
            JPanel result = new JPanel(new BorderLayout(20, 20));
            int indent = (ui.getLeftChildIndent() + ui.getRightChildIndent()) * node.getLevel();
            result.setPreferredSize(new Dimension(tree.getWidth() - indent, super.getPreferredSize().height));
            result.add((Component)termTextLabel, "Before");
            result.add((Component)originTextLabel, "After");
            result.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            result.setBackground(Color.WHITE);
            result.setToolTipText(OriginTermLabelVisualizer.this.getTooltipText(pio));
            return result;
        }

        private String getShortOriginText(OriginTermLabel.Origin origin) {
            return origin.specType.toString();
        }

        private String getShortTermText(Term term) {
            String text = term == null ? LogicPrinter.quickPrintSequent((Sequent)OriginTermLabelVisualizer.this.sequent, (Services)OriginTermLabelVisualizer.this.services) : LogicPrinter.quickPrintTerm((Term)term, (Services)OriginTermLabelVisualizer.this.services);
            int endIndex = text.indexOf("\n");
            if (endIndex != text.length() - 1) {
                return text.replaceAll("\\s+", " ") + " ...";
            }
            return text.substring(0, endIndex).replaceAll("\\s+", " ");
        }
    }
}

