/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.originlabels;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.NodeInfoVisualizer;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.extension.api.ContextMenuKind;
import de.uka.ilkd.key.gui.extension.api.DefaultContextMenuKind;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.originlabels.ShowOriginAction;
import de.uka.ilkd.key.gui.originlabels.ToggleOriginHighlightAction;
import de.uka.ilkd.key.gui.originlabels.ToggleTermOriginTrackingAction;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.proof.Node;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;

@KeYGuiExtension.Info(name="Origin Tracking", optional=true, description="UI support for origin tracking", experimental=false)
public class OriginTermLabelsExt
implements KeYGuiExtension,
KeYGuiExtension.ContextMenu,
KeYGuiExtension.Tooltip,
KeYGuiExtension.MainMenu,
KeYGuiExtension.TermInfo {
    private ToggleTermOriginTrackingAction toggleTrackingAction;
    private ToggleOriginHighlightAction toggleSourceViewHighlightAction;

    private ToggleTermOriginTrackingAction getToggleTrackingAction(MainWindow mainWindow) {
        if (this.toggleTrackingAction == null) {
            this.toggleTrackingAction = new ToggleTermOriginTrackingAction(mainWindow);
        }
        return this.toggleTrackingAction;
    }

    private ToggleOriginHighlightAction getToggleSourceViewHighlightAction(MainWindow mainWindow) {
        if (this.toggleSourceViewHighlightAction == null) {
            this.toggleSourceViewHighlightAction = new ToggleOriginHighlightAction(mainWindow);
        }
        return this.toggleSourceViewHighlightAction;
    }

    @Override
    public List<Action> getMainMenuActions(MainWindow mainWindow) {
        LinkedList<Action> result = new LinkedList<Action>();
        result.add(this.getToggleTrackingAction(mainWindow));
        result.add(this.getToggleSourceViewHighlightAction(mainWindow));
        return result;
    }

    @Override
    public List<Action> getContextActions(KeYMediator mediator, ContextMenuKind kind, Object underlyingObject) {
        if (kind == DefaultContextMenuKind.SEQUENT_VIEW) {
            return Collections.singletonList(new ShowOriginAction((PosInSequent)underlyingObject));
        }
        if (kind == DefaultContextMenuKind.PROOF_TREE && underlyingObject instanceof Node) {
            Node node = (Node)underlyingObject;
            return NodeInfoVisualizer.getInstances(node).stream().map(x$0 -> new OpenVisualizerAction((NodeInfoVisualizer)x$0)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    public List<String> getTermInfoStrings(MainWindow mainWindow, PosInSequent pos) {
        OriginTermLabel.Origin origin = OriginTermLabel.getOrigin((PosInSequent)pos);
        LinkedList<String> result = new LinkedList<String>();
        if (origin != null) {
            result.add("Origin: " + origin);
        }
        return result;
    }

    @Override
    public List<String> getTooltipStrings(MainWindow mainWindow, PosInSequent pos) {
        PosInOccurrence pio;
        OriginTermLabel label;
        if (pos == null || pos.isSequent()) {
            return Collections.emptyList();
        }
        OriginTermLabel.Origin origin = OriginTermLabel.getOrigin((PosInSequent)pos);
        Object result = "";
        if (origin != null) {
            result = (String)result + "<b>Origin:</b> " + origin + "<br>";
        }
        OriginTermLabel originTermLabel = label = (pio = pos.getPosInOccurrence()) == null ? null : (OriginTermLabel)pio.subTerm().getLabel(OriginTermLabel.NAME);
        if (label != null && !label.getSubtermOrigins().isEmpty()) {
            result = (String)result + "<b>Origin of (former) sub-terms:</b><br>" + label.getSubtermOrigins().stream().map(o -> o + "<br>").reduce("", String::concat);
        }
        LinkedList<String> resultList = new LinkedList<String>();
        resultList.add((String)result);
        return resultList;
    }

    private static final class OpenVisualizerAction
    extends KeyAction {
        private static final long serialVersionUID = -2936000510977056583L;
        private NodeInfoVisualizer vis;

        private OpenVisualizerAction(NodeInfoVisualizer vis) {
            this.setName(vis.getLongName());
            this.setMenuPath("Windows");
            this.setIcon(IconFactory.WINDOW_ICON.get());
            this.vis = vis;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MainWindow.getInstance().getSourceViewFrame().toFront(this.vis);
        }
    }
}

