/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.originlabels;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.originlabels.OriginTermLabelVisualizer;
import de.uka.ilkd.key.logic.PosInOccurrence;
import de.uka.ilkd.key.logic.sort.Sort;
import de.uka.ilkd.key.pp.PosInSequent;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.TermLabelSettings;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class ShowOriginAction
extends MainWindowAction {
    private static final long serialVersionUID = 4557953425770258852L;
    private PosInSequent pos;

    public ShowOriginAction(PosInSequent pos) {
        super(MainWindow.getInstance());
        this.pos = pos == null ? PosInSequent.createSequentPos() : pos;
        TermLabelSettings settings = ProofIndependentSettings.DEFAULT_INSTANCE.getTermLabelSettings();
        this.setName("Show origin");
        this.setEnabled(settings.getUseOriginLabels());
        settings.addSettingsListener(event -> this.setEnabled(settings.getUseOriginLabels()));
        this.setMenuPath("View");
        this.lookupAcceleratorKey();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        PosInOccurrence pio = this.pos.getPosInOccurrence();
        if (pio != null) {
            while (!pio.subTerm().sort().equals(Sort.FORMULA)) {
                pio = pio.up();
            }
        }
        final OriginTermLabelVisualizer vis = new OriginTermLabelVisualizer(pio, this.getMediator().getSelectedNode(), this.getMediator().getServices());
        this.mainWindow.getSourceViewFrame().addComponent(vis, vis.getLongName(), new AbstractAction(){
            private static final long serialVersionUID = 2410334588447893970L;

            @Override
            public void actionPerformed(ActionEvent e) {
                ShowOriginAction.this.mainWindow.getSourceViewFrame().removeComponent(vis);
                vis.dispose();
            }
        });
    }
}

