/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.originlabels;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.actions.QuickLoadAction;
import de.uka.ilkd.key.gui.actions.QuickSaveAction;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Sequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.label.OriginTermLabel;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.TermLabelSettings;
import java.awt.event.ActionEvent;
import javax.swing.JOptionPane;

public class ToggleTermOriginTrackingAction
extends MainWindowAction {
    private static final long serialVersionUID = -2092724865788720558L;

    public ToggleTermOriginTrackingAction(MainWindow mainWindow) {
        super(mainWindow);
        this.setName("Toggle Term Origin Tracking");
        this.setTooltip("Track where in the JML specification a every term in the sequent originates.");
        this.setIcon(IconFactory.ORIGIN_LABELS.get(16.0f));
        this.setEnabled(true);
        this.setSelected(ProofIndependentSettings.DEFAULT_INSTANCE.getTermLabelSettings().getUseOriginLabels());
        this.setMenuPath("Origin Tracking");
        this.putValue("LongDescription", "Toggle Term Origin Tracking");
        this.putValue("CHECKBOX", true);
        this.lookupAcceleratorKey();
    }

    private void handleAction() {
        Proof proof = this.mainWindow.getMediator().getSelectedProof();
        TermLabelSettings settings = ProofIndependentSettings.DEFAULT_INSTANCE.getTermLabelSettings();
        if (proof != null) {
            Services services = proof.getServices();
            if (!settings.getUseOriginLabels()) {
                for (Proof p : services.getSpecificationRepository().getAllProofs()) {
                    for (Goal g : p.openGoals()) {
                        g.setSequent(OriginTermLabel.removeOriginLabels((Sequent)g.sequent(), (Services)services));
                    }
                }
                services.getSpecificationRepository().map(term -> OriginTermLabel.removeOriginLabels((Term)term, (Services)services), services);
            }
            this.mainWindow.getMediator().getSelectionModel().fireSelectedNodeChanged();
        }
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        TermLabelSettings settings = ProofIndependentSettings.DEFAULT_INSTANCE.getTermLabelSettings();
        if (!settings.getUseOriginLabels()) {
            Object[] options = new Object[]{"Reload", "Continue without reloading", "Cancel"};
            int selection = JOptionPane.showOptionDialog(this.mainWindow, "Origin information will be added to all newly loaded proofs.\nTo see origin information in your current proof, you need to reload it.", "Origin", -1, 1, null, options, options[2]);
            switch (selection) {
                case 0: {
                    QuickSaveAction.quickSave(this.mainWindow);
                    QuickLoadAction.quickLoad(this.mainWindow);
                }
                case 1: {
                    settings.setUseOriginLabels(!settings.getUseOriginLabels());
                    this.handleAction();
                }
            }
        } else {
            Object[] options = new Object[]{"Remove", "Cancel"};
            int selection = JOptionPane.showOptionDialog(this.mainWindow, "All origin information will be removed from every open goal and every proof obligation.", "Origin", -1, 1, null, options, options[1]);
            if (selection == 0) {
                settings.setUseOriginLabels(!settings.getUseOriginLabels());
                this.handleAction();
            }
        }
        this.setSelected(ProofIndependentSettings.DEFAULT_INSTANCE.getTermLabelSettings().getUseOriginLabels());
    }
}

