/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.proofdiff;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.proofdiff.diff_match_patch;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.pp.NotationInfo;
import de.uka.ilkd.key.pp.ProgramPrinter;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class ProofDiffFrame
extends JFrame {
    private static final long serialVersionUID = -1593379776744771923L;
    private JEditorPane textArea;
    private JTextField from;
    private JTextField to;
    private final MainWindow mainWindow;

    public ProofDiffFrame(MainWindow mainWindow) {
        super("Visual difference between two sequents");
        this.mainWindow = mainWindow;
        this.guiInit();
    }

    private void guiInit() {
        Container cp = this.getContentPane();
        this.setLayout(new BorderLayout());
        this.textArea = new JEditorPane();
        this.textArea.setContentType("text/html");
        Font myFont = UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW");
        this.textArea.setFont(myFont);
        this.textArea.setEditable(false);
        this.textArea.setText(this.getHelpText());
        JScrollPane scroll = new JScrollPane(this.textArea);
        cp.add((Component)scroll, "Center");
        JPanel bottom = new JPanel(new FlowLayout(2));
        this.from = new JTextField("", 5);
        this.from.setToolTipText("Set the parent node to compare. May be empty for the direct predecessor");
        bottom.add(new JLabel("Parent node:"));
        bottom.add(this.from);
        this.to = new JTextField("", 5);
        this.to.setToolTipText("Set the child node to compare. Must not be empty");
        bottom.add(new JLabel("Proof node:"));
        bottom.add(this.to);
        JButton go = new JButton("Show Diff");
        go.setToolTipText("Show difference between the two nodes specified here.");
        go.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofDiffFrame.this.showDiff();
            }
        });
        bottom.add(go);
        this.getRootPane().setDefaultButton(go);
        JButton last = new JButton("Show Selected Node");
        last.setToolTipText("Show difference introduced by the rule application leading to the selected node");
        last.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofDiffFrame.this.setSelectedNode();
                ProofDiffFrame.this.showDiff();
            }
        });
        bottom.add(last);
        JButton close = new JButton("Close");
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProofDiffFrame.this.setVisible(false);
            }
        });
        bottom.add(close);
        cp.add((Component)bottom, "South");
        this.setSize(700, 600);
    }

    private void setSelectedNode() {
        try {
            Node node = this.mainWindow.getMediator().getSelectedNode();
            if (node == null) {
                throw new IllegalArgumentException("There is no selected proof node or no proof!");
            }
            this.from.setText("");
            this.to.setText(Integer.toString(node.serialNr()));
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            return;
        }
    }

    private void showDiff() {
        String sFrom;
        String sTo;
        try {
            String toText = this.to.getText();
            if (toText.length() == 0) {
                throw new IllegalArgumentException("At least the second proof node must be specified");
            }
            int toNo = Integer.parseInt(this.to.getText());
            sTo = this.getProofNodeText(toNo);
            String fromText = this.from.getText();
            if (fromText.length() == 0) {
                sFrom = this.getProofNodeText(this.getParent(toNo));
            } else {
                int fromNo = Integer.parseInt(fromText);
                sFrom = this.getProofNodeText(fromNo);
            }
        }
        catch (NumberFormatException e) {
            JOptionPane.showMessageDialog(null, "This is not a number: " + e.getMessage(), "Error", 0);
            return;
        }
        catch (IllegalArgumentException e) {
            JOptionPane.showMessageDialog(null, e.getMessage(), "Error", 0);
            return;
        }
        diff_match_patch differ = new diff_match_patch();
        differ.Diff_Timeout = 0.0f;
        LinkedList<diff_match_patch.Diff> diffs = differ.diff_main(sFrom, sTo, false);
        StringBuilder sb = new StringBuilder();
        sb.append("<pre>");
        for (diff_match_patch.Diff diff : diffs) {
            switch (diff.operation) {
                case EQUAL: {
                    sb.append(this.toHtml(diff.text));
                    break;
                }
                case DELETE: {
                    if (this.onlySpaces(diff.text)) {
                        sb.append(diff.text);
                        break;
                    }
                    sb.append("<span style='background-color: #ff8080;'>").append(this.toHtml(diff.text)).append("</span>");
                    break;
                }
                case INSERT: {
                    if (this.onlySpaces(diff.text)) {
                        sb.append(diff.text);
                        break;
                    }
                    sb.append("<span style='background-color: #80ff80;'>").append(this.toHtml(diff.text)).append("</span>");
                }
            }
        }
        sb.append("</pre>");
        String string = sb.toString();
        this.textArea.setText(string);
    }

    private boolean onlySpaces(CharSequence text) {
        for (int i = 0; i < text.length(); ++i) {
            if (Character.isWhitespace(text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private int getParent(int no) {
        Proof proof = this.mainWindow.getMediator().getSelectedProof();
        if (proof == null) {
            throw new IllegalArgumentException("There is no open proof!");
        }
        Node node = this.findNode(proof.root(), no);
        if (node == null) {
            throw new IllegalArgumentException(no + " is not a node in the proof");
        }
        Node parent = node.parent();
        if (parent == null) {
            throw new IllegalArgumentException(no + " has no parent node");
        }
        return parent.serialNr();
    }

    private String toHtml(String string) {
        string = string.replace("&", "&amp;");
        string = string.replace("<", "&lt;");
        string = string.replace(">", "&gt;");
        string = string.replace(" ", "&nbsp;");
        string = string.replace("\n", "<br/>");
        return string;
    }

    private String getProofNodeText(int nodeNumber) {
        Proof proof = this.mainWindow.getMediator().getSelectedProof();
        if (proof == null) {
            throw new IllegalArgumentException("There is no open proof!");
        }
        Node node = this.findNode(proof.root(), nodeNumber);
        if (node == null) {
            throw new IllegalArgumentException(nodeNumber + " does not denote a valid node");
        }
        LogicPrinter logicPrinter = new LogicPrinter(new ProgramPrinter(null), new NotationInfo(), proof.getServices(), true);
        logicPrinter.printSequent(node.sequent());
        return logicPrinter.result().toString();
    }

    private Node findNode(Node node, int number) {
        if (node.serialNr() == number) {
            return node;
        }
        while (node.serialNr() != number && node.childrenCount() == 1) {
            node = node.child(0);
        }
        if (node.serialNr() == number) {
            return node;
        }
        Iterator it = node.childrenIterator();
        while (it.hasNext()) {
            Node result;
            Node n = (Node)it.next();
            if (n.serialNr() > number || (result = this.findNode(n, number)) == null) continue;
            return result;
        }
        return null;
    }

    private String getHelpText() {
        return "<h1>Visual diff between sequences of Proof Nodes</h1><p>This window can be used to select one or two sequents of an ongoing or closed proof. All actions refer to the currently selected proof.</p><p>The textarea shows the <i>in-place diff</i> between two pretty printed sequences. Parts in <span style='background-color: #ff8080;'>red</span> are only present in the parent sequent and parts in <span style='background-color: #80ff80;'>green</span> are added in the second proof node.</p><h3>One node mode</h3><p>If you keep the left field (parent node) empty, the difference between theproof node and its direct predecessor is displayed in the text area.</p><h3>Two node mode</h3><p>If you specify two nodes, the difference between the declared sequents are displayed.</p><h3>'Show selected node'</h3><p>Use this button to use the currently selected proof node of the proof component as displayed proof node.";
    }

    public static void main(String[] args) {
        ProofDiffFrame pdf = new ProofDiffFrame(null);
        pdf.setDefaultCloseOperation(3);
        pdf.setSize(500, 500);
        pdf.setVisible(true);
    }

    public static class Action
    extends MainWindowAction {
        private static final long serialVersionUID = -1745515272350810787L;
        private final MainWindow mainWindow;

        public Action(MainWindow mainWindow) {
            super(mainWindow);
            this.mainWindow = mainWindow;
            this.putValue("Name", "Visual Node Diff");
            this.putValue("ShortDescription", "Open a new proof node diff window.");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofDiffFrame pdf = new ProofDiffFrame(this.mainWindow);
            pdf.setLocationRelativeTo(this.mainWindow);
            pdf.setVisible(true);
        }
    }
}

