/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.proofdiff;

import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.logic.Semisequent;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.pp.LogicPrinter;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.util.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ProofDifference {
    private static final Integer THRESHOLD = 25;
    private List<String> leftAntec = new LinkedList<String>();
    private List<String> rightAntec = new LinkedList<String>();
    private List<String> rightSucc = new LinkedList<String>();
    private List<String> leftSucc = new LinkedList<String>();
    private Set<String> exclusiveAntec = new HashSet<String>();
    private Set<String> commonSucc = new HashSet<String>();
    private Set<String> exclusiveSucc = new HashSet<String>();
    private Set<String> commonAntec = new HashSet<String>();

    public static ProofDifference create(Services services, Node left, Node right) {
        return ProofDifference.create(left, right, (Term t) -> LogicPrinter.quickPrintTerm((Term)t, (Services)services));
    }

    public static ProofDifference create(Node left, Node right, Function<Term, String> printer) {
        ProofDifference pd = new ProofDifference();
        assert (left != null && right != null);
        pd.leftAntec = ProofDifference.initialise(printer, left.sequent().antecedent());
        pd.leftSucc = ProofDifference.initialise(printer, left.sequent().succedent());
        pd.rightAntec = ProofDifference.initialise(printer, right.sequent().antecedent());
        pd.rightSucc = ProofDifference.initialise(printer, right.sequent().succedent());
        pd.computeDiff();
        return pd;
    }

    private static List<String> initialise(Function<Term, String> printer, Semisequent semisequent) {
        return semisequent.asList().stream().map(it -> (String)printer.apply(it.formula())).collect(Collectors.toList());
    }

    private static Collection<? extends String> intersect(Set<String> left, Set<String> right) {
        TreeSet<String> intersection = new TreeSet<String>(left);
        intersection.retainAll(right);
        return intersection;
    }

    private static void computeDiff(List<String> left, List<String> right, Set<String> common, Set<String> exclusive) {
        ProofDifference.computeDiff(new HashSet<String>(left), new HashSet<String>(right), common, exclusive);
    }

    private static void computeDiff(Set<String> left, Set<String> right, Set<String> common, Set<String> exclusive) {
        common.addAll(ProofDifference.intersect(left, right));
        exclusive.addAll(left);
        exclusive.addAll(right);
        exclusive.removeAll(common);
    }

    static String findAndPopNearestMatch(String l, List<String> right) {
        String current = null;
        l = l.replaceAll("\\s", "");
        int min = Integer.MAX_VALUE;
        for (String r : right) {
            int d = Levensthein.calculate(l, r.replaceAll("\\s", ""));
            if (d > min) continue;
            current = r;
            min = d;
        }
        right.remove(current);
        return current;
    }

    static List<Matching> findPairs(List<String> left, List<String> right) {
        int i;
        ArrayList<Matching> pairs = new ArrayList<Matching>(left.size() + right.size());
        int initCap = Math.max(8, Math.max(left.size() * right.size(), Math.max(left.size(), right.size())));
        PriorityQueue<Triple> queue = new PriorityQueue<Triple>(initCap, Comparator.comparingInt(t -> (Integer)t.third));
        for (int i2 = 0; i2 < left.size(); ++i2) {
            for (int j = 0; j < right.size(); ++j) {
                queue.add(new Triple((Object)i2, (Object)j, (Object)Levensthein.calculate(left.get(i2), right.get(j))));
            }
        }
        boolean[] matchedLeft = new boolean[left.size()];
        boolean[] matchedRight = new boolean[right.size()];
        while (!queue.isEmpty()) {
            Triple t2 = queue.poll();
            if (matchedLeft[(Integer)t2.first] || matchedRight[(Integer)t2.second]) continue;
            String l = left.get((Integer)t2.first);
            String r = right.get((Integer)t2.second);
            pairs.add(new Matching(l, r, (Integer)t2.third));
            matchedLeft[((Integer)t2.first).intValue()] = true;
            matchedRight[((Integer)t2.second).intValue()] = true;
        }
        for (i = 0; i < matchedLeft.length; ++i) {
            if (matchedLeft[i]) continue;
            pairs.add(new Matching(left.get(i), null, left.get(i).length()));
        }
        for (i = 0; i < matchedRight.length; ++i) {
            if (matchedRight[i]) continue;
            pairs.add(new Matching(null, right.get(i), right.get(i).length()));
        }
        return pairs;
    }

    public void computeDiff() {
        ProofDifference.computeDiff(this.leftAntec, this.rightAntec, this.commonAntec, this.exclusiveAntec);
        ProofDifference.computeDiff(this.leftSucc, this.rightSucc, this.commonSucc, this.exclusiveSucc);
    }

    public List<String> getLeftAntec() {
        return this.leftAntec;
    }

    public List<String> getRightAntec() {
        return this.rightAntec;
    }

    public List<String> getRightSucc() {
        return this.rightSucc;
    }

    public List<String> getLeftSucc() {
        return this.leftSucc;
    }

    public Set<String> getExclusiveAntec() {
        return this.exclusiveAntec;
    }

    public Set<String> getCommonSucc() {
        return this.commonSucc;
    }

    public Set<String> getExclusiveSucc() {
        return this.exclusiveSucc;
    }

    public Set<String> getCommonAntec() {
        return this.commonAntec;
    }

    public List<Matching> getSuccPairs() {
        return ProofDifference.findPairs(this.getLeftSucc(), this.getRightSucc());
    }

    public List<Matching> getAntecPairs() {
        return ProofDifference.findPairs(this.getLeftAntec(), this.getRightAntec());
    }

    static class Matching {
        final String left;
        final String right;
        final int distance;

        Matching(String left, String right, int distance) {
            this.left = left;
            this.right = right;
            this.distance = distance;
        }

        public String getLeft() {
            return this.left;
        }

        public String getRight() {
            return this.right;
        }

        public int getDistance() {
            return this.distance;
        }

        public String toString() {
            return String.format("(%s, %s)", this.left, this.right);
        }
    }

    static class Levensthein {
        Levensthein() {
        }

        static int calculate(String x, String y) {
            int[][] dp = new int[x.length() + 1][y.length() + 1];
            for (int i = 0; i <= x.length(); ++i) {
                for (int j = 0; j <= y.length(); ++j) {
                    dp[i][j] = i == 0 ? j : (j == 0 ? i : Levensthein.min(dp[i - 1][j - 1] + Levensthein.costOfSubstitution(x.charAt(i - 1), y.charAt(j - 1)), dp[i - 1][j] + 1, dp[i][j - 1] + 1));
                }
            }
            return dp[x.length()][y.length()];
        }

        public static int costOfSubstitution(char a, char b) {
            return a == b ? 0 : 1;
        }

        public static int min(int ... numbers) {
            return Arrays.stream(numbers).min().orElse(Integer.MAX_VALUE);
        }
    }
}

