/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.proofdiff;

import bibliothek.gui.dock.common.CLocation;
import bibliothek.gui.dock.common.DefaultMultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockable;
import bibliothek.gui.dock.common.MultipleCDockableFactory;
import bibliothek.gui.dock.common.NullMultipleCDockableFactory;
import bibliothek.gui.dock.common.action.CAction;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.actions.MainWindowAction;
import de.uka.ilkd.key.gui.help.HelpFacade;
import de.uka.ilkd.key.gui.proofdiff.ProofDifference;
import de.uka.ilkd.key.java.Services;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Enumeration;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;

public class ProofDifferenceView
extends DefaultMultipleCDockable {
    public static final String PROPERTY_LEFT_NODE = "left";
    public static final String PROPERTY_RIGHT_NODE = "right";
    private static final String EDITOR_TYPE = "plain/text";
    private final JPanel contentPanel;
    private final KeyAction actionHideCommonFormulas = new HideCommandFormulaAction();
    private final Services services;
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private final DefaultComboBoxModel<Proof> listModelLeft = new DefaultComboBoxModel();
    private final DefaultComboBoxModel<Proof> listModelRight = new DefaultComboBoxModel();
    private final KeYMediator mediator;
    private Node left;
    private Node right;
    private JComboBox<Proof> listLeftProof = new JComboBox();
    private JComboBox<Proof> listRightProof = new JComboBox();

    public ProofDifferenceView(@Nonnull Node left, @Nonnull Node right, KeYMediator mediator) {
        super((MultipleCDockableFactory)NullMultipleCDockableFactory.NULL, new CAction[0]);
        this.mediator = mediator;
        this.services = mediator.getServices();
        this.setCloseable(true);
        this.setRemoveOnClose(true);
        this.addAction(HelpFacade.createHelpButton("Using%20Key/NodeDiff"));
        this.contentPanel = new JPanel();
        this.contentPanel.setLayout(new BoxLayout(this.contentPanel, 1));
        this.getContentPane().setLayout(new BorderLayout());
        this.add(new JScrollPane(this.contentPanel));
        JPanel pNorth = new JPanel(new FlowLayout(1));
        Box pNorthLeft = new Box(1);
        Box pNorthRight = new Box(1);
        JLabel lblLeftNode = new JLabel("Left Node:");
        JLabel lblRightNode = new JLabel("Right Node:");
        JTextField txtLeftNode = new JTextField();
        JTextField txtRightNode = new JTextField();
        pNorthLeft.add(lblLeftNode);
        pNorthLeft.add(this.listLeftProof);
        pNorthLeft.add(txtLeftNode);
        pNorthRight.add(lblRightNode);
        pNorthRight.add(this.listRightProof);
        pNorthRight.add(txtRightNode);
        txtRightNode.addActionListener(e -> this.setRight(this.findNode(this.listRightProof, txtRightNode)));
        txtLeftNode.addActionListener(e -> this.setLeft(this.findNode(this.listLeftProof, txtLeftNode)));
        this.listRightProof.addActionListener(e -> this.setRight(this.findNode(this.listRightProof, txtRightNode)));
        this.listLeftProof.addActionListener(e -> this.setLeft(this.findNode(this.listLeftProof, txtLeftNode)));
        pNorth.add(pNorthLeft);
        pNorth.add(new JSeparator(1));
        pNorth.add(pNorthRight);
        txtLeftNode.setText(String.valueOf(left.serialNr()));
        txtRightNode.setText(String.valueOf(right.serialNr()));
        this.listLeftProof.setModel(this.listModelLeft);
        this.listRightProof.setModel(this.listModelRight);
        mediator.getCurrentlyOpenedProofs().addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent e) {
                ProofDifferenceView.this.transferProofs();
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
                ProofDifferenceView.this.transferProofs();
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                ProofDifferenceView.this.transferProofs();
            }
        });
        this.transferProofs();
        DefaultListCellRenderer renderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                return super.getListCellRendererComponent(list, ((Proof)value).name(), index, isSelected, cellHasFocus);
            }
        };
        this.listRightProof.setRenderer(renderer);
        this.listLeftProof.setRenderer(renderer);
        this.listRightProof.setSelectedItem(right.proof());
        this.listLeftProof.setSelectedItem(left.proof());
        this.addPropertyChangeListener(evt -> {
            this.contentPanel.removeAll();
            if (this.left != null && this.right != null) {
                this.computeDifferences();
                this.setTitleText("Difference between: " + left.serialNr() + " and " + right.serialNr());
            }
        });
        this.add(pNorth, "North");
        JPanel pSouth = new JPanel();
        JCheckBox chkBox = new JCheckBox(this.actionHideCommonFormulas);
        pSouth.add(chkBox);
        this.add(pSouth, "South");
        this.setLeft(left);
        this.setRight(right);
    }

    private static void equaliseSize(JComponent txtL, JComponent txtR) {
        Dimension max = new Dimension(Math.max(txtL.getWidth(), txtR.getWidth()), Math.max(txtL.getHeight(), txtR.getHeight()));
        txtR.setSize(max);
        txtL.setSize(max);
        txtR.setPreferredSize(max);
        txtL.setPreferredSize(max);
    }

    private Node findNode(JComboBox<Proof> box, JTextField text) {
        try {
            int serialNr = Integer.parseInt(text.getText());
            Proof proof = (Proof)box.getSelectedItem();
            if (proof == null) {
                return null;
            }
            return proof.findAny(n -> n.serialNr() == serialNr);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(propertyName, listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public Services getServices() {
        return this.services;
    }

    @Nonnull
    public Node getLeft() {
        return this.left;
    }

    public void setLeft(@Nullable Node left) {
        if (left == null) {
            return;
        }
        Node oldLeft = this.left;
        this.left = left;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_LEFT_NODE, oldLeft, left);
    }

    @Nonnull
    public Node getRight() {
        return this.right;
    }

    public void setRight(@Nullable Node right) {
        if (right == null) {
            return;
        }
        Node old = this.right;
        this.right = right;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_RIGHT_NODE, old, right);
    }

    private void computeDifferences() {
        this.contentPanel.removeAll();
        ProofDifference pd = ProofDifference.create(this.services, this.left, this.right);
        this.fill("Antecedent Differences", pd.getAntecPairs());
        this.fill("Succedent Differences", pd.getSuccPairs());
        this.getContentPane().invalidate();
        this.getContentPane().revalidate();
        this.getContentPane().repaint();
        this.getContentPane().repaint();
        this.getContentPane().repaint();
    }

    private void fill(String title, List<ProofDifference.Matching> pairs) {
        Box pane = new Box(1);
        pane.setBorder(BorderFactory.createTitledBorder(title));
        if (!pairs.isEmpty()) {
            this.contentPanel.add(pane);
        }
        for (ProofDifference.Matching pair : pairs) {
            if (this.isHideCommonFormulas() && pair.distance <= 0) continue;
            JEditorPane txtL = this.createEditor(pair.left);
            JEditorPane txtR = this.createEditor(pair.right);
            txtL.setAlignmentX(1.0f);
            Box boxPair = new Box(0);
            boxPair.add(txtL);
            boxPair.add(new JSeparator(1));
            boxPair.add(txtR);
            ProofDifferenceView.equaliseSize(txtL, txtR);
            pane.add(boxPair);
            pane.add(new JSeparator(0));
        }
    }

    protected JEditorPane createEditor(String content) {
        JEditorPane je = new JEditorPane(EDITOR_TYPE, content != null ? content : "");
        je.setEditable(false);
        je.setFont(UIManager.getDefaults().getFont("KEY_FONT_CURRENT_GOAL_VIEW"));
        JPanel textAreaPanel = new JPanel(new BorderLayout());
        textAreaPanel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        textAreaPanel.add(je);
        return je;
    }

    private void highlightDifferences(JEditorPane txtL, JEditorPane txtR) {
        DefaultHighlighter df1 = new DefaultHighlighter();
        txtL.setHighlighter(df1);
        DefaultHighlighter df2 = new DefaultHighlighter();
        txtL.setHighlighter(df2);
        char[] l = txtL.getText().toCharArray();
        char[] r = txtR.getText().toCharArray();
        try {
            for (int i = 0; i < Math.min(l.length, r.length); ++i) {
                int start = i;
                while (i < Math.min(l.length, r.length)) {
                    ++i;
                }
                if (start == i) continue;
                df1.addHighlight(start, i, new DefaultHighlighter.DefaultHighlightPainter(Color.RED));
                df2.addHighlight(start, i, new DefaultHighlighter.DefaultHighlightPainter(Color.RED));
            }
        }
        catch (NullPointerException | BadLocationException e) {
            e.printStackTrace();
        }
    }

    public boolean isHideCommonFormulas() {
        return this.actionHideCommonFormulas.isSelected();
    }

    public void setHideCommonFormulas(boolean hideCommonFormulas) {
        this.actionHideCommonFormulas.setEnabled(hideCommonFormulas);
    }

    private void transferProofs() {
        this.listModelLeft.removeAllElements();
        this.listModelRight.removeAllElements();
        Enumeration<Proof> iter = this.mediator.getCurrentlyOpenedProofs().elements();
        while (iter.hasMoreElements()) {
            Proof proof = iter.nextElement();
            this.listModelLeft.addElement(proof);
            this.listModelRight.addElement(proof);
        }
    }

    private class HideCommandFormulaAction
    extends KeyAction {
        private static final long serialVersionUID = -77545377028639666L;

        public HideCommandFormulaAction() {
            this.setName("Hide common formulas");
            this.setSelected(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofDifferenceView.this.computeDifferences();
        }
    }

    public static class OpenDifferenceWithParent
    extends MainWindowAction {
        private Node left;

        public OpenDifferenceWithParent(MainWindow mainWindow, Node node) {
            super(mainWindow);
            this.setName("Diff with parent");
            this.setEnabled(node.parent() != null);
            this.left = node;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofDifferenceView pdv = new ProofDifferenceView(this.left, this.left.parent(), this.mainWindow.getMediator());
            this.mainWindow.getDockControl().addDockable((MultipleCDockable)pdv);
            pdv.setLocation((CLocation)CLocation.base());
            pdv.setVisible(true);
        }
    }

    static class MyPanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = -3046025680639399997L;

        MyPanel(LayoutManager layout) {
            super(layout);
        }

        @Override
        public Dimension getPreferredScrollableViewportSize() {
            return this.getPreferredSize();
        }

        @Override
        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }

        @Override
        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        @Override
        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            return 0;
        }
    }
}

