/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.gui.prooftree.GUIBranchNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeModel;
import de.uka.ilkd.key.gui.prooftree.ProofTreeViewFilter;
import de.uka.ilkd.key.proof.Node;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.tree.TreeNode;

public abstract class GUIAbstractTreeNode
implements TreeNode {
    private GUIProofTreeModel tree;
    private WeakReference<Node> noderef;

    protected GUIProofTreeModel getProofTreeModel() {
        return this.tree;
    }

    public GUIAbstractTreeNode(GUIProofTreeModel tree, Node node) {
        this.tree = tree;
        this.noderef = new WeakReference<Node>(node);
    }

    @Override
    public abstract TreeNode getChildAt(int var1);

    @Override
    public abstract int getChildCount();

    @Override
    public abstract TreeNode getParent();

    @Override
    public abstract boolean isLeaf();

    public abstract void flushCache();

    @Override
    public int getIndex(TreeNode node) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (!this.getChildAt(i).equals(node)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public Enumeration<TreeNode> children() {
        return new ChildEnumeration();
    }

    public TreeNode[] getPath() {
        LinkedList<GUIAbstractTreeNode> path = new LinkedList<GUIAbstractTreeNode>();
        TreeNode n = this;
        path.addFirst((GUIAbstractTreeNode)n);
        while ((n = n.getParent()) != null) {
            path.addFirst((GUIAbstractTreeNode)n);
        }
        return path.toArray(new TreeNode[path.size()]);
    }

    protected TreeNode findBranch(Node p_node) {
        GUIBranchNode res = this.getProofTreeModel().findBranch(p_node);
        if (res != null) {
            return res;
        }
        String label = GUIAbstractTreeNode.ensureBranchLabelIsSet(p_node);
        return this.getProofTreeModel().getBranchNode(p_node, label);
    }

    public static String ensureBranchLabelIsSet(Node p_node) {
        Object label = p_node.getNodeInfo().getBranchLabel();
        if (p_node.root()) {
            label = "Proof Tree";
        }
        if (label == null) {
            label = "Case " + (p_node.parent().getChildNr(p_node) + 1);
            p_node.getNodeInfo().setBranchLabel((String)label);
        }
        return label;
    }

    public Node getNode() {
        return (Node)this.noderef.get();
    }

    protected Node findChild(Node n) {
        if (n.childrenCount() == 1) {
            return n.child(0);
        }
        if (!this.getProofTreeModel().globalFilterActive()) {
            return null;
        }
        Node nextN = null;
        for (int i = 0; i != n.childrenCount(); ++i) {
            if (ProofTreeViewFilter.hiddenByGlobalFilters(n.child(i))) continue;
            if (nextN != null) {
                return null;
            }
            nextN = n.child(i);
        }
        return nextN;
    }

    private class ChildEnumeration
    implements Enumeration<TreeNode> {
        int current = 0;

        private ChildEnumeration() {
        }

        @Override
        public boolean hasMoreElements() {
            return this.current < GUIAbstractTreeNode.this.getChildCount();
        }

        @Override
        public TreeNode nextElement() {
            return GUIAbstractTreeNode.this.getChildAt(this.current++);
        }
    }
}

