/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.gui.prooftree.GUIAbstractTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeModel;
import de.uka.ilkd.key.gui.prooftree.ProofTreeViewFilter;
import de.uka.ilkd.key.proof.Node;
import javax.swing.tree.TreeNode;

class GUIBranchNode
extends GUIAbstractTreeNode
implements TreeNode {
    private Object label;
    private TreeNode[] childrenCache = null;

    public GUIBranchNode(GUIProofTreeModel tree, Node subTree, Object label) {
        super(tree, subTree);
        this.label = label;
    }

    private void createChildrenCache() {
        this.childrenCache = new TreeNode[this.getChildCountHelp()];
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.fillChildrenCache();
        return this.childrenCache[childIndex];
    }

    private void fillChildrenCache() {
        if (this.childrenCache == null) {
            this.createChildrenCache();
        }
        if (this.childrenCache.length == 0 || this.childrenCache[0] != null) {
            return;
        }
        int count = 0;
        Node n = this.getNode();
        if (n == null) {
            return;
        }
        while (true) {
            this.childrenCache[count] = this.getProofTreeModel().getProofTreeNode(n);
            ++count;
            Node nextN = this.findChild(n);
            if (nextN == null) break;
            n = nextN;
        }
        for (int i = 0; i != n.childrenCount(); ++i) {
            if (ProofTreeViewFilter.hiddenByGlobalFilters(n.child(i))) continue;
            this.childrenCache[count] = this.findBranch(n.child(i));
            ++count;
        }
    }

    @Override
    public void flushCache() {
        this.childrenCache = null;
    }

    @Override
    public int getChildCount() {
        if (this.childrenCache == null) {
            this.createChildrenCache();
        }
        return this.childrenCache.length;
    }

    private int getChildCountHelp() {
        int count = 0;
        Node n = this.getNode();
        if (n == null) {
            return 0;
        }
        while (true) {
            ++count;
            Node nextN = this.findChild(n);
            if (nextN == null) break;
            n = nextN;
        }
        for (int i = 0; i != n.childrenCount(); ++i) {
            if (ProofTreeViewFilter.hiddenByGlobalFilters(n.child(i))) continue;
            ++count;
        }
        return count;
    }

    @Override
    public TreeNode getParent() {
        Node self = this.getNode();
        if (self == null) {
            return null;
        }
        Node n = self.parent();
        if (n == null) {
            return null;
        }
        while (n.parent() != null && this.findChild(n.parent()) != null) {
            n = n.parent();
        }
        return this.findBranch(n);
    }

    public void setLabel(String s) {
        Node n = this.getNode();
        if (n != null) {
            n.getNodeInfo().setBranchLabel(s);
        }
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public String toString() {
        String res;
        Node n = this.getNode();
        if (n != null) {
            res = n.getNodeInfo().getBranchLabel();
            if (res == null) {
                return this.label.toString();
            }
        } else {
            res = "null";
        }
        return res;
    }

    public boolean isClosed() {
        Node node = this.getNode();
        return node != null && node.isClosed();
    }
}

