/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.gui.prooftree.GUIAbstractTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIBranchNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeNode;
import de.uka.ilkd.key.gui.prooftree.ProofTreeViewFilter;
import de.uka.ilkd.key.logic.SequentChangeInfo;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.GoalListener;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofTreeAdapter;
import de.uka.ilkd.key.proof.ProofTreeEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Stack;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.key_project.util.collection.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GUIProofTreeModel
implements TreeModel,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(GUIProofTreeModel.class);
    private static final long serialVersionUID = 4253914848471158358L;
    private Proof proof;
    private ProofTreeListener proofTreeListener;
    private ProofTreeViewFilter.NodeFilter activeNodeFilter = null;
    private EventListenerList listenerList = new EventListenerList();
    private boolean attentive = true;
    private boolean batchGoalStateChange = false;
    private WeakHashMap<Node, GUIAbstractTreeNode> proofTreeNodes = new WeakHashMap();
    private WeakHashMap<Node, GUIBranchNode> branchNodes = new WeakHashMap();
    @Nonnull
    private Collection<TreePath> expansionState = Collections.emptySet();
    TreePath selection;

    public GUIProofTreeModel(Proof p) {
        if (p == null) {
            throw new IllegalArgumentException("null proof in GUIProofTreeModel().");
        }
        this.proof = p;
        this.proofTreeListener = new ProofTreeListener();
        for (ProofTreeViewFilter f : ProofTreeViewFilter.ALL) {
            if (!(f instanceof ProofTreeViewFilter.NodeFilter) || !f.isActive()) continue;
            this.activeNodeFilter = (ProofTreeViewFilter.NodeFilter)f;
        }
        GoalListener goalListener = new GoalListener(){

            public void sequentChanged(Goal source, SequentChangeInfo sci) {
            }

            public void goalReplaced(Goal source, Node parent, ImmutableList<Goal> newGoals) {
            }

            public void automaticStateChanged(Goal source, boolean oldAutomatic, boolean newAutomatic) {
                if (!GUIProofTreeModel.this.batchGoalStateChange && ProofTreeViewFilter.HIDE_INTERACTIVE_GOALS.isActive()) {
                    GUIProofTreeModel.this.updateTree((TreeNode)null);
                }
            }
        };
        this.proof.openGoals().forEach(g -> g.addGoalListener(goalListener));
    }

    public void setBatchGoalStateChange(boolean value) {
        if (!value && this.batchGoalStateChange) {
            this.updateTree((TreeNode)null);
        }
        this.batchGoalStateChange = value;
    }

    public void unregister() {
        this.proof.removeProofTreeListener((de.uka.ilkd.key.proof.ProofTreeListener)this.proofTreeListener);
    }

    public void register() {
        this.proof.addProofTreeListener((de.uka.ilkd.key.proof.ProofTreeListener)this.proofTreeListener);
    }

    public void setAttentive(boolean b) {
        LOGGER.debug("setAttentive: {}", (Object)b);
        if (b != this.attentive && !this.proof.isDisposed()) {
            if (b) {
                this.proof.addProofTreeListener((de.uka.ilkd.key.proof.ProofTreeListener)this.proofTreeListener);
                if (this.globalFilterActive()) {
                    this.updateTree((TreeNode)null);
                }
            } else {
                this.proof.removeProofTreeListener((de.uka.ilkd.key.proof.ProofTreeListener)this.proofTreeListener);
            }
            this.attentive = b;
        }
    }

    public boolean isAttentive() {
        return this.attentive;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.listenerList.add(TreeModelListener.class, l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.listenerList.remove(TreeModelListener.class, l);
    }

    public boolean hideClosedSubtrees() {
        return ProofTreeViewFilter.HIDE_CLOSED_SUBTREES.isActive();
    }

    public boolean hideInteractiveGoals() {
        return ProofTreeViewFilter.HIDE_INTERACTIVE_GOALS.isActive();
    }

    public boolean globalFilterActive() {
        return Arrays.stream(ProofTreeViewFilter.ALL_GLOBAL_FILTERS).anyMatch(ProofTreeViewFilter::isActive);
    }

    public void setFilter(ProofTreeViewFilter filter, boolean active) {
        if (active != filter.isActive()) {
            if (!filter.global()) {
                if (this.activeNodeFilter != null) {
                    this.activeNodeFilter.setActive(false);
                }
                this.activeNodeFilter = active ? (ProofTreeViewFilter.NodeFilter)filter : null;
            }
            filter.setActive(active);
            this.updateTree((TreeNode)null);
        }
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (this.activeNodeFilter == null) {
            TreeNode guiParent = (TreeNode)parent;
            if (guiParent.getChildCount() > index) {
                return guiParent.getChildAt(index);
            }
        } else {
            return this.activeNodeFilter.getChild(parent, index);
        }
        return null;
    }

    @Override
    public int getChildCount(Object parent) {
        if (this.activeNodeFilter == null) {
            return ((TreeNode)parent).getChildCount();
        }
        return this.activeNodeFilter.getChildCount(parent);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        TreeNode guiParent = (TreeNode)parent;
        if (this.activeNodeFilter == null) {
            for (int i = 0; i < guiParent.getChildCount(); ++i) {
                if (guiParent.getChildAt(i) != child) continue;
                return i;
            }
        } else {
            return this.activeNodeFilter.getIndexOfChild(parent, child);
        }
        return -1;
    }

    @Override
    public Object getRoot() {
        return this.getBranchNode(this.proof.root(), "Proof Tree");
    }

    @Override
    public boolean isLeaf(Object guiNode) {
        return ((TreeNode)guiNode).isLeaf();
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        if (path.getLastPathComponent() instanceof GUIBranchNode) {
            ((GUIBranchNode)path.getLastPathComponent()).setLabel((String)newValue);
        }
    }

    private void updateTree(TreeNode trn) {
        if (trn == null || trn == this.getRoot()) {
            this.proofTreeNodes = new WeakHashMap();
            this.branchNodes = new WeakHashMap();
            this.fireTreeStructureChanged(new Object[]{this.getRoot()});
            return;
        }
        this.flushCaches(trn);
        ((GUIAbstractTreeNode)trn).flushCache();
        Object[] path = ((GUIAbstractTreeNode)trn.getParent()).getPath();
        this.fireTreeStructureChanged(path);
    }

    public void updateTree(Node p_node) {
        if (p_node == null) {
            this.updateTree((TreeNode)null);
        } else {
            this.updateTree(this.getProofTreeNode(p_node));
        }
    }

    private void flushCaches(TreeNode trn) {
        Node p;
        Node n = ((GUIAbstractTreeNode)trn).getNode();
        while ((p = n.parent()) != null && ((GUIAbstractTreeNode)trn).findChild(p) != null) {
            n = p;
        }
        this.flushCaches(n);
    }

    private void flushCaches(Node n) {
        Stack<Node> workingList = new Stack<Node>();
        workingList.add(n);
        while (!workingList.empty()) {
            Node nextN;
            Node node = (Node)workingList.pop();
            GUIBranchNode treeNode = this.findBranch(node);
            if (treeNode == null) continue;
            treeNode.flushCache();
            while ((nextN = treeNode.findChild(node)) != null) {
                node = nextN;
            }
            for (int i = 0; i != node.childrenCount(); ++i) {
                if (ProofTreeViewFilter.hiddenByGlobalFilters(node.child(i))) continue;
                workingList.add(node.child(i));
            }
        }
    }

    protected void fireTreeStructureChanged(Object[] path) {
        TreeModelEvent event = null;
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != TreeModelListener.class) continue;
            if (event == null) {
                event = new TreeModelEvent((Object)this, path);
            }
            ((TreeModelListener)listeners[i + 1]).treeStructureChanged(event);
        }
    }

    public GUIAbstractTreeNode find(Node n) {
        return this.proofTreeNodes.get(n);
    }

    public GUIAbstractTreeNode getProofTreeNode(Node n) {
        GUIAbstractTreeNode res = this.find(n);
        if (res == null) {
            res = new GUIProofTreeNode(this, n);
            this.proofTreeNodes.put(n, res);
        }
        return res;
    }

    public GUIBranchNode findBranch(Node n) {
        return this.branchNodes.get(n);
    }

    public GUIBranchNode getBranchNode(Node n, Object label) {
        GUIBranchNode res = this.findBranch(n);
        if (res == null) {
            res = new GUIBranchNode(this, n, label);
            this.branchNodes.put(n, res);
        }
        return res;
    }

    public void setExpansionState(@Nonnull Collection<TreePath> c) {
        this.expansionState = c;
    }

    @Nonnull
    public Collection<TreePath> getExpansionState() {
        return this.expansionState;
    }

    public void storeSelection(TreePath t) {
        this.selection = t;
    }

    public TreePath getSelection() {
        return this.selection;
    }

    class ProofTreeListener
    extends ProofTreeAdapter {
        private Node pruningInProcess;

        ProofTreeListener() {
        }

        public void proofStructureChanged(ProofTreeEvent e) {
            if (this.pruningInProcess != null) {
                return;
            }
            Node n = e.getNode();
            if (n != null) {
                GUIProofTreeModel.this.updateTree(GUIProofTreeModel.this.getProofTreeNode(n));
                return;
            }
            Goal g = e.getGoal();
            if (g != null) {
                GUIProofTreeModel.this.updateTree(GUIProofTreeModel.this.getProofTreeNode(g.node()));
            }
        }

        public void proofIsBeingPruned(ProofTreeEvent e) {
            this.pruningInProcess = e.getNode();
        }

        public void proofPruned(ProofTreeEvent e) {
            GUIProofTreeModel.this.updateTree(GUIProofTreeModel.this.getProofTreeNode(this.pruningInProcess));
            this.pruningInProcess = null;
        }

        public void proofGoalRemoved(ProofTreeEvent e) {
            if (this.pruningInProcess != null) {
                return;
            }
            if (GUIProofTreeModel.this.globalFilterActive()) {
                GUIProofTreeModel.this.updateTree((TreeNode)null);
            } else {
                this.proofStructureChanged(e);
            }
        }
    }
}

