/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.gui.prooftree.GUIAbstractTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIOneStepChildTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeModel;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.rule.OneStepSimplifier;
import de.uka.ilkd.key.rule.OneStepSimplifierRuleApp;
import de.uka.ilkd.key.rule.RuleApp;
import javax.swing.tree.TreeNode;

class GUIProofTreeNode
extends GUIAbstractTreeNode {
    private GUIAbstractTreeNode[] children;

    public GUIProofTreeNode(GUIProofTreeModel tree, Node node) {
        super(tree, node);
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        this.ensureChildrenArray();
        return this.children[childIndex];
    }

    @Override
    public int getChildCount() {
        this.ensureChildrenArray();
        return this.children.length;
    }

    @Override
    public TreeNode getParent() {
        Node n = this.getNode();
        if (n == null) {
            return null;
        }
        while (n.parent() != null && this.findChild(n.parent()) != null) {
            n = n.parent();
        }
        return this.findBranch(n);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public String toString() {
        Node n = this.getNode();
        if (n != null) {
            return n.serialNr() + ":" + n.name();
        }
        return "Invalid WeakReference";
    }

    private void ensureChildrenArray() {
        if (this.children == null) {
            OneStepSimplifier.Protocol protocol;
            Node node = this.getNode();
            if (node != null && node.getAppliedRuleApp() instanceof OneStepSimplifierRuleApp && (protocol = ((OneStepSimplifierRuleApp)node.getAppliedRuleApp()).getProtocol()) != null) {
                this.children = new GUIAbstractTreeNode[protocol.size()];
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i] = new GUIOneStepChildTreeNode(this.getProofTreeModel(), this, (RuleApp)protocol.get(i));
                }
                return;
            }
            this.children = new GUIAbstractTreeNode[0];
        }
    }

    @Override
    public void flushCache() {
        this.children = null;
    }
}

