/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

class ProofTreeExpansionState
extends AbstractSet<TreePath> {
    @Nonnull
    private final JTree tree;
    @Nonnull
    private final Set<TreePath> paths = new LinkedHashSet<TreePath>();
    @Nonnull
    private final Listener listener = new Listener();

    public ProofTreeExpansionState(@Nonnull JTree t) {
        this.tree = t;
        this.tree.addTreeExpansionListener(this.listener);
        TreeModel data = this.tree.getModel();
        if (data != null) {
            data.addTreeModelListener(this.listener);
            this.paths.addAll(ProofTreeExpansionState.paths(this.tree));
        }
    }

    public ProofTreeExpansionState(@Nonnull JTree tree, @Nonnull Collection<TreePath> state) {
        this(tree);
        ProofTreeExpansionState.setPaths(tree, state);
    }

    @Deprecated
    private void readFromTree() {
        TreePath rootPath;
        TreeModel data = this.tree.getModel();
        Object root = data.getRoot();
        if (root != null && this.tree.isExpanded(rootPath = new TreePath(root))) {
            Enumeration<TreePath> e = this.tree.getExpandedDescendants(rootPath);
            while (e.hasMoreElements()) {
                this.paths.add(e.nextElement());
            }
        }
    }

    public void disconnect() {
        this.tree.removeTreeExpansionListener(this.listener);
        TreeModel data = this.tree.getModel();
        if (data != null) {
            data.removeTreeModelListener(this.listener);
        }
    }

    @Override
    public int size() {
        return this.paths.size();
    }

    @Override
    public boolean isEmpty() {
        return this.paths.isEmpty();
    }

    @Override
    public boolean contains(Object item) {
        return this.paths.contains(item);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.paths.containsAll(c);
    }

    @Override
    public Iterator<TreePath> iterator() {
        return new Iterator<TreePath>(){
            final Iterator<TreePath> i;
            {
                this.i = ProofTreeExpansionState.this.paths.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.i.hasNext();
            }

            @Override
            public TreePath next() {
                return this.i.next();
            }
        };
    }

    protected Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    @Nonnull
    public Collection<TreePath> copyState() {
        return new LinkedHashSet<TreePath>(this.paths);
    }

    public static void collapseAll(JTree tree) {
        TreeModel data = tree.getModel();
        if (data == null) {
            return;
        }
        Object root = data.getRoot();
        if (root == null || data.isLeaf(root)) {
            return;
        }
        TreePath rootPath = new TreePath(root);
        boolean rootExpanded = tree.isExpanded(rootPath);
        ProofTreeExpansionState.collapseAllBelow(tree, rootPath);
        if (rootExpanded && !tree.isRootVisible()) {
            tree.expandPath(rootPath);
        }
    }

    public static void collapseAllBelow(JTree tree, TreePath path) {
        Object node = path.getLastPathComponent();
        TreeModel data = tree.getModel();
        int count = data.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            Object child = data.getChild(node, i);
            if (data.isLeaf(child)) continue;
            ProofTreeExpansionState.collapseAllBelow(tree, path.pathByAddingChild(child));
        }
        tree.collapsePath(path);
    }

    public static void expandAll(JTree tree) {
        TreeModel data = tree.getModel();
        if (data == null) {
            return;
        }
        Object root = data.getRoot();
        if (root == null || data.isLeaf(root)) {
            return;
        }
        ProofTreeExpansionState.expandAllBelow(tree, new TreePath(root));
    }

    public static void expandAllBelow(JTree tree, TreePath path) {
        TreeExpansionListener[] expansionListeners = tree.getTreeExpansionListeners();
        for (TreeExpansionListener treeExpansionListener : expansionListeners) {
            if (treeExpansionListener instanceof Listener) continue;
            tree.removeTreeExpansionListener(treeExpansionListener);
        }
        for (TreePath tp : ProofTreeExpansionState.extremalPaths(tree.getModel(), path)) {
            tree.expandPath(tp);
        }
        for (TreeExpansionListener treeExpansionListener : expansionListeners) {
            if (treeExpansionListener instanceof Listener) continue;
            tree.addTreeExpansionListener(treeExpansionListener);
        }
        tree.fireTreeExpanded(path);
    }

    private static Collection<TreePath> extremalPaths(TreeModel data, TreePath path) {
        LinkedHashSet<TreePath> result = new LinkedHashSet<TreePath>();
        if (data.isLeaf(path.getLastPathComponent())) {
            return result;
        }
        ProofTreeExpansionState.extremalPathsImpl(data, path, result);
        return result;
    }

    private static void extremalPathsImpl(TreeModel data, TreePath path, Collection<TreePath> result) {
        int i;
        Object node = path.getLastPathComponent();
        boolean hasNonLeafChildren = false;
        int count = data.getChildCount(node);
        for (i = 0; i < count; ++i) {
            if (data.isLeaf(data.getChild(node, i))) continue;
            hasNonLeafChildren = true;
        }
        if (!hasNonLeafChildren) {
            result.add(path);
        } else {
            for (i = 0; i < count; ++i) {
                Object child = data.getChild(node, i);
                if (data.isLeaf(child)) continue;
                ProofTreeExpansionState.extremalPathsImpl(data, path.pathByAddingChild(child), result);
            }
        }
    }

    public static Collection<TreePath> paths(JTree tree) {
        TreeExpansionListener[] treeExpansionListeners;
        LinkedHashSet<TreePath> result = new LinkedHashSet<TreePath>();
        TreeModel data = tree.getModel();
        if (data == null) {
            return result;
        }
        Object root = data.getRoot();
        if (root == null || data.isLeaf(root)) {
            return result;
        }
        for (TreeExpansionListener tel : treeExpansionListeners = tree.getTreeExpansionListeners()) {
            tree.removeTreeExpansionListener(tel);
        }
        ProofTreeExpansionState.pathsImpl(tree, data, new TreePath(root), result);
        for (TreeExpansionListener tel : treeExpansionListeners) {
            tree.addTreeExpansionListener(tel);
        }
        return result;
    }

    private static void pathsImpl(JTree tree, TreeModel data, TreePath path, Collection<TreePath> result) {
        boolean expanded = tree.isExpanded(path);
        if (expanded) {
            result.add(path);
        } else {
            tree.expandPath(path);
        }
        Object node = path.getLastPathComponent();
        int count = data.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            Object child = data.getChild(node, i);
            if (data.isLeaf(child)) continue;
            ProofTreeExpansionState.pathsImpl(tree, data, path.pathByAddingChild(child), result);
        }
        if (!expanded) {
            tree.collapsePath(path);
        }
    }

    public static void setPaths(@Nonnull JTree tree, @Nonnull Collection<TreePath> paths) {
        TreeExpansionListener[] expansionListeners;
        TreeModel data = tree.getModel();
        if (data == null) {
            return;
        }
        Object root = data.getRoot();
        if (root == null || data.isLeaf(root)) {
            return;
        }
        for (TreeExpansionListener exl : expansionListeners = tree.getTreeExpansionListeners()) {
            if (exl instanceof Listener) continue;
            tree.removeTreeExpansionListener(exl);
        }
        ProofTreeExpansionState.setPathsImpl(tree, data, new TreePath(root), Integer.MAX_VALUE, paths);
        for (TreeExpansionListener exl : expansionListeners) {
            if (exl instanceof Listener) continue;
            tree.addTreeExpansionListener(exl);
        }
        tree.fireTreeExpanded(new TreePath(root));
    }

    private static void setPathsImpl(@Nonnull JTree tree, @Nonnull TreeModel data, @Nonnull TreePath start, int maxLevel, @Nonnull Collection<TreePath> paths) {
        if (maxLevel > 0) {
            Object node = start.getLastPathComponent();
            int count = data.getChildCount(node);
            for (int i = 0; i < count; ++i) {
                Object child = data.getChild(node, i);
                if (data.isLeaf(child)) continue;
                ProofTreeExpansionState.setPathsImpl(tree, data, start.pathByAddingChild(child), maxLevel - 1, paths);
            }
        }
        if (paths.contains(start)) {
            if (!tree.isExpanded(start)) {
                tree.expandPath(start);
            }
        } else if (!tree.isCollapsed(start)) {
            tree.collapsePath(start);
        }
    }

    private class Listener
    implements TreeExpansionListener,
    TreeModelListener {
        private Listener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent e) {
            ProofTreeExpansionState.this.paths.add(e.getPath());
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent e) {
            ProofTreeExpansionState.this.paths.remove(e.getPath());
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
            Object[] children;
            TreePath parent = e.getTreePath();
            for (Object aChildren : children = e.getChildren()) {
                this.removeDescendants(parent.pathByAddingChild(aChildren));
            }
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreePath path = e.getTreePath();
            if (path == null) {
                ProofTreeExpansionState.this.paths.clear();
                return;
            }
            if (path.getParentPath() == null) {
                ProofTreeExpansionState.this.paths.clear();
                ProofTreeExpansionState.this.paths.addAll(ProofTreeExpansionState.paths(ProofTreeExpansionState.this.tree));
            } else {
                this.removeDescendants(path);
                if (ProofTreeExpansionState.this.tree.isExpanded(path)) {
                    ProofTreeExpansionState.this.paths.add(path);
                }
            }
        }

        private void removeDescendants(TreePath path) {
            ProofTreeExpansionState.this.paths.removeIf(current -> current.isDescendant(path));
        }
    }
}

