/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.Main;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.ProofMacroMenu;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.extension.api.DefaultContextMenuKind;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.nodeviews.SequentViewDock;
import de.uka.ilkd.key.gui.notification.events.GeneralInformationEvent;
import de.uka.ilkd.key.gui.proofdiff.ProofDifferenceView;
import de.uka.ilkd.key.gui.prooftree.DisableGoal;
import de.uka.ilkd.key.gui.prooftree.GUIAbstractTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIBranchNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeModel;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeNode;
import de.uka.ilkd.key.gui.prooftree.ProofTreeExpansionState;
import de.uka.ilkd.key.gui.prooftree.ProofTreeView;
import de.uka.ilkd.key.gui.prooftree.ProofTreeViewFilter;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.GeneralSettings;
import de.uka.ilkd.key.util.Pair;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;

public class ProofTreePopupFactory {
    public static final int ICON_SIZE = 16;
    private List<Function<ProofTreeContext, Component>> builders = new ArrayList<Function<ProofTreeContext, Component>>();

    protected ProofTreePopupFactory() {
        this.addAction(x$0 -> new RunStrategyOnNode((ProofTreeContext)x$0));
        this.addAction(x$0 -> new Prune((ProofTreeContext)x$0));
        this.add(this::getMacroMenu);
        if (Main.isExperimentalMode()) {
            this.addAction(x$0 -> new DelayedCut((ProofTreeContext)x$0));
        }
        this.addSeparator();
        this.addAction(x$0 -> new Notes((ProofTreeContext)x$0));
        this.addSeparator();
        this.addAction(x$0 -> new ExpandAll((ProofTreeContext)x$0));
        this.addAction(x$0 -> new ExpandAllBelow((ProofTreeContext)x$0));
        this.addAction(x$0 -> new ExpandGoals((ProofTreeContext)x$0));
        this.addAction(x$0 -> new ExpandGoalsBelow((ProofTreeContext)x$0));
        this.addAction(x$0 -> new CollapseAll((ProofTreeContext)x$0));
        this.addAction(x$0 -> new CollapseOtherBranches((ProofTreeContext)x$0));
        this.addAction(x$0 -> new CollapseBelow((ProofTreeContext)x$0));
        this.addSeparator();
        this.addAction(x$0 -> new PrevSibling((ProofTreeContext)x$0));
        this.addAction(x$0 -> new NextSibling((ProofTreeContext)x$0));
        this.addSeparator();
        for (ProofTreeViewFilter filter : ProofTreeViewFilter.ALL) {
            this.add(ctx -> {
                FilterAction action = new FilterAction((ProofTreeContext)ctx, filter);
                return new JCheckBoxMenuItem(action);
            });
        }
        this.addAction(x$0 -> new Search((ProofTreeContext)x$0));
        this.addSeparator();
        this.addAction(ctx -> new SetGoalsBelowEnableStatus((ProofTreeContext)ctx, false));
        this.addAction(ctx -> new SetGoalsBelowEnableStatus((ProofTreeContext)ctx, true));
        this.addSeparator();
        this.addAction(x$0 -> new SubtreeStatistics((ProofTreeContext)x$0));
        this.addAction(ctx -> new SequentViewDock.OpenCurrentNodeAction(ctx.window, ctx.invokedNode));
        this.addAction(ctx -> new ProofDifferenceView.OpenDifferenceWithParent(ctx.window, ctx.invokedNode));
    }

    private Component getMacroMenu(ProofTreeContext proofTreeContext) {
        ProofMacroMenu macroMenu = new ProofMacroMenu(proofTreeContext.mediator, null);
        if (!macroMenu.isEmpty()) {
            return macroMenu;
        }
        return null;
    }

    public static ProofTreeContext createContext(ProofTreeView view, TreePath selectedPath) {
        ProofTreeContext context = new ProofTreeContext();
        context.proofTreeView = view;
        context.path = selectedPath;
        if (selectedPath.getLastPathComponent() instanceof GUIProofTreeNode) {
            context.branch = selectedPath.getParentPath();
            context.invokedNode = ((GUIProofTreeNode)selectedPath.getLastPathComponent()).getNode();
        } else {
            context.branch = selectedPath;
            context.invokedNode = ((GUIBranchNode)selectedPath.getLastPathComponent()).getNode();
        }
        context.delegateModel = view.delegateModel;
        context.delegateView = view.delegateView;
        context.window = MainWindow.getInstance();
        context.mediator = context.window.getMediator();
        context.proof = context.mediator.getSelectedProof();
        return context;
    }

    private void addSeparator() {
        this.add(ctx -> new JSeparator());
    }

    public void add(Function<ProofTreeContext, Component> act) {
        this.builders.add(act);
    }

    public void addAction(Function<ProofTreeContext, Action> act) {
        this.add(ctx -> new JMenuItem((Action)act.apply((ProofTreeContext)ctx)));
    }

    public JPopupMenu create(ProofTreeView view, TreePath selectedPath) {
        String menuName = "Choose Action";
        JPopupMenu menu = new JPopupMenu("Choose Action");
        ProofTreeContext context = ProofTreePopupFactory.createContext(view, selectedPath);
        this.builders.forEach(it -> {
            Component entry = (Component)it.apply(context);
            if (entry != null) {
                menu.add(entry);
            }
        });
        menu.addSeparator();
        KeYGuiExtensionFacade.addContextMenuItems(DefaultContextMenuKind.PROOF_TREE, menu, context.invokedNode, context.mediator);
        return menu;
    }

    private class FilterAction
    extends ProofTreeAction {
        private static final long serialVersionUID = -2972127068771960203L;
        private final ProofTreeViewFilter filter;

        public FilterAction(ProofTreeContext context, ProofTreeViewFilter filter) {
            super(context);
            this.filter = filter;
            this.setName(filter.name());
            this.setSelected(filter.isActive());
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean selected = this.isSelected();
            Object source = e.getSource();
            if (!this.filter.global()) {
                this.context.delegateModel.setFilter(this.filter, selected);
                if (this.context.branch == this.context.path) {
                    TreeNode node;
                    if (this.context.delegateModel.getRoot() instanceof GUIBranchNode && (node = ((GUIAbstractTreeNode)this.context.delegateModel.getRoot()).findBranch(this.context.invokedNode)) instanceof GUIBranchNode) {
                        this.context.proofTreeView.selectBranchNode((GUIBranchNode)node);
                    }
                } else {
                    this.context.delegateView.scrollPathToVisible(this.context.path);
                    this.context.delegateView.setSelectionPath(this.context.path);
                }
            } else {
                this.context.delegateModel.setFilter(this.filter, selected);
                if (this.context.branch == this.context.path) {
                    if (!selected) {
                        TreeNode node;
                        if (this.context.delegateModel.getRoot() instanceof GUIBranchNode && (node = ((GUIAbstractTreeNode)this.context.delegateModel.getRoot()).findBranch(this.context.invokedNode)) instanceof GUIBranchNode) {
                            this.context.proofTreeView.selectBranchNode((GUIBranchNode)node);
                        }
                    } else if (this.context.invokedNode.parent() == null || this.context.delegateModel.getProofTreeNode(this.context.invokedNode.parent()).findChild(this.context.invokedNode.parent()) == null) {
                        TreeNode node;
                        if (this.context.delegateModel.getRoot() instanceof GUIBranchNode && (node = ((GUIAbstractTreeNode)this.context.delegateModel.getRoot()).findBranch(this.context.invokedNode)) instanceof GUIBranchNode) {
                            this.context.proofTreeView.selectBranchNode((GUIBranchNode)node);
                        }
                    } else {
                        TreePath tp = new TreePath(this.context.delegateModel.getProofTreeNode(this.context.invokedNode).getPath());
                        this.context.delegateView.scrollPathToVisible(tp);
                        this.context.delegateView.setSelectionPath(tp);
                    }
                } else {
                    TreePath tp = new TreePath(this.context.delegateModel.getProofTreeNode(this.context.invokedNode).getPath());
                    this.context.delegateView.scrollPathToVisible(tp);
                    this.context.delegateView.setSelectionPath(tp);
                }
            }
        }
    }

    public abstract class ProofTreeAction
    extends KeyAction {
        private static final long serialVersionUID = 2686349019163064481L;
        protected final ProofTreeContext context;

        protected ProofTreeAction(ProofTreeContext context) {
            this.context = context;
        }
    }

    private final class SetGoalsBelowEnableStatus
    extends DisableGoal {
        private static final long serialVersionUID = -2150188528163599512L;
        private final ProofTreeContext context;

        public SetGoalsBelowEnableStatus(ProofTreeContext ctx, boolean enableGoals) {
            this.context = ctx;
            this.enableGoals = enableGoals;
            String action = enableGoals ? "Automatic" : "Interactive";
            this.putValue("Name", "Set All Goals Below to " + action);
            if (enableGoals) {
                this.putValue("ShortDescription", "Include this node and all goals in the subtree in automatic rule application");
                this.putValue("SmallIcon", KEY_HOLE_PULL_DOWN_MENU);
            } else {
                this.putValue("ShortDescription", "Exclude this node and all goals in the subtree from automatic rule application");
                this.putValue("SmallIcon", KEY_HOLE_DISABLED_PULL_DOWN_MENU);
            }
        }

        @Override
        public Iterable<Goal> getGoalList() {
            return this.context.proof.getSubtreeGoals(this.context.invokedNode);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.delegateModel.setBatchGoalStateChange(true);
            super.actionPerformed(e);
            this.context.delegateModel.setBatchGoalStateChange(false);
            this.context.delegateView.repaint();
        }
    }

    class RunStrategyOnNode
    extends ProofTreeAction {
        private static final long serialVersionUID = -7028621462695539683L;

        protected RunStrategyOnNode(ProofTreeContext context) {
            super(context);
            this.setName("Apply Strategy");
            this.setIcon(IconFactory.strategyStartLogo(16));
            this.setEnabled(context.proof != null);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Goal invokedGoal = this.context.proof.getGoal(this.context.invokedNode);
            KeYMediator r = this.context.mediator;
            if (invokedGoal == null) {
                ImmutableList enabledGoals = this.context.proof.getSubtreeEnabledGoals(this.context.invokedNode);
                r.getUI().getProofControl().startAutoMode(r.getSelectedProof(), enabledGoals);
            } else {
                r.getUI().getProofControl().startAutoMode(r.getSelectedProof(), ImmutableSLList.nil().prepend((Object)invokedGoal));
            }
        }
    }

    class DelayedCut
    extends ProofTreeAction {
        private static final long serialVersionUID = 2264044175802298829L;

        public DelayedCut(ProofTreeContext context) {
            super(context);
            this.setName("Delayed Cut");
            this.setEnabled(false);
            if (context.proof != null && !context.invokedNode.leaf() && context.proof.getSubtreeGoals(context.invokedNode).size() > 0) {
                this.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.delegateModel.setAttentive(false);
            if (this.context.mediator.processDelayedCut(this.context.invokedNode)) {
                this.context.delegateModel.updateTree((Node)null);
            }
            this.context.delegateModel.setAttentive(true);
            this.context.proofTreeView.makeNodeVisible(this.context.mediator.getSelectedNode());
        }
    }

    class Prune
    extends ProofTreeAction {
        private static final long serialVersionUID = -1744963704210861370L;

        public Prune(ProofTreeContext context) {
            super(context);
            this.setName("Prune Proof");
            this.setIcon(IconFactory.pruneLogo(16));
            this.setEnabled(false);
            if (!(context.proof == null || context.proof.isGoal(context.invokedNode) || context.proof.isClosedGoal(context.invokedNode) || context.proof.getSubtreeGoals(context.invokedNode).size() <= 0 && (GeneralSettings.noPruningClosed || context.proof.getClosedSubtreeGoals(context.invokedNode).size() <= 0))) {
                this.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.delegateModel.setAttentive(false);
            this.context.mediator.setBack(this.context.invokedNode);
            this.context.delegateModel.updateTree((Node)null);
            this.context.delegateModel.setAttentive(true);
            this.context.proofTreeView.makeNodeVisible(this.context.invokedNode);
        }
    }

    class Search
    extends ProofTreeAction {
        private static final long serialVersionUID = -6543488911281521583L;

        public Search(ProofTreeContext context) {
            super(context);
            this.setName("Search");
            this.setIcon(IconFactory.search2(16));
            this.setAcceleratorKey(ProofTreeView.searchKeyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.proofTreeView.showSearchPanel();
        }
    }

    class Notes
    extends ProofTreeAction {
        private static final long serialVersionUID = -6871120844080468856L;

        public Notes(ProofTreeContext context) {
            super(context);
            this.setName("Edit Notes...");
            this.setIcon(IconFactory.editFile(16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String origNotes;
            Icon editIcon = IconFactory.editFile(20);
            String newNotes = (String)JOptionPane.showInputDialog(this.context.proofTreeView, null, "Annotate this proof node", -1, editIcon, null, origNotes = this.context.invokedNode.getNodeInfo().getNotes());
            if (newNotes != null) {
                if (newNotes.length() == 0) {
                    this.context.invokedNode.getNodeInfo().setNotes(null);
                } else {
                    this.context.invokedNode.getNodeInfo().setNotes(newNotes);
                }
            }
        }
    }

    class NextSibling
    extends ProofTreeAction {
        private static final long serialVersionUID = 2337297147243419973L;

        public NextSibling(ProofTreeContext context) {
            super(context);
            this.setName("Next Sibling");
            this.setIcon(IconFactory.next(16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object node = this.context.branch.getLastPathComponent();
            TreeNode parent = ((GUIAbstractTreeNode)node).getParent();
            if (parent == null) {
                return;
            }
            Object sibling = this.context.delegateModel.getChild(parent, this.context.delegateModel.getIndexOfChild(parent, node) + 1);
            if (sibling == null || !(sibling instanceof GUIBranchNode)) {
                int index = this.context.delegateModel.getIndexOfChild(parent, node);
                for (int i = 0; !(i >= index || (sibling = this.context.delegateModel.getChild(parent, i)) != null && sibling instanceof GUIBranchNode); ++i) {
                }
            }
            if (sibling != null && sibling instanceof GUIBranchNode) {
                this.context.proofTreeView.selectBranchNode((GUIBranchNode)sibling);
            }
        }
    }

    class PrevSibling
    extends ProofTreeAction {
        private static final long serialVersionUID = 8705344500396898345L;

        public PrevSibling(ProofTreeContext context) {
            super(context);
            this.setName("Previous Sibling");
            this.setIcon(IconFactory.previous(16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object node = this.context.branch.getLastPathComponent();
            TreeNode parent = ((GUIAbstractTreeNode)node).getParent();
            if (parent == null) {
                return;
            }
            Object sibling = this.context.delegateModel.getChild(parent, this.context.delegateModel.getIndexOfChild(parent, node) - 1);
            if (sibling == null || !(sibling instanceof GUIBranchNode)) {
                int index = this.context.delegateModel.getIndexOfChild(parent, node);
                for (int i = parent.getChildCount(); !(i <= index || (sibling = this.context.delegateModel.getChild(parent, i)) != null && sibling instanceof GUIBranchNode); --i) {
                }
            }
            if (sibling != null && sibling instanceof GUIBranchNode) {
                this.context.proofTreeView.selectBranchNode((GUIBranchNode)sibling);
            }
        }
    }

    class CollapseBelow
    extends ProofTreeAction {
        private static final long serialVersionUID = -7283113335781286556L;

        public CollapseBelow(ProofTreeContext context) {
            super(context);
            this.setName("Collapse Below");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofTreeExpansionState.collapseAllBelow(this.context.delegateView, this.context.path);
        }
    }

    class CollapseAll
    extends ProofTreeAction {
        private static final long serialVersionUID = 5343671322035834491L;

        public CollapseAll(ProofTreeContext context) {
            super(context);
            this.setName("Collapse All");
            this.setIcon(IconFactory.minus(16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofTreeExpansionState.collapseAll(this.context.delegateView);
            this.context.delegateView.expandRow(0);
        }
    }

    class ExpandGoals
    extends ProofTreeAction {
        private static final long serialVersionUID = -8404655108317574685L;

        public ExpandGoals(ProofTreeContext context) {
            super(context);
            this.setName("Expand Goals Only");
            this.setIcon(IconFactory.expandGoals(16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (Goal g : this.context.proof.openGoals()) {
                this.context.proofTreeView.makeNodeExpanded(g.node());
            }
            this.context.proofTreeView.collapseClosedNodes();
            this.context.delegateView.expandRow(0);
        }
    }

    class ExpandAllBelow
    extends ProofTreeAction {
        private static final long serialVersionUID = 850060084128297700L;

        public ExpandAllBelow(ProofTreeContext context) {
            super(context);
            this.setName("Expand All Below");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofTreeExpansionState.expandAllBelow(this.context.delegateView, this.context.path);
        }
    }

    class ExpandAll
    extends ProofTreeAction {
        private static final long serialVersionUID = -8996407746579766286L;

        protected ExpandAll(ProofTreeContext context) {
            super(context);
            this.setName("Expand All");
            this.setIcon(IconFactory.plus(16));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ProofTreeExpansionState.expandAll(this.context.delegateView);
        }
    }

    class ExpandGoalsBelow
    extends ProofTreeAction {
        private static final long serialVersionUID = -500754845710844009L;

        protected ExpandGoalsBelow(ProofTreeContext context) {
            super(context);
            this.setName("Expand Goals Only Below");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Node n;
            GUIAbstractTreeNode node;
            ProofTreeExpansionState.collapseAllBelow(this.context.delegateView, this.context.branch);
            Iterator it = this.context.proof.openGoals().iterator();
            while (it.hasNext() && (node = this.context.delegateModel.getProofTreeNode(n = ((Goal)it.next()).node())) != null) {
                Object[] obs = node.getPath();
                TreePath tp = new TreePath(obs);
                if (!this.context.branch.isDescendant(tp)) continue;
                this.context.delegateView.makeVisible(tp);
            }
        }
    }

    class CollapseOtherBranches
    extends ProofTreeAction {
        private static final long serialVersionUID = -6461403850298323327L;

        protected CollapseOtherBranches(ProofTreeContext context) {
            super(context);
            this.setName("Collapse Other Branches");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.context.proofTreeView.collapseOthers(this.context.branch);
        }
    }

    class SubtreeStatistics
    extends ProofTreeAction {
        private static final long serialVersionUID = -8452239418108180349L;

        protected SubtreeStatistics(ProofTreeContext context) {
            super(context);
            this.setName("Show Subtree Statistics");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Proof proof = this.context.proof;
            if (proof == null) {
                MainWindow.getInstance().notify(new GeneralInformationEvent("No statistics available.", "If you wish to see the statistics for a proof you have to load one first"));
            } else {
                int openGoals = 0;
                Iterator leavesIt = this.context.invokedNode.leavesIterator();
                while (leavesIt.hasNext()) {
                    if (proof.getGoal((Node)leavesIt.next()) == null) continue;
                    ++openGoals;
                }
                Object stats = openGoals > 0 ? openGoals + " open goal" + (openGoals > 1 ? "s." : ".") : "Closed.";
                stats = (String)stats + "\n\n";
                for (Pair x : this.context.invokedNode.statistics().getSummary()) {
                    if ("".equals(x.second)) {
                        stats = (String)stats + "\n";
                    }
                    stats = (String)stats + (String)x.first + ": " + (String)x.second + "\n";
                }
                JOptionPane.showMessageDialog(MainWindow.getInstance(), stats, "Proof Statistics", 1);
            }
        }
    }

    private static class ProofTreeContext {
        GUIProofTreeModel delegateModel;
        ProofTreeView proofTreeView;
        MainWindow window;
        Proof proof;
        KeYMediator mediator;
        Node invokedNode;
        TreePath path;
        TreePath branch;
        JTree delegateView;

        private ProofTreeContext() {
        }
    }
}

