/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.gui.SearchBar;
import de.uka.ilkd.key.gui.prooftree.GUIAbstractTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIBranchNode;
import de.uka.ilkd.key.gui.prooftree.ProofTreeView;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

class ProofTreeSearchBar
extends SearchBar
implements TreeModelListener {
    private static final long serialVersionUID = 683318838568020629L;
    private final ProofTreeView proofTreeView;
    private int startRow = 0;
    private int currentRow = 0;
    private Vector<GUIAbstractTreeNode> cache;

    public ProofTreeSearchBar(ProofTreeView proofTreeView) {
        this.proofTreeView = proofTreeView;
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (!vis && this.proofTreeView != null) {
            this.proofTreeView.delegateView.requestFocusInWindow();
        }
    }

    @Override
    public void searchNext() {
        this.fillCache();
        this.startRow = this.currentRow + 1;
        this.startRow %= this.cache.size();
        this.search(this.searchField.getText(), Position.Bias.Forward);
    }

    @Override
    public void searchPrevious() {
        this.fillCache();
        this.startRow = this.currentRow - 1;
        this.startRow %= this.cache.size();
        this.search(this.searchField.getText(), Position.Bias.Backward);
    }

    @Override
    public boolean search(String searchString) {
        return this.search(searchString, Position.Bias.Forward);
    }

    private synchronized boolean search(String searchString, Position.Bias direction) {
        if (searchString.equals("")) {
            this.startRow = 0;
        }
        this.currentRow = this.getNextMatch(searchString, this.startRow, direction);
        GUIAbstractTreeNode node = null;
        TreePath tp = null;
        if (this.currentRow != -1) {
            node = this.cache.get(this.currentRow);
            tp = new TreePath(node.getPath());
        }
        if (node != null && node instanceof GUIBranchNode) {
            this.proofTreeView.selectBranchNode((GUIBranchNode)node);
        } else {
            this.proofTreeView.delegateView.scrollPathToVisible(tp);
            this.proofTreeView.delegateView.setSelectionPath(tp);
        }
        return this.currentRow != -1;
    }

    public void changedUpdate(DocumentEvent e) {
        this.search();
    }

    public void insertUpdate(DocumentEvent e) {
        this.search();
    }

    public void removeUpdate(DocumentEvent e) {
        this.search();
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        this.reset();
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        this.reset();
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
        this.reset();
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
        this.reset();
    }

    public synchronized void reset() {
        this.cache = null;
    }

    private void fillCache() {
        if (this.cache == null) {
            this.cache = new Vector();
            if (this.proofTreeView.delegateModel.getRoot() != null) {
                this.cache.add((GUIAbstractTreeNode)this.proofTreeView.delegateModel.getRoot());
                this.fillCacheHelp((GUIBranchNode)this.proofTreeView.delegateModel.getRoot());
            }
        }
    }

    private void fillCacheHelp(GUIBranchNode branch) {
        if (branch == null) {
            return;
        }
        for (int i = 0; i < this.proofTreeView.delegateModel.getChildCount(branch); ++i) {
            GUIAbstractTreeNode n = (GUIAbstractTreeNode)this.proofTreeView.delegateModel.getChild(branch, i);
            this.cache.add(n);
            if (!(n instanceof GUIBranchNode)) continue;
            this.fillCacheHelp((GUIBranchNode)n);
        }
    }

    private int getNextMatch(String searchString, int startingRow, Position.Bias bias) {
        this.fillCache();
        String s = searchString.toLowerCase();
        if (bias == Position.Bias.Forward) {
            int i;
            if (startingRow < 0) {
                startingRow = 0;
            }
            for (i = startingRow; i < this.cache.size(); ++i) {
                if (!this.containsString(this.cache.get(i).toString().toLowerCase(), s)) continue;
                return i;
            }
            for (i = 0; i < startingRow && i < this.cache.size(); ++i) {
                if (!this.containsString(this.cache.get(i).toString().toLowerCase(), s)) continue;
                return i;
            }
        } else {
            int i;
            if (startingRow > this.cache.size() - 1) {
                startingRow = this.cache.size() - 1;
            }
            for (i = startingRow; i >= 0; --i) {
                if (!this.containsString(this.cache.get(i).toString().toLowerCase(), s)) continue;
                return i;
            }
            for (i = this.cache.size() - 1; i > startingRow && i > 0; --i) {
                if (!this.containsString(this.cache.get(i).toString().toLowerCase(), s)) continue;
                return i;
            }
        }
        return -1;
    }

    private boolean containsString(String string, String searchString) {
        assert (string != null && searchString != null);
        return string.indexOf(searchString) != -1;
    }
}

