/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.control.AutoModeListener;
import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.GUIListener;
import de.uka.ilkd.key.gui.NodeInfoVisualizer;
import de.uka.ilkd.key.gui.NodeInfoVisualizerListener;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.configuration.Config;
import de.uka.ilkd.key.gui.configuration.ConfigChangeListener;
import de.uka.ilkd.key.gui.extension.api.KeYGuiExtension;
import de.uka.ilkd.key.gui.extension.api.TabPanel;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.nodeviews.TacletInfoToggle;
import de.uka.ilkd.key.gui.prooftree.GUIAbstractTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIBranchNode;
import de.uka.ilkd.key.gui.prooftree.GUIOneStepChildTreeNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeModel;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeNode;
import de.uka.ilkd.key.gui.prooftree.ProofTreeExpansionState;
import de.uka.ilkd.key.gui.prooftree.ProofTreePopupFactory;
import de.uka.ilkd.key.gui.prooftree.ProofTreeSearchBar;
import de.uka.ilkd.key.gui.prooftree.Style;
import de.uka.ilkd.key.gui.prooftree.Styler;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.proof.ProofEvent;
import de.uka.ilkd.key.proof.ProofVisitor;
import de.uka.ilkd.key.proof.RuleAppListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.EventObject;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.WeakHashMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.key_project.util.collection.ImmutableList;
import org.key_project.util.collection.ImmutableSLList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProofTreeView
extends JPanel
implements TabPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProofTreeView.class);
    public static final ColorSettings.ColorProperty GRAY_COLOR = ColorSettings.define("[proofTree]gray", "", Color.DARK_GRAY);
    public static final ColorSettings.ColorProperty BISQUE_COLOR = ColorSettings.define("[proofTree]bisque", "", new Color(240, 228, 196));
    public static final ColorSettings.ColorProperty LIGHT_BLUE_COLOR = ColorSettings.define("[proofTree]lightBlue", "", new Color(230, 254, 255));
    public static final ColorSettings.ColorProperty DARK_BLUE_COLOR = ColorSettings.define("[proofTree]darkBlue", "", new Color(31, 77, 153));
    public static final ColorSettings.ColorProperty DARK_GREEN_COLOR = ColorSettings.define("[proofTree]darkGreen", "", new Color(0, 128, 51));
    public static final ColorSettings.ColorProperty DARK_RED_COLOR = ColorSettings.define("[proofTree]darkRed", "", new Color(191, 0, 0));
    public static final ColorSettings.ColorProperty PINK_COLOR = ColorSettings.define("[proofTree]pink", "", new Color(255, 0, 240));
    public static final ColorSettings.ColorProperty ORANGE_COLOR = ColorSettings.define("[proofTree]orange", "", new Color(255, 140, 0));
    public static final KeyStroke searchKeyStroke = KeyStroke.getKeyStroke(70, 0xC0 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask());
    private static final long serialVersionUID = 3732875161168302809L;
    public final TacletInfoToggle tacletInfoToggle = new TacletInfoToggle();
    private final ProofTreePopupFactory proofTreePopupFactory = new ProofTreePopupFactory();
    final JTree delegateView;
    GUIProofTreeModel delegateModel;
    private KeYMediator mediator;
    private final WeakHashMap<Proof, GUIProofTreeModel> models = new WeakHashMap(20);
    private Proof proof;
    private ProofTreeExpansionState expansionState;
    private GUIProofTreeProofListener proofListener;
    private GUITreeSelectionListener treeSelectionListener;
    private GUIProofTreeGUIListener guiListener;
    private final NodeInfoVisualizerListener nodeInfoVisListener = new NodeInfoVisualizerListener(){

        @Override
        public void visualizerUnregistered(NodeInfoVisualizer vis) {
            if (vis.getNode().proof() != null && !vis.getNode().proof().isDisposed() && vis.getNode().proof() == ProofTreeView.this.proof) {
                ProofTreeView.this.delegateModel.updateTree(vis.getNode());
            }
        }

        @Override
        public void visualizerRegistered(NodeInfoVisualizer vis) {
            ProofTreeView.this.delegateModel.updateTree(vis.getNode());
        }
    };
    private final ConfigChangeListener configChangeListener = e -> this.setProofTreeFont();
    private ImmutableList<Node> modifiedSubtrees = null;
    private HashSet<Node> modifiedSubtreesCache = null;
    private ProofTreeSearchBar proofTreeSearchPanel;
    private int iconHeight = 12;
    private final ProofRenderer renderer = new ProofRenderer();

    public ProofTreeView(KeYMediator m) {
        this();
        this.setMediator(m);
    }

    public ProofTreeView() {
        this.proofListener = new GUIProofTreeProofListener();
        this.guiListener = new GUIProofTreeGUIListener();
        this.delegateView = new JTree(new DefaultMutableTreeNode("No proof loaded")){
            private static final long serialVersionUID = 6555955929759162324L;

            @Override
            public void setFont(Font font) {
                ProofTreeView.this.iconHeight = font.getSize();
                super.setFont(font);
            }

            @Override
            public void updateUI() {
                super.updateUI();
                TreeUI ui = this.getUI();
                if (ui instanceof BasicTreeUI) {
                    BasicTreeUI treeUI = (BasicTreeUI)ui;
                    treeUI.setExpandedIcon(IconFactory.expandedIcon(ProofTreeView.this.iconHeight));
                    treeUI.setCollapsedIcon(IconFactory.collapsedIcon(ProofTreeView.this.iconHeight));
                }
                if (ui instanceof CacheLessMetalTreeUI) {
                    ((CacheLessMetalTreeUI)ui).clearDrawingCache();
                }
            }
        };
        this.iconHeight = this.delegateView.getFontMetrics(this.delegateView.getFont()).getHeight();
        this.delegateView.setUI(new CacheLessMetalTreeUI());
        this.delegateView.getInputMap(0).getParent().remove(KeyStroke.getKeyStroke(38, 2));
        this.delegateView.getInputMap(0).getParent().remove(KeyStroke.getKeyStroke(40, 2));
        this.delegateView.setInvokesStopCellEditing(true);
        this.delegateView.getSelectionModel().setSelectionMode(1);
        this.treeSelectionListener = new GUITreeSelectionListener();
        this.delegateView.addTreeSelectionListener(this.treeSelectionListener);
        this.delegateView.setScrollsOnExpand(true);
        ToolTipManager.sharedInstance().registerComponent(this.delegateView);
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TreePath selPath;
                if (e.isPopupTrigger() && (selPath = ProofTreeView.this.delegateView.getPathForLocation(e.getX(), e.getY())) != null && (selPath.getLastPathComponent() instanceof GUIProofTreeNode || selPath.getLastPathComponent() instanceof GUIBranchNode)) {
                    ProofTreeView.this.delegateView.setSelectionPath(selPath);
                    JPopupMenu popup = ProofTreeView.this.proofTreePopupFactory.create(ProofTreeView.this, selPath);
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.mousePressed(e);
            }
        };
        this.delegateView.addMouseListener(ml);
        NodeInfoVisualizer.addListener(this.nodeInfoVisListener);
        Config.DEFAULT.addConfigChangeListener(this.configChangeListener);
        this.setProofTreeFont();
        this.delegateView.setLargeModel(true);
        this.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.add((Component)this.tacletInfoToggle, "North");
        this.proofTreeSearchPanel = new ProofTreeSearchBar(this);
        bottomPanel.add((Component)this.proofTreeSearchPanel, "South");
        this.add((Component)new JScrollPane(this.delegateView), "Center");
        this.add((Component)bottomPanel, "South");
        this.layoutKeYComponent();
        ActionListener keyboardAction = e -> this.showSearchPanel();
        this.registerKeyboardAction(keyboardAction, searchKeyStroke, 1);
        KeYGuiExtensionFacade.installKeyboardShortcuts(this.mediator, this, KeYGuiExtension.KeyboardShortcuts.PROOF_TREE_VIEW);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        Config.DEFAULT.removeConfigChangeListener(this.configChangeListener);
        NodeInfoVisualizer.removeListener(this.nodeInfoVisListener);
    }

    private void setProofTreeFont() {
        Font myFont = UIManager.getFont("KEY_FONT_PROOF_TREE");
        int rowHeight = this.delegateView.getFontMetrics(this.delegateView.getFont()).getHeight();
        if (myFont != null) {
            rowHeight = this.delegateView.getFontMetrics(myFont).getHeight();
            this.delegateView.setRowHeight(rowHeight);
            this.delegateView.setFont(myFont);
        } else {
            LOGGER.debug("KEY-PROOF_TREE_FONT not available, use standard font.");
            this.delegateView.setRowHeight(rowHeight);
        }
    }

    public ProofRenderer getRenderer() {
        return this.renderer;
    }

    protected void layoutKeYComponent() {
        this.delegateView.setBackground(Color.white);
        this.delegateView.setCellRenderer(this.renderer);
        this.delegateView.putClientProperty("JTree.lineStyle", "Angled");
        this.delegateView.setVisible(true);
    }

    public KeYMediator getMediator() {
        return this.mediator;
    }

    private void setMediator(KeYMediator m) {
        assert (m != null);
        if (this.mediator != null) {
            this.unregister();
        }
        this.mediator = m;
        this.register();
        Proof selProof = this.mediator.getSelectedProof();
        if (selProof != null) {
            this.setProof(selProof);
        }
    }

    private void register() {
        this.mediator.addKeYSelectionListener(this.proofListener);
        this.mediator.getUI().getProofControl().addAutoModeListener(this.proofListener);
        this.mediator.addGUIListener(this.guiListener);
    }

    private void unregister() {
        this.mediator.removeKeYSelectionListener(this.proofListener);
        this.mediator.getUI().getProofControl().removeAutoModeListener(this.proofListener);
        this.mediator.removeGUIListener(this.guiListener);
    }

    public boolean selectAbove() {
        return this.selectRelative(1);
    }

    public boolean selectBelow() {
        return this.selectRelative(-1);
    }

    private boolean selectRelative(int i) {
        TreePath path = this.delegateView.getSelectionPath();
        int row = this.delegateView.getRowForPath(path);
        TreePath newPath = this.delegateView.getPathForRow(row - i);
        if (newPath != null) {
            this.delegateView.setSelectionPath(newPath);
            return true;
        }
        return false;
    }

    private void setProof(Proof p) {
        if (this.delegateModel != null) {
            this.expansionState.disconnect();
            this.delegateModel.setExpansionState(this.expansionState.copyState());
            this.delegateModel.storeSelection(this.delegateView.getSelectionPath());
            this.delegateModel.unregister();
            this.delegateModel.removeTreeModelListener(this.proofTreeSearchPanel);
        }
        if (this.proof != null && !this.proof.isDisposed()) {
            this.proof.removeRuleAppListener((RuleAppListener)this.proofListener);
        }
        Proof oldProof = this.proof;
        this.proof = p;
        if (this.proof != null) {
            this.proof.addRuleAppListener((RuleAppListener)this.proofListener);
            this.delegateModel = this.models.get(p);
            if (this.delegateModel == null) {
                this.delegateModel = new GUIProofTreeModel(p);
                this.models.put(p, this.delegateModel);
            }
            this.delegateModel.addTreeModelListener(this.proofTreeSearchPanel);
            this.delegateModel.register();
            this.delegateView.setModel(this.delegateModel);
            this.expansionState = new ProofTreeExpansionState(this.delegateView, this.delegateModel.getExpansionState());
            this.delegateView.expandRow(0);
            if (oldProof == null || !oldProof.equals(this.proof)) {
                this.delegateModel.updateTree((Node)null);
            }
            this.delegateView.setSelectionPath(this.delegateModel.getSelection());
            this.delegateView.scrollPathToVisible(this.delegateModel.getSelection());
        } else {
            this.delegateModel = null;
            this.delegateView.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("No proof loaded.")));
            this.expansionState = null;
        }
        this.proofTreeSearchPanel.reset();
    }

    public void removeProofs(Proof[] ps) {
        for (Proof p : ps) {
            this.models.remove(p);
            this.mediator.getCurrentlyOpenedProofs().removeElement(p);
        }
    }

    public void makeNodeVisible(Node n) {
        if (n == null) {
            return;
        }
        GUIAbstractTreeNode node = this.delegateModel.getProofTreeNode(n);
        if (node == null) {
            return;
        }
        Object[] obs = node.getPath();
        TreePath tp = new TreePath(obs);
        this.treeSelectionListener.ignoreChange = true;
        this.delegateView.getSelectionModel().setSelectionPath(tp);
        this.delegateView.scrollPathToVisible(tp);
        this.delegateView.validate();
        this.treeSelectionListener.ignoreChange = false;
    }

    protected void makeNodeExpanded(Node n) {
        GUIAbstractTreeNode node = this.delegateModel.getProofTreeNode(n);
        if (node == null) {
            return;
        }
        Object[] obs = node.getPath();
        TreePath tp = new TreePath(obs);
        this.delegateView.makeVisible(tp);
    }

    protected void collapseClosedNodes() {
        this.collapseClosedNodesHelp(new TreePath(this.delegateModel.getRoot()));
    }

    private void collapseClosedNodesHelp(TreePath path) {
        if (!this.delegateView.isExpanded(path)) {
            return;
        }
        Object node = path.getLastPathComponent();
        if (node instanceof GUIBranchNode && ((GUIBranchNode)node).getNode().isClosed()) {
            this.delegateView.collapsePath(path);
            return;
        }
        int count = this.delegateModel.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            Object child = this.delegateModel.getChild(node, i);
            if (this.delegateModel.isLeaf(child)) continue;
            this.collapseClosedNodesHelp(path.pathByAddingChild(child));
        }
    }

    protected void collapseOthers(TreePath path) {
        this.collapseOthersHelp(new TreePath(this.delegateModel.getRoot()), path);
    }

    private void collapseOthersHelp(TreePath start, TreePath stop) {
        if (!this.delegateView.isExpanded(start) || start.equals(stop)) {
            return;
        }
        Object node = start.getLastPathComponent();
        if (node instanceof GUIBranchNode && !start.isDescendant(stop)) {
            this.delegateView.collapsePath(start);
            return;
        }
        int count = this.delegateModel.getChildCount(node);
        for (int i = 0; i < count; ++i) {
            Object child = this.delegateModel.getChild(node, i);
            if (this.delegateModel.isLeaf(child)) continue;
            this.collapseOthersHelp(start.pathByAddingChild(child), stop);
        }
    }

    void selectBranchNode(GUIBranchNode node) {
        if (node == null) {
            return;
        }
        this.proofListener.ignoreNodeSelectionChange = true;
        this.mediator.getSelectionModel().setSelectedNode(node.getNode());
        this.proofListener.ignoreNodeSelectionChange = false;
        TreePath tp = new TreePath(node.getPath());
        this.treeSelectionListener.ignoreChange = true;
        this.delegateView.getSelectionModel().setSelectionPath(tp);
        this.delegateView.scrollPathToVisible(tp);
        this.delegateView.validate();
        this.treeSelectionListener.ignoreChange = false;
        this.delegateModel.storeSelection(this.delegateView.getSelectionPath());
    }

    private void addModifiedNode(Node pNode) {
        if (this.modifiedSubtrees == null) {
            return;
        }
        try {
            if (!this.modifiedSubtrees.isEmpty()) {
                Node n = pNode;
                while (true) {
                    if (this.modifiedSubtreesCache.contains(n)) {
                        return;
                    }
                    if (n.root()) break;
                    n = n.parent();
                }
            }
            this.modifiedSubtrees = this.modifiedSubtrees.prepend((Object)pNode);
        }
        finally {
            this.modifiedSubtreesCache.add(pNode);
        }
    }

    public void showSearchPanel() {
        this.proofTreeSearchPanel.setVisible(true);
    }

    @Override
    public String getTitle() {
        return "Proof";
    }

    @Override
    public Icon getIcon() {
        return IconFactory.PROOF_TREE.get(16.0f);
    }

    @Override
    public JComponent getComponent() {
        return this;
    }

    public GUIProofTreeModel getDelegateModel() {
        return this.delegateModel;
    }

    public ProofTreePopupFactory getProofTreePopupFactory() {
        return this.proofTreePopupFactory;
    }

    public class ProofRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        private final List<Styler<GUIAbstractTreeNode>> stylers = new LinkedList<Styler<GUIAbstractTreeNode>>();

        public ProofRenderer() {
            this.stylers.add((style, treeNode) -> this.closedGoal(style, (GUIAbstractTreeNode)treeNode));
            this.stylers.add((style, node) -> this.oneStepSimplification(style, (GUIAbstractTreeNode)node));
            this.stylers.add((style, node) -> this.renderLeaf(style, (GUIAbstractTreeNode)node));
            this.stylers.add((style, treeNode) -> this.renderNonLeaf(style, (GUIAbstractTreeNode)treeNode));
            this.stylers.add((style, treeNode) -> this.checkNotes(style, (GUIAbstractTreeNode)treeNode));
        }

        public void add(Styler<GUIAbstractTreeNode> guiAbstractTreeNodeStyler) {
            this.stylers.add(0, guiAbstractTreeNodeStyler);
        }

        private void closedGoal(Style style, GUIAbstractTreeNode treeNode) {
            try {
                GUIBranchNode node = (GUIBranchNode)treeNode;
                style.set(Style.KEY_ICON, this.getIcon());
                if (node.isClosed()) {
                    style.set(Style.KEY_ICON, IconFactory.provedFolderIcon(ProofTreeView.this.iconHeight));
                } else {
                    class FindGoalVisitor
                    implements ProofVisitor {
                        private boolean isLinked = false;

                        FindGoalVisitor() {
                        }

                        public boolean isLinked() {
                            return this.isLinked;
                        }

                        public void visit(Proof proof, Node visitedNode) {
                            Goal g = proof.getGoal(visitedNode);
                            if (g != null && g.isLinked()) {
                                this.isLinked = true;
                            }
                        }
                    }
                    FindGoalVisitor v = new FindGoalVisitor();
                    ProofTreeView.this.proof.breadthFirstSearch(node.getNode(), (ProofVisitor)v);
                    if (v.isLinked()) {
                        style.set(Style.KEY_ICON, IconFactory.linkedFolderIcon(ProofTreeView.this.iconHeight));
                    }
                }
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        private void renderLeaf(Style style, GUIAbstractTreeNode node) {
            try {
                Object toolTipText;
                if (!node.getNode().leaf() || node instanceof GUIBranchNode) {
                    return;
                }
                Node leaf = node.getNode();
                Goal goal = ProofTreeView.this.proof.getGoal(leaf);
                String notes = leaf.getNodeInfo().getNotes();
                if (goal == null || leaf.isClosed()) {
                    style.setAndSeal(Style.KEY_COLOR_FOREGROUND, DARK_GREEN_COLOR.get());
                    style.set(Style.KEY_ICON, IconFactory.keyHoleClosed(ProofTreeView.this.iconHeight));
                    ProofTreeView.this.setToolTipText("Closed Goal");
                    toolTipText = "A closed goal";
                } else if (goal.isLinked()) {
                    style.set(Style.KEY_COLOR_FOREGROUND, PINK_COLOR.get());
                    style.set(Style.KEY_ICON, IconFactory.keyHoleLinked(20, 20));
                    ProofTreeView.this.setToolTipText("Linked Goal");
                    toolTipText = "Linked goal - no automatic rule application";
                } else if (!goal.isAutomatic()) {
                    style.set(Style.KEY_COLOR_FOREGROUND, ORANGE_COLOR.get());
                    style.set(Style.KEY_ICON, IconFactory.keyHoleInteractive(20, 20));
                    ProofTreeView.this.setToolTipText("Disabled Goal");
                    toolTipText = "Interactive goal - no automatic rule application";
                } else {
                    style.setAndSeal(Style.KEY_COLOR_FOREGROUND, DARK_RED_COLOR.get());
                    style.set(Style.KEY_ICON, IconFactory.keyHole(20, 20));
                    ProofTreeView.this.setToolTipText("Open Goal");
                    toolTipText = "An open goal";
                }
                if (notes != null) {
                    toolTipText = (String)toolTipText + ".\nNotes: " + notes;
                }
                style.set(Style.KEY_TOOLTIP, toolTipText);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }

        private void renderNonLeaf(Style style, GUIAbstractTreeNode treeNode) {
            Node node = treeNode.getNode();
            if (node.leaf() || treeNode instanceof GUIBranchNode) {
                return;
            }
            style.set(Style.KEY_COLOR_FOREGROUND, Color.black);
            Object tooltipText = "An inner node of the proof";
            String notes = node.getNodeInfo().getNotes();
            if (notes != null) {
                tooltipText = (String)tooltipText + ".\nNotes: " + notes;
            }
            Icon defaultIcon = NodeInfoVisualizer.hasInstances(node) ? IconFactory.WINDOW_ICON.get() : (notes != null ? IconFactory.editFile(16) : (node.getNodeInfo().getInteractiveRuleApplication() ? IconFactory.interactiveAppLogo(16) : (node.getNodeInfo().getScriptRuleApplication() ? IconFactory.scriptAppLogo(16) : null)));
            boolean isBranch = false;
            Node child = treeNode.findChild(node);
            if (child != null && child.getNodeInfo().getBranchLabel() != null) {
                isBranch = true;
                style.set(Style.KEY_TEXT, style.get(Style.KEY_TEXT) + ": " + child.getNodeInfo().getBranchLabel());
            }
            if (isBranch && node.childrenCount() > 1) {
                defaultIcon = this.getOpenIcon();
                tooltipText = "A branch node with all children hidden";
            }
            style.set(Style.KEY_ICON, defaultIcon);
            style.set(Style.KEY_TOOLTIP, tooltipText);
        }

        private void checkNotes(Style style, GUIAbstractTreeNode treeNode) {
            Node node = treeNode.getNode();
            if (node.getNodeInfo().getNotes() != null) {
                style.set(Style.KEY_COLOR_BACKGROUND, ORANGE_COLOR.get());
            } else if (node.getNodeInfo().getActiveStatement() != null) {
                style.set(Style.KEY_COLOR_BACKGROUND, LIGHT_BLUE_COLOR.get());
            } else {
                style.set(Style.KEY_COLOR_BACKGROUND, Color.white);
            }
        }

        private void oneStepSimplification(Style style, GUIAbstractTreeNode node) {
            if (node instanceof GUIOneStepChildTreeNode) {
                style.set(Style.KEY_COLOR_FOREGROUND, GRAY_COLOR.get());
                style.set(Style.KEY_ICON, IconFactory.oneStepSimplifier(16));
                style.set(Style.KEY_TEXT, node.toString());
            }
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (ProofTreeView.this.proof == null) {
                return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            }
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            Style style = new Style();
            style.set(Style.KEY_COLOR_FOREGROUND, this.getForeground());
            style.set(Style.KEY_COLOR_BACKGROUND, this.getBackground());
            style.set(Style.KEY_COLOR_BORDER, Color.WHITE);
            style.set(Style.KEY_FONT_BOLD, false);
            style.set(Style.KEY_FONT_ITALIC, false);
            style.set(Style.KEY_TOOLTIP, "");
            style.set(Style.KEY_ICON, null);
            this.stylers.forEach(it -> it.style(style, (GUIAbstractTreeNode)value));
            this.setForeground(style.get(Style.KEY_COLOR_FOREGROUND));
            this.setBackground(style.get(Style.KEY_COLOR_BACKGROUND));
            if (style.get(Style.KEY_COLOR_BORDER) != null) {
                this.setBorder(BorderFactory.createLineBorder(style.get(Style.KEY_COLOR_BORDER)));
            } else {
                this.setBorder(BorderFactory.createLineBorder(Color.WHITE));
            }
            int fontStyle = (style.getBoolean(Style.KEY_FONT_BOLD) ? 1 : 0) | (style.getBoolean(Style.KEY_FONT_ITALIC) ? 2 : 0);
            this.setFont(this.getFont().deriveFont(fontStyle));
            this.setToolTipText(style.get(Style.KEY_TOOLTIP));
            this.setIcon(style.get(Style.KEY_ICON));
            return this;
        }
    }

    class GUITreeSelectionListener
    implements TreeSelectionListener,
    Serializable {
        private static final long serialVersionUID = 1417544836006726419L;
        public boolean ignoreChange = false;

        GUITreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            if (this.ignoreChange) {
                return;
            }
            if (e.getNewLeadSelectionPath() == null) {
                return;
            }
            if (!(e.getNewLeadSelectionPath().getLastPathComponent() instanceof GUIAbstractTreeNode)) {
                return;
            }
            TreePath newTP = e.getNewLeadSelectionPath();
            ProofTreeView.this.delegateModel.storeSelection(newTP);
            GUIAbstractTreeNode treeNode = (GUIAbstractTreeNode)e.getNewLeadSelectionPath().getLastPathComponent();
            if (treeNode instanceof GUIBranchNode) {
                ProofTreeView.this.selectBranchNode((GUIBranchNode)treeNode);
            } else {
                Node node = treeNode.getNode();
                Goal selected = ProofTreeView.this.proof.getGoal(node);
                if (selected != null) {
                    ProofTreeView.this.mediator.goalChosen(selected);
                } else {
                    ProofTreeView.this.mediator.nonGoalNodeChosen(node);
                }
            }
            ProofTreeView.this.delegateView.setEditable(treeNode instanceof GUIBranchNode && treeNode.getNode().parent() != null);
        }
    }

    class GUIProofTreeProofListener
    implements AutoModeListener,
    RuleAppListener,
    KeYSelectionListener {
        public boolean ignoreNodeSelectionChange = false;
        private Node lastGoalNode;

        GUIProofTreeProofListener() {
        }

        public void makeSelectedNodeVisible(Node selectedNode) {
            if (selectedNode != null) {
                if (ProofTreeView.this.proof != selectedNode.proof()) {
                    return;
                }
                this.lastGoalNode = selectedNode;
            }
            ProofTreeView.this.makeNodeVisible(this.lastGoalNode);
            ProofTreeView.this.delegateView.validate();
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
            if (!this.ignoreNodeSelectionChange) {
                this.makeSelectedNodeVisible(ProofTreeView.this.mediator.getSelectedNode());
            }
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            LOGGER.debug("ProofTreeView: initialize with new proof");
            this.lastGoalNode = null;
            ProofTreeView.this.setProof(e.getSource().getSelectedProof());
            ProofTreeView.this.delegateView.validate();
        }

        public void autoModeStarted(ProofEvent e) {
            ProofTreeView.this.modifiedSubtrees = ImmutableSLList.nil();
            ProofTreeView.this.modifiedSubtreesCache = new LinkedHashSet<Node>();
            if (ProofTreeView.this.delegateModel == null) {
                LOGGER.debug("delegateModel is null");
                return;
            }
            if (ProofTreeView.this.delegateModel.isAttentive()) {
                ProofTreeView.this.mediator.removeKeYSelectionListener(ProofTreeView.this.proofListener);
            }
            ProofTreeView.this.delegateModel.setAttentive(false);
        }

        public void autoModeStopped(ProofEvent e) {
            if (ProofTreeView.this.mediator.getSelectedProof() == null) {
                return;
            }
            ProofTreeView.this.delegateView.removeTreeSelectionListener(ProofTreeView.this.treeSelectionListener);
            if (ProofTreeView.this.delegateModel == null) {
                ProofTreeView.this.setProof(ProofTreeView.this.mediator.getSelectedProof());
            } else if (ProofTreeView.this.modifiedSubtrees != null) {
                for (Node n : ProofTreeView.this.modifiedSubtrees) {
                    ProofTreeView.this.delegateModel.updateTree(n);
                }
            }
            if (!ProofTreeView.this.delegateModel.isAttentive()) {
                ProofTreeView.this.delegateModel.setAttentive(true);
                ProofTreeView.this.mediator.addKeYSelectionListener(ProofTreeView.this.proofListener);
            }
            this.makeSelectedNodeVisible(ProofTreeView.this.mediator.getSelectedNode());
            ProofTreeView.this.delegateView.addTreeSelectionListener(ProofTreeView.this.treeSelectionListener);
            ProofTreeView.this.delegateView.validate();
            ProofTreeView.this.modifiedSubtrees = null;
            ProofTreeView.this.modifiedSubtreesCache = null;
        }

        public void ruleApplied(ProofEvent e) {
            ProofTreeView.this.addModifiedNode(e.getRuleAppInfo().getOriginalNode());
        }
    }

    class GUIProofTreeGUIListener
    implements GUIListener,
    Serializable {
        private static final long serialVersionUID = 4224100114740308297L;

        GUIProofTreeGUIListener() {
        }

        @Override
        public void modalDialogOpened(EventObject e) {
            ProofTreeView.this.delegateView.setEnabled(false);
        }

        @Override
        public void modalDialogClosed(EventObject e) {
            ProofTreeView.this.delegateView.setEnabled(true);
        }

        @Override
        public void shutDown(EventObject e) {
        }
    }

    private static class CacheLessMetalTreeUI
    extends MetalTreeUI {
        private CacheLessMetalTreeUI() {
        }

        public void clearDrawingCache() {
            this.drawingCache.clear();
        }
    }
}

