/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import de.uka.ilkd.key.gui.prooftree.GUIBranchNode;
import de.uka.ilkd.key.gui.prooftree.GUIProofTreeNode;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Node;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import java.util.Arrays;
import javax.swing.tree.TreeNode;

public abstract class ProofTreeViewFilter {
    public static final ProofTreeViewFilter HIDE_INTERMEDIATE = new HideIntermediateFilter();
    public static final ProofTreeViewFilter HIDE_CLOSED_SUBTREES = new HideClosedSubtreesFilter();
    public static final ProofTreeViewFilter ONLY_INTERACTIVE = new OnlyInteractiveFilter();
    public static final ProofTreeViewFilter HIDE_INTERACTIVE_GOALS = new HideInteractiveGoalsFilter();
    public static final ProofTreeViewFilter[] ALL = new ProofTreeViewFilter[]{HIDE_INTERMEDIATE, ONLY_INTERACTIVE, HIDE_CLOSED_SUBTREES, HIDE_INTERACTIVE_GOALS};
    public static final ProofTreeViewFilter[] ALL_GLOBAL_FILTERS = new ProofTreeViewFilter[]{HIDE_CLOSED_SUBTREES, HIDE_INTERACTIVE_GOALS};

    public static boolean hiddenByGlobalFilters(Node node) {
        return Arrays.stream(ALL_GLOBAL_FILTERS).anyMatch(filter -> filter.isActive() && !filter.showSubtree(node));
    }

    public abstract String name();

    public abstract boolean showSubtree(Node var1);

    public abstract boolean isActive();

    public boolean addToProofTreeView() {
        return true;
    }

    abstract void setActive(boolean var1);

    abstract boolean global();

    private static class HideInteractiveGoalsFilter
    extends ProofTreeViewFilter {
        private HideInteractiveGoalsFilter() {
        }

        @Override
        public boolean isActive() {
            return ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getHideInteractiveGoals();
        }

        @Override
        void setActive(boolean active) {
            ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setHideInteractiveGoals(active);
        }

        @Override
        public String name() {
            return "Hide Subtrees Whose Goals are Interactive";
        }

        @Override
        boolean global() {
            return true;
        }

        @Override
        public boolean addToProofTreeView() {
            return false;
        }

        @Override
        public boolean showSubtree(Node node) {
            Proof proof = node.proof();
            for (Goal goal : proof.getSubtreeGoals(node)) {
                if (!goal.isAutomatic()) continue;
                return true;
            }
            return proof.getSubtreeGoals(node).isEmpty();
        }
    }

    private static class HideClosedSubtreesFilter
    extends ProofTreeViewFilter {
        private HideClosedSubtreesFilter() {
        }

        @Override
        public boolean isActive() {
            return ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getHideClosedSubtrees();
        }

        @Override
        void setActive(boolean active) {
            ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setHideClosedSubtrees(active);
        }

        @Override
        public String name() {
            return "Hide Closed Subtrees";
        }

        @Override
        boolean global() {
            return true;
        }

        @Override
        public boolean showSubtree(Node node) {
            return !node.isClosed();
        }
    }

    private static class OnlyInteractiveFilter
    extends NodeFilter {
        private OnlyInteractiveFilter() {
        }

        @Override
        protected boolean countChild(GUIProofTreeNode node, TreeNode parent, int pos) {
            if (node.getNode().getNodeInfo().getInteractiveRuleApplication()) {
                return true;
            }
            if (pos == parent.getChildCount() - 1) {
                return true;
            }
            for (ProofTreeViewFilter filter : ALL_GLOBAL_FILTERS) {
                if (!filter.isActive() || parent.getChildAt(pos + 1) instanceof GUIBranchNode || node.getNode().childrenCount() == 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isActive() {
            return ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getHideAutomodeProofsteps();
        }

        @Override
        void setActive(boolean active) {
            ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setHideAutomodeProofsteps(active);
        }

        @Override
        public String name() {
            return "Hide Non-interactive Proofsteps";
        }

        @Override
        public boolean showSubtree(Node node) {
            return node.getNodeInfo().getInteractiveRuleApplication();
        }
    }

    private static class HideIntermediateFilter
    extends NodeFilter {
        private HideIntermediateFilter() {
        }

        @Override
        protected boolean countChild(GUIProofTreeNode node, TreeNode parent, int pos) {
            if (pos == parent.getChildCount() - 1) {
                return true;
            }
            for (ProofTreeViewFilter filter : ALL_GLOBAL_FILTERS) {
                if (!filter.isActive() || parent.getChildAt(pos + 1) instanceof GUIBranchNode || node.getNode().childrenCount() == 1) continue;
                return true;
            }
            return false;
        }

        @Override
        public boolean isActive() {
            return ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().getHideIntermediateProofsteps();
        }

        @Override
        void setActive(boolean active) {
            ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings().setHideIntermediateProofsteps(active);
        }

        @Override
        public String name() {
            return "Hide Intermediate Proofsteps";
        }

        @Override
        public boolean showSubtree(Node node) {
            Node parent = node.parent();
            return node.equals(parent.child(parent.childrenCount() - 1));
        }
    }

    static abstract class NodeFilter
    extends ProofTreeViewFilter {
        NodeFilter() {
        }

        @Override
        boolean global() {
            return false;
        }

        protected abstract boolean countChild(GUIProofTreeNode var1, TreeNode var2, int var3);

        public int getChildCount(Object parent) {
            int count = 0;
            for (int i = 0; i < ((TreeNode)parent).getChildCount(); ++i) {
                TreeNode child = ((TreeNode)parent).getChildAt(i);
                if (!this.countChild(child, (TreeNode)parent, i)) continue;
                ++count;
            }
            return count;
        }

        public Object getChild(Object parent, int index) {
            int count = -1;
            for (int i = 0; i < ((TreeNode)parent).getChildCount(); ++i) {
                TreeNode child = ((TreeNode)parent).getChildAt(i);
                if (!this.countChild(child, (TreeNode)parent, i) || index != ++count) continue;
                return child;
            }
            return null;
        }

        public int getIndexOfChild(Object parent, Object child) {
            TreeNode guiParent = (TreeNode)parent;
            int count = -1;
            for (int i = 0; i < guiParent.getChildCount(); ++i) {
                if (!this.countChild(guiParent.getChildAt(i), guiParent, i)) continue;
                ++count;
                if (guiParent.getChildAt(i) != child) continue;
                return count;
            }
            return -1;
        }

        protected boolean countChild(TreeNode child, TreeNode parent, int pos) {
            if (child instanceof GUIProofTreeNode) {
                return this.countChild((GUIProofTreeNode)child, parent, pos);
            }
            if (child instanceof GUIBranchNode) {
                return true;
            }
            return true;
        }
    }
}

