/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.prooftree;

import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.Icon;

public class Style {
    private final Map<Object, Object> styles = new HashMap<Object, Object>();
    private final Set<Object> sealed = new HashSet<Object>();
    public static final Key<Color> KEY_COLOR_FOREGROUND = new Key<Color>(Color.class);
    public static final Key<Color> KEY_COLOR_BACKGROUND = new Key<Color>(Color.class);
    public static final Key<Color> KEY_COLOR_BORDER = new Key<Color>(Color.class);
    public static final Key<Boolean> KEY_FONT_ITALIC = new Key<Boolean>(Boolean.class);
    public static final Key<Boolean> KEY_FONT_BOLD = new Key<Boolean>(Boolean.class);
    public static final Key<Icon> KEY_ICON = new Key<Icon>(Icon.class);
    public static final Key<String> KEY_TOOLTIP = new Key<String>(String.class);
    public static final Key<String> KEY_TEXT = new Key<String>(String.class);

    @Nonnull
    public <T> Style set(@Nonnull Key<T> key, @Nullable T value) {
        if (!this.sealed.contains(key)) {
            this.styles.put(key, value);
        }
        return this;
    }

    @Nonnull
    public <T> Style setAndSeal(@Nonnull Key<T> key, @Nullable T value) {
        this.set(key, value);
        this.sealed.add(key);
        return this;
    }

    public <T> boolean contains(@Nonnull Key<T> key) {
        return this.styles.containsKey(key);
    }

    @Nullable
    public <T> T get(@Nonnull Key<T> key, @Nullable T defaultValue) {
        return (T)this.styles.getOrDefault(key, defaultValue);
    }

    @Nullable
    public <T> T get(@Nonnull Key<T> key) {
        return this.get(key, null);
    }

    public boolean getBoolean(Key<Boolean> key) {
        return this.get(key) == Boolean.TRUE;
    }

    private static class Key<T> {
        <T> Key(Class<T> clazz) {
        }
    }
}

