/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import java.awt.Dialog;
import java.awt.Font;
import java.awt.Window;
import java.util.HashMap;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FontSizeFacade {
    private static String[] KEYS = new String[]{"Button.font", "CheckBox.font", "CheckBoxMenuItem.acceleratorFont", "CheckBoxMenuItem.font", "ColorChooser.font", "ComboBox.font", "EditorPane.font", "FormattedTextField.font", "IconButton.font", "InternalFrame.optionDialogTitleFont", "InternalFrame.paletteTitleFont", "InternalFrame.titleFont", "Label.font", "List.font", "Menu.acceleratorFont", "Menu.font", "MenuBar.font", "MenuItem.acceleratorFont", "MenuItem.font", "OptionPane.buttonFont", "OptionPane.font", "OptionPane.messageFont", "Panel.font", "PasswordField.font", "PopupMenu.font", "ProgressBar.font", "RadioButton.font", "RadioButtonMenuItem.acceleratorFont", "RadioButtonMenuItem.font", "ScrollPane.font", "Slider.font", "Spinner.font", "TabbedPane.font", "TabbedPane.smallFont", "Table.font", "TableHeader.font", "TextArea.font", "TextField.font", "TextPane.font", "TitledBorder.font", "ToggleButton.font", "ToolBar.font", "ToolTip.font", "Tree.font", "Viewport.font"};
    private static Map<String, Integer> originalFontSize = new HashMap<String, Integer>();
    private static double currentFactor = 1.0;

    public static void saveCurrentFontSizes() {
        for (String k : KEYS) {
            Font f = UIManager.getDefaults().getFont(k);
            if (f == null) continue;
            originalFontSize.put(k, f.getSize());
        }
    }

    public static void resizeFonts(double factor) {
        if (Math.abs(currentFactor - factor) <= 0.1) {
            return;
        }
        currentFactor = factor;
        if (originalFontSize.isEmpty()) {
            FontSizeFacade.saveCurrentFontSizes();
        }
        originalFontSize.forEach((key, value) -> {
            Font f = UIManager.getDefaults().getFont(key);
            if (f != null) {
                UIManager.getDefaults().put(key, f.deriveFont((float)((double)value.intValue() * factor)));
            }
        });
        for (Window w : Window.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
        for (Window w : Dialog.getWindows()) {
            SwingUtilities.updateComponentTreeUI(w);
        }
    }
}

