/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.settings.SettingsUi;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;

public class SettingsDialog
extends JDialog {
    private static final long serialVersionUID = -3204453471778351602L;
    private final MainWindow mainWindow;
    private final SettingsUi ui;
    private Action actionCancel = new CancelAction();
    private Action actionAccept = new AcceptAction();
    private Action actionApply = new ApplyAction();
    private List<SettingsProvider> providers;

    public SettingsDialog(MainWindow owner) {
        super((Window)owner, Dialog.ModalityType.TOOLKIT_MODAL);
        this.setTitle("Settings");
        this.mainWindow = owner;
        this.ui = new SettingsUi(owner);
        JPanel root = new JPanel(new BorderLayout());
        root.add(this.ui);
        JPanel buttonBar = this.createButtonBar();
        root.add((Component)buttonBar, "South");
        this.setContentPane(root);
        this.getRootPane().registerKeyboardAction(e -> this.dispose(), KeyStroke.getKeyStroke(27, 0), 2);
        this.setSize(600, 400);
    }

    private JPanel createButtonBar() {
        JPanel p = new JPanel(new FlowLayout(2));
        JButton btnCancel = new JButton(this.actionCancel);
        JButton btnApply = new JButton(this.actionApply);
        JButton btnAccept = new JButton(this.actionAccept);
        p.add(btnAccept);
        p.add(btnApply);
        p.add(btnCancel);
        return p;
    }

    public void setSettingsProvider(List<SettingsProvider> providers) {
        this.providers = providers;
        this.ui.setSettingsProvider(providers);
    }

    SettingsUi getUi() {
        return this.ui;
    }

    private List<Exception> apply() {
        LinkedList<Exception> exc = new LinkedList<Exception>();
        this.apply(this.providers, exc);
        return exc;
    }

    private void apply(List<SettingsProvider> providers, List<Exception> exceptions) {
        for (SettingsProvider it : providers) {
            try {
                it.applySettings(this.mainWindow);
                this.apply(it.getChildren(), exceptions);
            }
            catch (Exception e) {
                e.printStackTrace();
                exceptions.add(e);
            }
        }
    }

    private boolean showErrors(List<Exception> apply) {
        if (!apply.isEmpty()) {
            String msg = apply.stream().map(Throwable::getMessage).collect(Collectors.joining("<br>", "<html>", "</html>"));
            JOptionPane.showMessageDialog(this, msg, "Error in Settings", 0);
            return false;
        }
        return true;
    }

    private class ApplyAction
    extends KeyAction {
        private static final long serialVersionUID = 3732950785908678379L;

        public ApplyAction() {
            this.setName("Apply");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.showErrors(SettingsDialog.this.apply());
        }
    }

    private class AcceptAction
    extends KeyAction {
        private static final long serialVersionUID = -4975054687458772222L;

        public AcceptAction() {
            this.setName("OK");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.setVisible(!SettingsDialog.this.showErrors(SettingsDialog.this.apply()));
        }
    }

    private class CancelAction
    extends KeyAction {
        private static final long serialVersionUID = -7590820300477946158L;

        public CancelAction() {
            this.setName("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.setVisible(false);
        }
    }
}

