/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.actions.KeyAction;
import de.uka.ilkd.key.gui.colors.ColorSettingsProvider;
import de.uka.ilkd.key.gui.extension.ExtensionManager;
import de.uka.ilkd.key.gui.extension.impl.KeYGuiExtensionFacade;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.keyshortcuts.ShortcutSettings;
import de.uka.ilkd.key.gui.settings.SettingsDialog;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.settings.StandardUISettings;
import de.uka.ilkd.key.gui.settings.TacletOptionsSettings;
import de.uka.ilkd.key.gui.smt.settings.SMTSettingsProvider;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.settings.ChoiceSettings;
import de.uka.ilkd.key.settings.NewSMTTranslationSettings;
import de.uka.ilkd.key.settings.ProofDependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ProofSettings;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.swing.Action;

public class SettingsManager {
    public static final ExtensionManager EXTENSION_MANAGER = new ExtensionManager();
    public static final SettingsProvider SMT_SETTINGS = new SMTSettingsProvider();
    public static final TacletOptionsSettings TACLET_OPTIONS_SETTINGS = new TacletOptionsSettings();
    public static final ShortcutSettings SHORTCUT_SETTINGS = new ShortcutSettings();
    public static final StandardUISettings STANDARD_UI_SETTINGS = new StandardUISettings();
    public static final ColorSettingsProvider COLOR_SETTINGS = new ColorSettingsProvider();
    private static SettingsManager INSTANCE;
    private List<SettingsProvider> settingsProviders = new LinkedList<SettingsProvider>();

    static SettingsManager createWithExtensions() {
        SettingsManager sm = new SettingsManager();
        KeYGuiExtensionFacade.getSettingsProvider().forEach(it -> sm.settingsProviders.add(it.getSettings()));
        return sm;
    }

    public static SettingsManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = SettingsManager.createWithExtensions();
            INSTANCE.add(STANDARD_UI_SETTINGS);
            INSTANCE.add(SMT_SETTINGS);
            INSTANCE.add(EXTENSION_MANAGER);
            INSTANCE.add(TACLET_OPTIONS_SETTINGS);
        }
        return INSTANCE;
    }

    public static ProofDependentSMTSettings getSmtPdSettings(MainWindow window) {
        Proof proof = window.getMediator().getSelectedProof();
        if (proof == null) {
            return ProofSettings.DEFAULT_SETTINGS.getSMTSettings();
        }
        return proof.getSettings().getSMTSettings();
    }

    public static NewSMTTranslationSettings getNewSmtSettings(MainWindow window) {
        Proof proof = window.getMediator().getSelectedProof();
        if (proof == null) {
            return ProofSettings.DEFAULT_SETTINGS.getNewSMTSettings();
        }
        return proof.getSettings().getNewSMTSettings();
    }

    public static ProofIndependentSMTSettings getSmtPiSettings() {
        return ProofIndependentSettings.DEFAULT_INSTANCE.getSMTSettings();
    }

    public static ChoiceSettings getChoiceSettings(MainWindow window) {
        return ProofSettings.DEFAULT_SETTINGS.getChoiceSettings();
    }

    public static Properties loadProperties(File settingsFile) {
        Properties props = new Properties();
        if (settingsFile.exists()) {
            try (FileReader reader = new FileReader(settingsFile);){
                props.load(reader);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return props;
    }

    public void showSettingsDialog(MainWindow mainWindow) {
        SettingsDialog dialog = this.createDialog(mainWindow);
        dialog.setVisible(true);
    }

    private SettingsDialog createDialog(MainWindow mainWindow) {
        this.settingsProviders.sort(Comparator.comparingInt(SettingsProvider::getPriorityOfSettings));
        this.initializeProviders(this.settingsProviders, mainWindow);
        SettingsDialog dialog = new SettingsDialog(mainWindow);
        dialog.setSettingsProvider(this.settingsProviders);
        dialog.setDefaultCloseOperation(2);
        dialog.setIconImage(IconFactory.keyLogo());
        dialog.setSize(800, 600);
        dialog.setLocationByPlatform(true);
        return dialog;
    }

    private void initializeProviders(List<SettingsProvider> providers, MainWindow mainWindow) {
        providers.forEach(it -> it.getPanel(mainWindow));
        providers.forEach(it -> this.initializeProviders(it.getChildren(), mainWindow));
    }

    public void showSettingsDialog(MainWindow mainWindow, SettingsProvider selectedPanel) {
        SettingsDialog dialog = this.createDialog(mainWindow);
        dialog.getUi().selectPanel(selectedPanel);
        dialog.setVisible(true);
    }

    public boolean add(SettingsProvider settingsProvider) {
        return this.settingsProviders.add(settingsProvider);
    }

    public boolean remove(SettingsProvider o) {
        return this.settingsProviders.remove(o);
    }

    public Action getActionShowSettings(final MainWindow window) {
        class ShowSettingsAction
        extends KeyAction {
            private static final long serialVersionUID = 153753479823919818L;

            public ShowSettingsAction() {
                this.setName("Show Settings");
                this.setIcon(IconFactory.editFile(16));
                this.lookupAcceleratorKey();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SettingsManager.this.showSettingsDialog(window);
            }
        }
        return new ShowSettingsAction();
    }
}

