/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.KeYFileChooser;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontSwing;
import de.uka.ilkd.key.gui.settings.SimpleSettingsPanel;
import de.uka.ilkd.key.gui.settings.Validator;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;

public abstract class SettingsPanel
extends SimpleSettingsPanel {
    private static final long serialVersionUID = 3465371513326517504L;

    protected SettingsPanel() {
        this.pCenter.setLayout((LayoutManager)new MigLayout(new LC().fillX().wrapAfter(3), new AC().count(3).fill(new int[]{1}).grow(1000.0f, new int[]{1}).size("16px", new int[]{2}).grow(0.0f, new int[]{0}).align("right", new int[]{0})));
    }

    protected static JTextArea createInfoArea(String info) {
        JTextArea textArea = new JTextArea(info);
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setWrapStyleWord(true);
        return textArea;
    }

    protected void addRowWithHelp(String info, JComponent ... components) {
        boolean hasInfo = info != null && !info.isEmpty();
        for (JComponent component : components) {
            component.setAlignmentX(0.0f);
            this.pCenter.add(component);
        }
        JLabel infoButton = hasInfo ? SettingsPanel.createHelpLabel(info) : new JLabel();
        this.pCenter.add(infoButton);
    }

    protected <T> JComboBox<T> createSelection(T[] elements, Validator<T> validator) {
        JComboBox comboBox = new JComboBox(elements);
        comboBox.addActionListener(e -> {
            try {
                if (validator != null) {
                    validator.validate(comboBox.getSelectedItem());
                }
                this.demarkComponentAsErrornous(comboBox);
            }
            catch (Exception ex) {
                this.markComponentAsErrornous(comboBox, ex.getMessage());
            }
        });
        return comboBox;
    }

    protected JCheckBox addCheckBox(String title, String info, boolean value, Validator<Boolean> validator) {
        JCheckBox checkBox = this.createCheckBox(title, value, validator);
        this.addRowWithHelp(info, new JLabel(), checkBox);
        return checkBox;
    }

    protected JTextField addFileChooserPanel(String title, String file, String info, boolean isSave, Validator<String> validator) {
        JTextField textField = new JTextField(file);
        textField.addActionListener(e -> {
            try {
                if (validator != null) {
                    validator.validate(textField.getText());
                }
                this.demarkComponentAsErrornous(textField);
            }
            catch (Exception ex) {
                this.markComponentAsErrornous(textField, ex.getMessage());
            }
        });
        JLabel lbl = new JLabel(title);
        lbl.setLabelFor(textField);
        this.pCenter.add(lbl);
        Box box = new Box(0);
        JButton btnFileChooser = new JButton(IconFontSwing.buildIcon(FontAwesomeSolid.SEARCH, 12.0f));
        btnFileChooser.addActionListener(e -> {
            int result;
            KeYFileChooser fileChooser;
            if (isSave) {
                fileChooser = KeYFileChooser.getFileChooser("Save file");
                fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                result = fileChooser.showSaveDialog((Component)e.getSource(), new File(textField.getText()));
            } else {
                fileChooser = KeYFileChooser.getFileChooser("Open file");
                fileChooser.setFileFilter(fileChooser.getAcceptAllFileFilter());
                result = fileChooser.showOpenDialog((Component)e.getSource());
            }
            if (result == 0) {
                textField.setText(fileChooser.getSelectedFile().getAbsolutePath());
            }
        });
        this.pCenter.add(box);
        box.add(textField);
        box.add(btnFileChooser);
        this.pCenter.add((Component)SettingsPanel.createHelpLabel(info), new CC().wrap());
        return textField;
    }

    protected <T> JComboBox<T> addComboBox(String title, String info, int selectionIndex, @Nullable Validator<T> validator, T ... items) {
        JComboBox comboBox = new JComboBox(items);
        comboBox.setSelectedIndex(selectionIndex);
        comboBox.addActionListener(e -> {
            try {
                if (validator != null) {
                    validator.validate(comboBox.getSelectedItem());
                }
                this.demarkComponentAsErrornous(comboBox);
            }
            catch (Exception ex) {
                this.markComponentAsErrornous(comboBox, ex.getMessage());
            }
        });
        if (info != null && !info.isEmpty()) {
            this.pCenter.add(new JLabel(title));
            this.pCenter.add(comboBox);
            JLabel infoButton = SettingsPanel.createHelpLabel(info);
            this.pCenter.add((Component)infoButton, new CC().wrap());
        } else {
            this.add(comboBox, new CC().span(new int[]{2}).wrap());
        }
        return comboBox;
    }

    protected void addTitledComponent(String title, JComponent component, String helpText) {
        JLabel label = new JLabel(title);
        label.setLabelFor(component);
        this.addRowWithHelp(helpText, label, component);
    }

    protected JTextArea addTextArea(String title, String text, String info, Validator<String> validator) {
        JScrollPane field = this.createTextArea(text, validator);
        this.addTitledComponent(title, field, info);
        return (JTextArea)field.getViewport().getView();
    }

    protected JTextField addTextField(String title, String text, String info, Validator<String> validator) {
        JTextField field = this.createTextField(text, validator);
        this.addTitledComponent(title, field, info);
        return field;
    }

    protected JTextField addTextField(String title, String text, String info, Validator<String> validator, JComponent additionalActions) {
        JTextField field = this.createTextField(text, validator);
        JLabel label = new JLabel(title);
        label.setLabelFor(field);
        this.addRowWithHelp(info, label, field, additionalActions);
        return field;
    }

    protected <T extends Number> JSpinner addNumberField(String title, T min, Comparable<T> max, Number step, String info, Validator<Number> validator) {
        JSpinner field = this.createNumberTextField(min, max, step, validator);
        this.addTitledComponent(title, field, info);
        return field;
    }

    protected void addRadioButtons(String heading, Object[] alternatives, String description) {
        this.addRadioButtons(heading, Arrays.asList(alternatives), description);
    }

    protected void addRadioButtons(String title, List<?> alternatives, String description) {
        JPanel items = new JPanel(new GridLayout(alternatives.size(), 1));
        ButtonGroup bg = new ButtonGroup();
        for (Object alt : alternatives) {
            JRadioButton radioButton = new JRadioButton(alt.toString());
            radioButton.putClientProperty("object", alt);
            bg.add(radioButton);
            items.add(radioButton);
        }
        this.addTitledComponent(title, items, description);
    }

    protected void addSeparator(String titleText) {
        JPanel pane = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridwidth = 0;
        gbc.weightx = 1.0;
        gbc.fill = 2;
        JSeparator sep = new JSeparator(0);
        pane.add((Component)sep, gbc);
        Box box = new Box(0);
        box.add(new JLabel(titleText));
        box.add(pane);
        this.pCenter.add((Component)box, new CC().span(new int[0]).grow().alignX("left"));
    }

    protected <T> Validator<T> emptyValidator() {
        return s -> {};
    }
}

