/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.settings.SettingsTreeNode;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SettingsUi
extends JPanel {
    private static final long serialVersionUID = -217841876110516940L;
    private static final Icon ICON_TREE_NODE_RETRACTED = IconFactory.TREE_NODE_EXPANDED.get();
    private static final Icon ICON_TREE_NODE_EXPANDED = IconFactory.TREE_NODE_RETRACTED.get();
    private final JSplitPane root;
    private DefaultTreeModel treeModel = new DefaultTreeModel(null, false);
    private JTree treeSettingsPanels = new JTree(this.treeModel);
    private JTextField txtSearch = new JTextField();
    private MainWindow mainWindow;

    public SettingsUi(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.treeSettingsPanels.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.treeSettingsPanels.setCellRenderer(new DefaultTreeCellRenderer(){
            private static final long serialVersionUID = 1770380144400699946L;

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                JLabel lbl;
                SettingsTreeNode node = (SettingsTreeNode)value;
                SettingsProvider panel = node.provider;
                if (panel == null) {
                    lbl = (JLabel)super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                } else {
                    lbl = (JLabel)super.getTreeCellRendererComponent(tree, panel.getDescription(), sel, expanded, leaf, row, hasFocus);
                    lbl.setFont(lbl.getFont().deriveFont(16.0f));
                    if (!node.isLeaf()) {
                        lbl.setIcon(expanded ? ICON_TREE_NODE_EXPANDED : ICON_TREE_NODE_RETRACTED);
                    } else {
                        lbl.setIcon(panel.getIcon());
                    }
                    lbl.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
                    if (!SettingsUi.this.txtSearch.getText().isEmpty() && panel.contains(SettingsUi.this.txtSearch.getText())) {
                        lbl.setBackground(Color.black);
                        lbl.setBorder(BorderFactory.createLineBorder(Color.BLUE, 2, true));
                    } else {
                        lbl.setBackground(Color.white);
                        lbl.setBorder(null);
                    }
                }
                return lbl;
            }
        });
        this.txtSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                SettingsUi.this.treeSettingsPanels.invalidate();
                SettingsUi.this.treeSettingsPanels.repaint();
            }
        });
        this.root = new JSplitPane();
        this.treeSettingsPanels.addTreeSelectionListener(e -> {
            SettingsTreeNode n = (SettingsTreeNode)e.getPath().getLastPathComponent();
            if (n.provider != null && n.provider.getPanel(mainWindow) != null) {
                JComponent comp = n.provider.getPanel(mainWindow);
                this.setSettingsPanel(comp);
            }
        });
        this.treeSettingsPanels.setRootVisible(false);
        this.setLayout(new BorderLayout(5, 5));
        this.root.setLeftComponent(this.createWestPanel());
        this.root.setRightComponent(new JLabel("empty"));
        this.add((Component)this.root, "Center");
        this.root.setDividerLocation(0.3);
    }

    private void setSettingsPanel(JComponent comp) {
        this.root.setRightComponent(comp);
        this.root.setDividerLocation(this.root.getLeftComponent().getPreferredSize().width);
    }

    private JPanel createWestPanel() {
        JPanel p = new JPanel(new BorderLayout(5, 5));
        Box boxNorth = new Box(0);
        JLabel lblSearch = new JLabel("Search: ");
        boxNorth.add(lblSearch);
        boxNorth.add(this.txtSearch);
        lblSearch.setLabelFor(this.txtSearch);
        p.add((Component)boxNorth, "North");
        p.add(new JScrollPane(this.treeSettingsPanels));
        p.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return p;
    }

    public void setSettingsProvider(List<SettingsProvider> providers) {
        SettingsTreeNode root = new SettingsTreeNode(providers);
        this.treeModel = new DefaultTreeModel(root);
        this.treeSettingsPanels.setModel(this.treeModel);
        LinkedList<TreePath> list = new LinkedList<TreePath>();
        this.getPaths(new TreePath(this.treeModel.getPathToRoot(root)), list);
        list.forEach(it -> this.treeSettingsPanels.expandPath((TreePath)it));
        if (!providers.isEmpty()) {
            this.setSettingsPanel(providers.get(0).getPanel(this.mainWindow));
        }
    }

    public void getPaths(TreePath parent, List<TreePath> list) {
        list.add(parent);
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.getPaths(path, list);
            }
        }
    }

    public void selectPanel(SettingsProvider provider) {
        SettingsTreeNode node = this.findNode(provider);
        TreePath path = new TreePath(this.treeModel.getPathToRoot(node));
        this.treeSettingsPanels.setSelectionPath(path);
    }

    SettingsTreeNode findNode(SettingsProvider provider) {
        LinkedList<SettingsTreeNode> nodes = new LinkedList<SettingsTreeNode>();
        nodes.offer((SettingsTreeNode)this.treeModel.getRoot());
        while (!nodes.isEmpty()) {
            SettingsTreeNode cur = (SettingsTreeNode)nodes.poll();
            if (cur.provider == provider) {
                return cur;
            }
            nodes.addAll(cur.children);
        }
        return null;
    }
}

