/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.fonticons.FontAwesomeSolid;
import de.uka.ilkd.key.gui.fonticons.IconFontSwing;
import de.uka.ilkd.key.gui.settings.Validator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.text.Format;
import javax.annotation.Nullable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.key_project.util.java.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSettingsPanel
extends JPanel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleSettingsPanel.class);
    private static final ColorSettings.ColorProperty COLOR_ERROR = ColorSettings.define("SETTINGS_TEXTFIELD_ERROR", "Color for marking errornous textfields in settings dialog", new Color(200, 100, 100));
    protected Box pNorth = new Box(1);
    protected JPanel pCenter = new JPanel();
    protected JLabel lblHead = new JLabel();
    protected JLabel lblSubhead = new JLabel();

    protected SimpleSettingsPanel() {
        this.setLayout(new BorderLayout());
        this.pNorth.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pNorth.setBackground(Color.WHITE);
        this.pNorth.setOpaque(true);
        this.lblHead.setFont(this.lblHead.getFont().deriveFont(16.0f).deriveFont(1));
        this.pNorth.add(this.lblHead);
        this.pNorth.add(this.lblSubhead);
        this.pNorth.add(new JSeparator());
        this.add((Component)this.pNorth, "North");
        JScrollPane scrollPane = new JScrollPane(this.pCenter);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        scrollPane.getVerticalScrollBar().setUnitIncrement(10);
        this.add((Component)scrollPane, "Center");
    }

    public void setHeaderText(String text) {
        this.lblHead.setText(text);
    }

    public void setSubHeaderText(String text) {
        this.lblSubhead.setText(text);
    }

    protected void demarkComponentAsErrornous(JComponent component) {
        Object col = component.getClientProperty("saved_background_color");
        if (col instanceof Color) {
            component.setBackground((Color)col);
        }
    }

    protected void markComponentAsErrornous(JComponent component, String error) {
        component.putClientProperty("saved_background_color", component.getBackground());
        component.setBackground(COLOR_ERROR.get());
        component.setToolTipText(error);
    }

    protected JCheckBox createCheckBox(String title, boolean value, @Nullable Validator<Boolean> validator) {
        JCheckBox checkBox = new JCheckBox(title, value);
        checkBox.addActionListener(e -> {
            try {
                if (validator != null) {
                    validator.validate(checkBox.isSelected());
                }
                this.demarkComponentAsErrornous(checkBox);
            }
            catch (Exception ex) {
                this.markComponentAsErrornous(checkBox, ex.getMessage());
            }
        });
        return checkBox;
    }

    protected JScrollPane createTextArea(String text, Validator<String> validator) {
        JTextArea area = new JTextArea(text);
        area.setRows(5);
        area.getDocument().addDocumentListener(new DocumentValidatorAdapter(area, validator));
        return new JScrollPane(area);
    }

    protected JTextField createTextField(String text, @Nullable Validator<String> validator) {
        JTextField field = new JTextField(text);
        field.getDocument().addDocumentListener(new DocumentValidatorAdapter(field, validator));
        return field;
    }

    protected JFormattedTextField createNumberFormattedTextField(Format format, @Nullable Validator<String> validator) {
        JFormattedTextField field = new JFormattedTextField(format);
        field.getDocument().addDocumentListener(new DocumentValidatorAdapter(field, validator));
        return field;
    }

    protected <T extends Number> JSpinner createNumberTextField(T min, Comparable<T> max, Number step, @Nullable Validator<Number> validator) {
        SpinnerNumberModel spinnerModel = new SpinnerNumberModel(min, (Comparable)((Object)min), max, step);
        return this.createNumberTextField(spinnerModel, validator);
    }

    protected JSpinner createNumberTextField(SpinnerModel model, @Nullable Validator<Number> validator) {
        JSpinner spinner = new JSpinner(model){

            @Override
            public void setBackground(Color bg) {
                JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
                editor.getTextField().setBackground(bg);
            }

            @Override
            public Color getBackground() {
                JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.getEditor();
                return editor.getTextField().getBackground();
            }
        };
        spinner.setBackground(Color.WHITE);
        spinner.addChangeListener(new ValidatorSpinnerAdapter<Number>(spinner, validator));
        return spinner;
    }

    public static JLabel createHelpLabel(String s) {
        if (s == null || ((String)s).isEmpty()) {
            s = "";
        } else {
            String brokenLines = StringUtil.wrapLines((String)s);
            s = "<html>" + brokenLines.replace("<", "&lt;").replace(">", "&gt;").replace("\n", "<br>");
        }
        JLabel infoButton = new JLabel(IconFontSwing.buildIcon(FontAwesomeSolid.QUESTION_CIRCLE, 16.0f));
        infoButton.setToolTipText((String)s);
        return infoButton;
    }

    private class DocumentValidatorAdapter
    implements DocumentListener {
        private final JTextComponent field;
        @Nullable
        private final Validator<String> validator;

        private DocumentValidatorAdapter(@Nullable JTextComponent field, Validator<String> validator) {
            this.field = field;
            this.validator = validator;
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.update();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.update();
        }

        void update() {
            try {
                if (this.validator != null) {
                    this.validator.validate(this.field.getText());
                }
                SimpleSettingsPanel.this.demarkComponentAsErrornous(this.field);
            }
            catch (Exception ex) {
                SimpleSettingsPanel.this.markComponentAsErrornous(this.field, ex.getMessage());
            }
        }
    }

    private class ValidatorSpinnerAdapter<T>
    implements ChangeListener {
        private final Validator<T> validator;
        private final JSpinner model;

        public ValidatorSpinnerAdapter(JSpinner model, Validator<T> validator) {
            this.model = model;
            this.validator = validator;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Object current = this.model.getValue();
            try {
                if (this.validator != null) {
                    this.validator.validate(current);
                }
                SimpleSettingsPanel.this.demarkComponentAsErrornous(this.model);
            }
            catch (Exception ex) {
                LOGGER.error(ex.getMessage());
                SimpleSettingsPanel.this.markComponentAsErrornous(this.model, ex.getMessage());
            }
        }
    }
}

