/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.configuration.Config;
import de.uka.ilkd.key.gui.settings.FontSizeFacade;
import de.uka.ilkd.key.gui.settings.InvalidSettingsInputException;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.settings.GeneralSettings;
import de.uka.ilkd.key.settings.ProofIndependentSettings;
import de.uka.ilkd.key.settings.ViewSettings;
import java.util.Arrays;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.SpinnerNumberModel;

public class StandardUISettings
extends SettingsPanel
implements SettingsProvider {
    private static final long serialVersionUID = -7484169054465984605L;
    private static final String INFO_CLUTTER_RULESET = "Comma separated list of rule set names, containing clutter rules.";
    private static final String INFO_CLUTTER_RULE = "Comma separated listof clutter rules, \nwhich are rules with less priority in the taclet menu";
    private final JSpinner spFontSizeGlobal;
    private final JSpinner txtMaxTooltipLines;
    private final JCheckBox chkShowLoadExamplesDialog;
    private final JCheckBox chkShowWholeTacletCB;
    private final JCheckBox chkShowUninstantiatedTaclet;
    private final JCheckBox chkRightClickMacros;
    private final JCheckBox chkPrettyPrint;
    private final JCheckBox chkUseUnicode;
    private final JCheckBox chkSyntaxHighlightning;
    private final JCheckBox chkHidePackagePrefix;
    private final JCheckBox chkConfirmExit;
    private final JSpinner spAutoSaveProof;
    private final JCheckBox chkMinimizeInteraction;
    private final JComboBox<String> spFontSizeTreeSequent;
    private final JCheckBox chkEnsureSourceConsistency;
    private final JTextArea txtClutterRules;
    private final JTextArea txtClutterRuleSets;

    public StandardUISettings() {
        this.setHeaderText(this.getDescription());
        this.spFontSizeGlobal = this.createNumberTextField(new SpinnerNumberModel(1.0, 0.1, 5.0, 0.1), this.emptyValidator());
        this.addTitledComponent("Global font factor: ", this.spFontSizeGlobal, "");
        String[] sizes = (String[])Arrays.stream(Config.SIZES).boxed().map(it -> it + " pt").toArray(String[]::new);
        this.spFontSizeTreeSequent = this.createSelection(sizes, this.emptyValidator());
        this.addTitledComponent("Tree and sequent font factor: ", this.spFontSizeTreeSequent, "");
        String info = "Maximum size (line count) of the tooltips of applicable rules\n<br> with schema variable instantiations displayed.\nIn case of longer <br>tooltips the instantiation will be suppressed.\n";
        this.txtMaxTooltipLines = this.addNumberField("Maximum line number for tooltips", 1, Integer.valueOf(100), 5, info, this.emptyValidator());
        this.chkShowLoadExamplesDialog = this.addCheckBox("Show load examples dialog", "Show the load example dialog on startup", true, this.emptyValidator());
        this.chkShowWholeTacletCB = this.addCheckBox("Show whole taclet", "Pretty-print whole Taclet including \n'name', 'find', 'varCond' and 'heuristics'", false, this.emptyValidator());
        this.chkShowUninstantiatedTaclet = this.addCheckBox("Show uninstantiated taclet", "recommended for unexperienced users", false, this.emptyValidator());
        this.txtClutterRules = this.addTextArea("Clutter rules", "", INFO_CLUTTER_RULE, this.emptyValidator());
        this.txtClutterRuleSets = this.addTextArea("Clutter Rulesets", "", INFO_CLUTTER_RULESET, this.emptyValidator());
        this.chkPrettyPrint = this.addCheckBox("Pretty print terms", "", false, this.emptyValidator());
        this.chkUseUnicode = this.addCheckBox("Use unicode", "", false, this.emptyValidator());
        this.chkSyntaxHighlightning = this.addCheckBox("Use syntax highlighting", "", false, this.emptyValidator());
        this.chkHidePackagePrefix = this.addCheckBox("Hide package prefix", "", false, this.emptyValidator());
        this.chkConfirmExit = this.addCheckBox("Confirm program exit", "", false, this.emptyValidator());
        this.spAutoSaveProof = this.addNumberField("Auto save proof", 0, Integer.valueOf(10000000), 1000, "", this.emptyValidator());
        this.chkMinimizeInteraction = this.addCheckBox("Minimise interactions", "", false, this.emptyValidator());
        this.chkEnsureSourceConsistency = this.addCheckBox("Ensure source consistency", "", true, this.emptyValidator());
        this.chkRightClickMacros = this.addCheckBox("Right click for proof macros", "", false, this.emptyValidator());
    }

    @Override
    public String getDescription() {
        return "Appearance & Behaviour";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        GeneralSettings generalSettings = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings();
        this.txtClutterRules.setText(vs.clutterRules().value().replace(',', '\n'));
        this.txtClutterRuleSets.setText(vs.clutterRuleSets().value().replace(',', '\n'));
        this.spFontSizeGlobal.setValue(vs.getUIFontSizeFactor());
        this.txtMaxTooltipLines.setValue(vs.getMaxTooltipLines());
        this.chkShowLoadExamplesDialog.setSelected(vs.getShowLoadExamplesDialog());
        this.chkShowWholeTacletCB.setSelected(vs.getShowWholeTaclet());
        this.chkShowUninstantiatedTaclet.setSelected(vs.getShowUninstantiatedTaclet());
        this.chkHidePackagePrefix.setSelected(vs.isHidePackagePrefix());
        this.chkPrettyPrint.setSelected(vs.isUsePretty());
        this.chkUseUnicode.setSelected(vs.isUseUnicode());
        this.chkSyntaxHighlightning.setSelected(vs.isUseSyntaxHighlighting());
        this.chkEnsureSourceConsistency.setSelected(generalSettings.isEnsureSourceConsistency());
        this.chkRightClickMacros.setSelected(generalSettings.isRightClickMacro());
        this.chkConfirmExit.setSelected(vs.confirmExit());
        this.spAutoSaveProof.setValue(generalSettings.autoSavePeriod());
        this.chkMinimizeInteraction.setSelected(generalSettings.tacletFilter());
        this.spFontSizeTreeSequent.setSelectedIndex(vs.sizeIndex());
        return this;
    }

    @Override
    public List<SettingsProvider> getChildren() {
        return Arrays.asList(SettingsManager.COLOR_SETTINGS, SettingsManager.SHORTCUT_SETTINGS);
    }

    @Override
    public void applySettings(MainWindow window) throws InvalidSettingsInputException {
        ViewSettings vs = ProofIndependentSettings.DEFAULT_INSTANCE.getViewSettings();
        GeneralSettings gs = ProofIndependentSettings.DEFAULT_INSTANCE.getGeneralSettings();
        vs.setUIFontSizeFactor(((Double)this.spFontSizeGlobal.getValue()).doubleValue());
        vs.setMaxTooltipLines(((Integer)this.txtMaxTooltipLines.getValue()).intValue());
        vs.clutterRules().set(this.txtClutterRules.getText().replace('\n', ','));
        vs.clutterRuleSets().set(this.txtClutterRuleSets.getText().replace('\n', ','));
        vs.setShowLoadExamplesDialog(this.chkShowLoadExamplesDialog.isSelected());
        vs.setShowWholeTaclet(this.chkShowWholeTacletCB.isSelected());
        vs.setShowUninstantiatedTaclet(this.chkShowUninstantiatedTaclet.isSelected());
        vs.setHidePackagePrefix(this.chkHidePackagePrefix.isSelected());
        vs.setUsePretty(this.chkPrettyPrint.isSelected());
        vs.setUseUnicode(this.chkUseUnicode.isSelected());
        vs.setUseSyntaxHighlighting(this.chkSyntaxHighlightning.isSelected());
        gs.setEnsureSourceConsistency(this.chkEnsureSourceConsistency.isSelected());
        gs.setRightClickMacros(this.chkRightClickMacros.isSelected());
        vs.setConfirmExit(this.chkConfirmExit.isSelected());
        gs.setAutoSave(((Integer)this.spAutoSaveProof.getValue()).intValue());
        gs.setTacletFilter(this.chkMinimizeInteraction.isSelected());
        vs.setFontIndex(Integer.valueOf(this.spFontSizeTreeSequent.getSelectedIndex()).intValue());
        FontSizeFacade.resizeFonts(vs.getUIFontSizeFactor());
    }

    @Override
    public int getPriorityOfSettings() {
        return Integer.MIN_VALUE;
    }
}

