/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.settings;

import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.fonticons.IconFactory;
import de.uka.ilkd.key.gui.settings.SettingsManager;
import de.uka.ilkd.key.gui.settings.SettingsPanel;
import de.uka.ilkd.key.gui.settings.SettingsProvider;
import de.uka.ilkd.key.gui.settings.SimpleSettingsPanel;
import de.uka.ilkd.key.settings.ChoiceSettings;
import de.uka.ilkd.key.settings.ProofSettings;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.InvalidPropertiesFormatException;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.key_project.util.java.ObjectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TacletOptionsSettings
extends SimpleSettingsPanel
implements SettingsProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TacletOptionsSettings.class);
    private static final long serialVersionUID = 1455572432081960150L;
    private static final String EXPLANATIONS_RESOURCE = "/de/uka/ilkd/key/gui/help/choiceExplanations.xml";
    private static Properties explanationMap;
    private HashMap<String, String> category2Choice;
    private HashMap<String, Set<String>> category2Choices;
    private ChoiceSettings settings;
    private boolean warnNoProof = true;

    public TacletOptionsSettings() {
        this.setHeaderText(this.getDescription());
        this.pCenter.setLayout((LayoutManager)new MigLayout(new LC().fillX(), new AC().fill().grow().gap("3mm")));
        this.layoutHead();
        this.setFocusable(true);
        this.setChoiceSettings(ProofSettings.DEFAULT_SETTINGS.getChoiceSettings());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getExplanation(String category) {
        Class<TacletOptionsSettings> clazz = TacletOptionsSettings.class;
        synchronized (TacletOptionsSettings.class) {
            if (explanationMap == null) {
                explanationMap = new Properties();
                InputStream is = TacletOptionsSettings.class.getResourceAsStream(EXPLANATIONS_RESOURCE);
                try {
                    if (is == null) {
                        throw new FileNotFoundException("/de/uka/ilkd/key/gui/help/choiceExplanations.xml not found");
                    }
                    explanationMap.loadFromXML(is);
                }
                catch (InvalidPropertiesFormatException e) {
                    LOGGER.error("Cannot load help message in rule view (malformed XML).", (Throwable)e);
                }
                catch (IOException e) {
                    LOGGER.error("Cannot load help messages in rule view.", (Throwable)e);
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Object result = explanationMap.getProperty(category);
            if (result == null) {
                result = "No explanation for " + category + " available.";
            }
            return result;
        }
    }

    public static boolean isUnsound(String choice) {
        return "runtimeExceptions:ignore".equals(choice) || "initialisation:disableStaticInitialisation".equals(choice) || "intRules:arithmeticSemanticsIgnoringOF".equals(choice);
    }

    public static boolean isIncomplete(String choice) {
        return "runtimeExceptions:ban".equals(choice) || "Strings:off".equals(choice) || "intRules:arithmeticSemanticsCheckingOF".equals(choice) || "integerSimplificationRules:minimal".equals(choice) || "programRules:None".equals(choice);
    }

    public static String getInformation(String choice) {
        if ("JavaCard:on".equals(choice)) {
            return "Sound if a JavaCard program is proven.";
        }
        if ("JavaCard:off".equals(choice)) {
            return "Sound if a Java program is proven.";
        }
        if ("assertions:on".equals(choice)) {
            return "Sound if JVM is started with enabled assertions for the whole system.";
        }
        if ("assertions:off".equals(choice)) {
            return "Sound if JVM is started with disabled assertions for the whole system.";
        }
        return null;
    }

    public static ChoiceEntry findChoice(List<ChoiceEntry> choices, String choice) {
        return choices.stream().filter(it -> it.getChoice().equals(choice)).findAny().orElse(null);
    }

    public static List<ChoiceEntry> createChoiceEntries(Collection<String> choices) {
        if (choices == null) {
            return Collections.emptyList();
        }
        return choices.stream().map(TacletOptionsSettings::createChoiceEntry).collect(Collectors.toList());
    }

    public static ChoiceEntry createChoiceEntry(String choice) {
        return new ChoiceEntry(choice, TacletOptionsSettings.isUnsound(choice), TacletOptionsSettings.isIncomplete(choice), TacletOptionsSettings.getInformation(choice));
    }

    protected void layoutHead() {
        JLabel lblHead2;
        if (this.warnNoProof) {
            lblHead2 = new JLabel("No Proof loaded. Taclet options may not be parsed.");
            lblHead2.setIcon(IconFactory.WARNING_INCOMPLETE.get());
            lblHead2.setFont(lblHead2.getFont().deriveFont(14.0f));
            this.pNorth.add(lblHead2);
        }
        lblHead2 = new JLabel("Taclet options will take effect only on new proofs.");
        lblHead2.setIcon(IconFactory.WARNING_INCOMPLETE.get());
        lblHead2.setFont(lblHead2.getFont().deriveFont(14.0f));
        this.pNorth.add(lblHead2);
    }

    protected void layoutChoiceSelector() {
        this.pCenter.removeAll();
        this.category2Choice.keySet().stream().sorted().forEach(this::addCategory);
    }

    protected void addCategory(String cat) {
        List<ChoiceEntry> choices = TacletOptionsSettings.createChoiceEntries((Collection<String>)this.category2Choices.get(cat));
        ChoiceEntry selectedChoice = TacletOptionsSettings.findChoice(choices, this.category2Choice.get(cat));
        String explanation = TacletOptionsSettings.getExplanation(cat);
        this.addTitleRow(cat);
        ButtonGroup btnGroup = new ButtonGroup();
        for (ChoiceEntry c : choices) {
            JRadioButton btn = this.addRadioButton(c, btnGroup);
            if (c.equals(selectedChoice)) {
                btn.setSelected(true);
            }
            btn.addActionListener(new ChoiceSettingsSetter(cat, c.choice));
        }
        this.addExplanation(explanation);
    }

    protected void addExplanation(String explanation) {
        JTextArea explanationArea = new JTextArea();
        explanationArea.setEditable(false);
        explanationArea.setLineWrap(true);
        explanationArea.setWrapStyleWord(true);
        explanationArea.setText(explanation);
        explanationArea.setCaretPosition(0);
        explanationArea.setBackground(this.getBackground());
        JPanel p = this.createCollapsibleTitlePane("Info", explanationArea);
        this.pCenter.add((Component)p, new CC().span(new int[0]).newline());
    }

    @Nonnull
    private JPanel createCollapsibleTitlePane(String titleText, final JComponent child) {
        JPanel p = new JPanel(new BorderLayout());
        JPanel north = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createLineBorder(Color.black));
        final JButton title = new JButton(titleText);
        title.setContentAreaFilled(false);
        title.setBorderPainted(false);
        north.add((Component)title, "West");
        p.add((Component)north, "North");
        p.add(child);
        child.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        child.setVisible(false);
        title.setIcon(IconFactory.TREE_NODE_RETRACTED.get());
        title.addMouseListener(new MouseAdapter(){
            private boolean opened = false;

            @Override
            public void mouseClicked(MouseEvent e) {
                this.opened = !this.opened;
                child.setVisible(this.opened);
                if (this.opened) {
                    title.setIcon(IconFactory.TREE_NODE_EXPANDED.get());
                } else {
                    title.setIcon(IconFactory.TREE_NODE_RETRACTED.get());
                }
            }
        });
        return p;
    }

    private JRadioButton addRadioButton(ChoiceEntry c, ButtonGroup btnGroup) {
        JLabel lbl;
        Box b = new Box(0);
        JRadioButton button = new JRadioButton(c.choice);
        btnGroup.add(button);
        b.add(button);
        if (c.incomplete) {
            lbl = new JLabel(IconFactory.WARNING_INCOMPLETE.get());
            lbl.setToolTipText("Incomplete");
            b.add(lbl);
        }
        if (c.unsound) {
            lbl = new JLabel(IconFactory.WARNING_UNSOUND.get());
            lbl.setToolTipText("Unsound " + button.getToolTipText());
            b.add(lbl);
        }
        if (c.information != null) {
            lbl = SettingsPanel.createHelpLabel(c.information);
            b.add(lbl);
        }
        this.pCenter.add((Component)b, new CC().newline());
        return button;
    }

    private void addTitleRow(String cat) {
        JLabel lbl = new JLabel(cat);
        lbl.setFont(lbl.getFont().deriveFont(14.0f));
        this.pCenter.add((Component)lbl, new CC().span(new int[0]).newline());
    }

    @Override
    public String getDescription() {
        return "Taclet Options";
    }

    @Override
    public JComponent getPanel(MainWindow window) {
        this.warnNoProof = window.getMediator().getSelectedProof() == null;
        this.setChoiceSettings(SettingsManager.getChoiceSettings(window));
        return this;
    }

    private void setChoiceSettings(ChoiceSettings choiceSettings) {
        this.settings = choiceSettings;
        this.category2Choice = this.settings.getDefaultChoices();
        this.category2Choices = this.settings.getChoices();
        this.layoutChoiceSelector();
    }

    @Override
    public void applySettings(MainWindow window) {
        this.settings.setDefaultChoices(this.category2Choice);
    }

    private class ChoiceSettingsSetter
    implements ActionListener {
        private final String category;
        private final String options;

        public ChoiceSettingsSetter(String cat, String choice) {
            this.category = cat;
            this.options = choice;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TacletOptionsSettings.this.category2Choice.put(this.category, this.options);
        }
    }

    public static class ChoiceEntry {
        public static final String INCOMPLETE_TEXT = "incomplete";
        public static final String UNSOUND_TEXT = "Java modeling unsound";
        private final String choice;
        private final boolean unsound;
        private final boolean incomplete;
        private final String information;

        public ChoiceEntry(String choice, boolean unsound, boolean incomplete, String information) {
            assert (choice != null);
            this.choice = choice;
            this.unsound = unsound;
            this.incomplete = incomplete;
            this.information = information;
        }

        public String getChoice() {
            return this.choice;
        }

        public boolean isUnsound() {
            return this.unsound;
        }

        public boolean isIncomplete() {
            return this.incomplete;
        }

        public String getInformation() {
            return this.information;
        }

        public int hashCode() {
            int hashcode = 5;
            hashcode = hashcode * 17 + this.choice.hashCode();
            hashcode = hashcode * 17 + (this.incomplete ? 5 : 3);
            hashcode = hashcode * 17 + (this.unsound ? 5 : 3);
            if (this.information != null) {
                hashcode = hashcode * 17 + this.information.hashCode();
            }
            return hashcode;
        }

        public boolean equals(Object obj) {
            if (obj instanceof ChoiceEntry) {
                ChoiceEntry other = (ChoiceEntry)obj;
                return this.choice.equals(other.getChoice()) && this.incomplete == other.isIncomplete() && this.unsound == other.isUnsound() && ObjectUtil.equals((Object)this.information, (Object)other.getInformation());
            }
            return false;
        }

        public String toString() {
            if (this.unsound && this.incomplete) {
                if (this.information != null) {
                    return String.format("%s (%s and %s, %s)", this.choice, UNSOUND_TEXT, INCOMPLETE_TEXT, this.information);
                }
                return String.format("%s (%s and %s)", this.choice, UNSOUND_TEXT, INCOMPLETE_TEXT);
            }
            if (this.unsound) {
                if (this.information != null) {
                    return String.format("%s (%s, %s)", this.choice, UNSOUND_TEXT, this.information);
                }
                return String.format("%s (%s)", this.choice, UNSOUND_TEXT);
            }
            if (this.incomplete) {
                if (this.information != null) {
                    return String.format("%s (%s, %s)", this.choice, INCOMPLETE_TEXT, this.information);
                }
                return String.format("%s (%s)", this.choice, INCOMPLETE_TEXT);
            }
            if (this.information != null) {
                return String.format("%s (%s)", this.choice, this.information);
            }
            return this.choice;
        }
    }
}

