/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.smt.model.Heap;
import de.uka.ilkd.key.smt.model.Location;
import de.uka.ilkd.key.smt.model.LocationSet;
import de.uka.ilkd.key.smt.model.Model;
import de.uka.ilkd.key.smt.model.ObjectVal;
import de.uka.ilkd.key.smt.model.Sequence;
import de.uka.ilkd.key.util.Pair;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class CETree {
    private static final Comparator<? super Pair<? super String, ? super String>> IGNORECASE_COMPARATOR = new Comparator<Pair<? super String, ? super String>>(){

        @Override
        public int compare(Pair<? super String, ? super String> o1, Pair<? super String, ? super String> o2) {
            String first = o1.first + "=" + o1.second;
            String second = o2.first + "=" + o2.second;
            return first.compareToIgnoreCase(second);
        }
    };
    private JTree tree;
    private Model model;

    public CETree(Model model) {
        this.model = model;
        model.removeUnnecessaryObjects();
        model.addAliases();
        this.initTree();
    }

    private void initTree() {
        this.tree = new JTree();
        DefaultMutableTreeNode root = this.constructTree();
        DefaultTreeModel tm = new DefaultTreeModel(root);
        this.tree.setModel(tm);
        CEMouseAdapter adapter = new CEMouseAdapter();
        this.tree.addMouseListener(adapter);
    }

    public JTree getTreeComponent() {
        return this.tree;
    }

    private DefaultMutableTreeNode constructTree() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("Model");
        DefaultMutableTreeNode constants = new DefaultMutableTreeNode("Constants");
        this.fillConstants(constants);
        root.add(constants);
        DefaultMutableTreeNode heaps = new DefaultMutableTreeNode("Heaps");
        this.fillHeaps(heaps);
        root.add(heaps);
        DefaultMutableTreeNode locssets = new DefaultMutableTreeNode("Location Sets");
        this.fillLocsets(locssets);
        root.add(locssets);
        DefaultMutableTreeNode sequences = new DefaultMutableTreeNode("Sequences");
        this.fillSequences(sequences);
        root.add(sequences);
        return root;
    }

    private void fillHeaps(DefaultMutableTreeNode heaps) {
        for (Heap h : this.model.getHeaps()) {
            DefaultMutableTreeNode heap = new DefaultMutableTreeNode(h.getName());
            heaps.add(heap);
            for (ObjectVal ov : h.getObjects()) {
                DefaultMutableTreeNode object = new DefaultMutableTreeNode(ov.getName());
                heap.add(object);
                this.addObjectProperties(ov, object);
            }
        }
    }

    private void addObjectProperties(ObjectVal ov, DefaultMutableTreeNode object) {
        String sortName = CETree.computeSortName(ov);
        List<Pair<String, String>> objectProperties = CETree.computeObjectProperties(ov, sortName);
        for (Pair<String, String> property : objectProperties) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode((String)property.first + "=" + (String)property.second);
            object.add(node);
        }
        DefaultMutableTreeNode fields = new DefaultMutableTreeNode("Fields");
        object.add(fields);
        List<Pair<String, String>> fieldsLabels = CETree.computeFields(ov);
        for (Pair pair : fieldsLabels) {
            DefaultMutableTreeNode name = new DefaultMutableTreeNode((String)pair.first + "=" + (String)pair.second);
            fields.add(name);
        }
        if (CETree.hasArrayFields(sortName)) {
            DefaultMutableTreeNode arrayFields = new DefaultMutableTreeNode("Array Fields");
            object.add(arrayFields);
            List<String> list = CETree.computeArrayFields(ov);
            for (String string : list) {
                DefaultMutableTreeNode arrayField = new DefaultMutableTreeNode(string);
                arrayFields.add(arrayField);
            }
        }
        DefaultMutableTreeNode functionValues = new DefaultMutableTreeNode("Functions");
        object.add(functionValues);
        List<Pair<String, String>> list = CETree.computeFunctions(ov);
        for (Pair pair : list) {
            DefaultMutableTreeNode fun = new DefaultMutableTreeNode((String)pair.first + "=" + (String)pair.second);
            functionValues.add(fun);
        }
    }

    public static List<Pair<String, String>> computeFunctions(ObjectVal ov) {
        LinkedList<Pair<String, String>> result = new LinkedList<Pair<String, String>>();
        for (Map.Entry e : ov.getFunValues().entrySet()) {
            result.add((Pair<String, String>)new Pair((Object)Model.removePipes((String)((String)e.getKey())), (Object)((String)e.getValue())));
        }
        return result;
    }

    public static List<String> computeArrayFields(ObjectVal ov) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < ov.getLength(); ++i) {
            result.add("[" + i + "]=" + ov.getArrayValue(i));
        }
        return result;
    }

    public static boolean hasArrayFields(String sortName) {
        return sortName.endsWith("[]");
    }

    public static String computeSortName(ObjectVal ov) {
        return ov.getSort() == null ? "java.lang.Object" : ov.getSort().name().toString();
    }

    public static List<Pair<String, String>> computeObjectProperties(ObjectVal ov, String sortName) {
        LinkedList<Pair<String, String>> result = new LinkedList<Pair<String, String>>();
        sortName = Model.removePipes((String)sortName);
        result.add(new Pair((Object)"Type", (Object)sortName));
        boolean ei = ov.isExactInstance();
        result.add(new Pair((Object)"Exact Instance", (Object)("" + ei)));
        int l = ov.getLength();
        result.add(new Pair((Object)"Length", (Object)("" + l)));
        return result;
    }

    public static List<Pair<String, String>> computeFields(ObjectVal ov) {
        ArrayList<Pair<String, String>> labels = new ArrayList<Pair<String, String>>();
        for (Map.Entry e : ov.getFieldvalues().entrySet()) {
            labels.add((Pair<String, String>)new Pair((Object)Model.removePipes((String)((String)e.getKey())), (Object)((String)e.getValue())));
        }
        Collections.sort(labels, IGNORECASE_COMPARATOR);
        return labels;
    }

    private void fillLocsets(DefaultMutableTreeNode locsets) {
        for (LocationSet ls : this.model.getLocsets()) {
            DefaultMutableTreeNode locset = new DefaultMutableTreeNode(CETree.computeLocationSetName(ls));
            locsets.add(locset);
            this.addLocSetProperties(ls, locset);
        }
    }

    public static String computeLocationSetName(LocationSet ls) {
        return Model.removePipes((String)ls.getName());
    }

    private void addLocSetProperties(LocationSet ls, DefaultMutableTreeNode locset) {
        List<String> locationNames = CETree.computeLocationSetProperties(ls);
        for (String locationName : locationNames) {
            DefaultMutableTreeNode locationNode = new DefaultMutableTreeNode(locationName);
            locset.add(locationNode);
        }
    }

    public static List<String> computeLocationSetProperties(LocationSet ls) {
        LinkedList<String> result = new LinkedList<String>();
        for (int i = 0; i < ls.size(); ++i) {
            Location l = ls.get(i);
            String locationName = "(" + Model.removePipes((String)l.getObjectID()) + ", " + Model.removePipes((String)l.getFieldID()) + ")";
            result.add(locationName);
        }
        return result;
    }

    private void fillSequences(DefaultMutableTreeNode sequences) {
        for (Sequence s : this.model.getSequences()) {
            DefaultMutableTreeNode sequence = new DefaultMutableTreeNode(CETree.computeSequenceName(s));
            sequences.add(sequence);
            this.addSequenceProperties(s, sequence);
        }
    }

    public static String computeSequenceName(Sequence s) {
        return Model.removePipes((String)s.getName());
    }

    private void addSequenceProperties(Sequence s, DefaultMutableTreeNode sequence) {
        List<String> labels = CETree.computeSequenceProperties(s);
        for (String label : labels) {
            DefaultMutableTreeNode node = new DefaultMutableTreeNode(label);
            sequence.add(node);
        }
    }

    public static List<String> computeSequenceProperties(Sequence s) {
        LinkedList<String> result = new LinkedList<String>();
        result.add("Length=" + s.getLength());
        for (int i = 0; i < s.getLength(); ++i) {
            result.add("[" + i + "]=" + Model.removePipes((String)s.get(i)));
        }
        return result;
    }

    private void fillConstants(DefaultMutableTreeNode constants) {
        List<Pair<String, String>> labels = CETree.computeConstantLabels(this.model);
        for (Pair<String, String> label : labels) {
            DefaultMutableTreeNode name = new DefaultMutableTreeNode((String)label.first + "=" + (String)label.second);
            constants.add(name);
        }
    }

    public static List<Pair<String, String>> computeConstantLabels(Model model) {
        Map map = model.getConstants();
        ArrayList<Pair<String, String>> labels = new ArrayList<Pair<String, String>>();
        for (Map.Entry e : map.entrySet()) {
            labels.add((Pair<String, String>)new Pair((Object)Model.removePipes((String)((String)e.getKey())), (Object)((String)e.getValue())));
        }
        Collections.sort(labels, IGNORECASE_COMPARATOR);
        return labels;
    }

    private class CEMouseAdapter
    extends MouseAdapter {
        @Override
        public void mousePressed(MouseEvent e) {
            Object oNode;
            int selRow = CETree.this.tree.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = CETree.this.tree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 2 && (oNode = selPath.getLastPathComponent()) instanceof DefaultMutableTreeNode) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)oNode;
                if (node.getChildCount() > 0) {
                    return;
                }
                String value = node.getUserObject().toString();
                if (value.contains("=")) {
                    value = value.substring(value.indexOf(61) + 1);
                }
                if (value.startsWith("#o")) {
                    value = value.substring(value.indexOf(61) + 1);
                    DefaultMutableTreeNode secondNode = (DefaultMutableTreeNode)selPath.getPath()[1];
                    if (secondNode.getUserObject().toString().equals("Heaps")) {
                        DefaultMutableTreeNode heapNode = (DefaultMutableTreeNode)selPath.getPath()[2];
                        String heapID = heapNode.getUserObject().toString();
                        Heap heap = null;
                        for (Heap h : CETree.this.model.getHeaps()) {
                            if (!heapID.equals(h.getName())) continue;
                            heap = h;
                            break;
                        }
                        if (heap == null) {
                            return;
                        }
                        ObjectVal val = null;
                        for (ObjectVal o : heap.getObjects()) {
                            if (!o.getName().equals(value)) continue;
                            val = o;
                            break;
                        }
                        if (val == null) {
                            return;
                        }
                        CETree.this.addObjectProperties(val, node);
                    }
                } else if (value.startsWith("#l")) {
                    LocationSet locset = null;
                    for (LocationSet ls : CETree.this.model.getLocsets()) {
                        if (!ls.getName().startsWith(value)) continue;
                        locset = ls;
                        break;
                    }
                    if (locset == null) {
                        return;
                    }
                    CETree.this.addLocSetProperties(locset, node);
                } else if (value.startsWith("#s")) {
                    Sequence sequence = null;
                    for (Sequence s : CETree.this.model.getSequences()) {
                        if (!s.getName().startsWith(value)) continue;
                        sequence = s;
                        break;
                    }
                    if (sequence == null) {
                        return;
                    }
                    CETree.this.addSequenceProperties(sequence, node);
                }
                CETree.this.tree.expandPath(selPath);
            }
        }
    }
}

