/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.gui.fonticons.IconFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DropdownSelectionButton {
    private JButton selectionComponent;
    private JButton actionComponent;
    private Action[] items;
    private Function<Action[], Action> reduceChoice;
    private int maxChoiceAmount;
    private final List<JMenuItem> menuItems = new ArrayList<JMenuItem>();
    private final Set<Action> selectedItems = new HashSet<Action>();
    private final EmptyAction emptyItem = new EmptyAction(false);
    private Action executedAction = this.emptyItem;
    private String prefix = "";
    private final int iconSize;
    private final List<Component> components = new ArrayList<Component>();
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>();
    private JPopupMenu menu;
    private boolean buttonShouldOpenMenu = true;

    public DropdownSelectionButton(int iconSize) {
        this.iconSize = iconSize;
    }

    public void setEnabled(boolean b) {
        if (this.items.length == 0) {
            b = false;
        }
        this.getActionButton().setEnabled(b);
    }

    public void addListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public JComponent getSelectionComponent() {
        return this.getSelectionButton();
    }

    public JComponent getActionComponent() {
        return this.getActionButton();
    }

    public void setAction(Action action) {
        this.getActionButton().setAction(action);
    }

    public Action getAction() {
        return this.getActionButton().getAction();
    }

    public Action[] getSelectedItems() {
        return this.selectedItems.toArray(new Action[this.selectedItems.size()]);
    }

    public boolean isEmptyItem() {
        return this.executedAction == this.emptyItem;
    }

    public Action getEmptyItem() {
        return this.emptyItem;
    }

    public void setEmptyItem(String text, String toolTip) {
        boolean update = this.isEmptyItem();
        this.emptyItem.setText(text);
        this.emptyItem.setToolTip(toolTip);
        if (update) {
            this.executedAction = this.emptyItem;
            this.update();
        }
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    private void update() {
        this.setAction(this.executedAction);
        if (this.getAction() != null) {
            this.getAction().putValue("Name", this.isEmptyItem() ? this.executedAction.toString() : this.prefix + this.executedAction.toString());
            if (this.isEmptyItem()) {
                this.getAction().putValue("ShortDescription", this.emptyItem.getToolTip());
            }
        }
        if (this.maxChoiceAmount == 1) {
            this.selectedItems.clear();
            this.selectedItems.add(this.executedAction);
        }
    }

    public boolean contains(Action item) {
        for (Action it : this.items) {
            if (!it.equals(item)) continue;
            return true;
        }
        return false;
    }

    public void setSelectedItem(Action item) {
        if (item == null) {
            return;
        }
        this.executedAction = item;
        this.update();
        for (ChangeListener l : this.listeners) {
            l.stateChanged(new ChangeEvent(this));
        }
    }

    protected JButton getSelectionButton() {
        if (this.selectionComponent == null) {
            this.selectionComponent = new JButton();
            this.selectionComponent.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    DropdownSelectionButton.this.buttonShouldOpenMenu = !DropdownSelectionButton.this.getMenu().isVisible();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    DropdownSelectionButton.this.buttonShouldOpenMenu = true;
                }
            });
            this.selectionComponent.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DropdownSelectionButton.this.items.length > 0) {
                        if (!DropdownSelectionButton.this.buttonShouldOpenMenu) {
                            DropdownSelectionButton.this.buttonShouldOpenMenu = !DropdownSelectionButton.this.getMenu().isVisible();
                            return;
                        }
                        OptionalInt width = Arrays.stream(DropdownSelectionButton.this.getMenu().getComponents()).mapToInt(c -> c.getPreferredSize().width).max();
                        if (width.isEmpty()) {
                            width = OptionalInt.of(0);
                        }
                        int newWidth = Math.max(width.getAsInt(), DropdownSelectionButton.this.actionComponent.getWidth() + DropdownSelectionButton.this.selectionComponent.getWidth());
                        DropdownSelectionButton.this.getMenu().setPopupSize(newWidth, Arrays.stream(DropdownSelectionButton.this.getMenu().getComponents()).mapToInt(c -> c.getPreferredSize().height).sum());
                        DropdownSelectionButton.this.getMenu().show(DropdownSelectionButton.this.getActionButton(), 0, DropdownSelectionButton.this.getActionButton().getHeight());
                        DropdownSelectionButton.this.buttonShouldOpenMenu = false;
                    }
                }
            });
            this.selectionComponent.setFocusable(false);
            this.selectionComponent.setIcon(IconFactory.selectDecProcArrow(this.iconSize));
        }
        return this.selectionComponent;
    }

    protected JButton getActionButton() {
        if (this.actionComponent == null) {
            this.actionComponent = new JButton();
            this.actionComponent.addChangeListener(e -> this.getSelectionButton().setEnabled(this.actionComponent.isEnabled()));
            this.actionComponent.setFocusPainted(false);
        }
        return this.actionComponent;
    }

    protected JPopupMenu getMenu() {
        if (this.menu == null) {
            this.components.clear();
            this.menu = new JPopupMenu();
        }
        return this.menu;
    }

    public void setItems(Action[] it, Function<Action[], Action> reduce, int maxChoice) {
        this.items = it;
        if (it == null) {
            this.items = new Action[0];
        }
        this.reduceChoice = reduce;
        this.maxChoiceAmount = Math.max(1, maxChoice);
        if (this.items.length <= 1) {
            this.maxChoiceAmount = 1;
        }
        HashSet<Action> oldSelectedItems = new HashSet<Action>(this.selectedItems);
        this.selectedItems.clear();
        this.menuItems.clear();
        for (Action item : this.items) {
            JMenuItem menuItem;
            JMenuItem jMenuItem = menuItem = this.maxChoiceAmount > 1 ? new DoubleClickCheckBoxMenuItem(item) : new SelectionMenuItem(item);
            if (oldSelectedItems.contains(item) && this.maxChoiceAmount > 1) {
                menuItem.setSelected(true);
            }
            menuItem.setEnabled(true);
            menuItem.setText(item.toString());
            menuItem.putClientProperty("CheckBoxMenuItem.doNotCloseOnMouseClick", Boolean.TRUE);
            this.menuItems.add(menuItem);
        }
        this.refreshSelectionItems(this.menuItems);
        if (this.items.length == 0) {
            this.setSelectedItem(this.emptyItem);
            return;
        }
        if (this.maxChoiceAmount <= 1) {
            this.setSelectedItem(this.contains(this.getAction()) ? this.getAction() : this.getTopItem());
            return;
        }
        if (this.getSelectedItems().length == 0) {
            this.menuItems.get(0).setSelected(true);
        }
    }

    public void refreshSelectionItems(Collection<JMenuItem> newMenuItems) {
        this.menu = null;
        for (JMenuItem item : newMenuItems) {
            this.getMenu().add(item);
        }
        for (Component comp : this.components) {
            this.getMenu().add(comp);
        }
        this.getMenu().pack();
    }

    public void addComponent(Component comp) {
        this.getMenu().add(comp);
        this.components.add(comp);
        this.getMenu().pack();
    }

    public void removeComponent(Component comp) {
        this.components.remove(comp);
        this.getMenu().remove(comp);
        this.getMenu().pack();
    }

    public Action getTopItem() {
        if (this.items.length > 0) {
            return this.items[0];
        }
        return this.emptyItem;
    }

    public void selectMaxNumber() {
        for (int i = 0; i < this.maxChoiceAmount; ++i) {
            this.menuItems.get(i).setSelected(true);
        }
    }

    public void deselectAll() {
        for (JMenuItem item : this.menuItems) {
            item.setSelected(false);
        }
    }

    private final class SelectionMenuItem
    extends JMenuItem {
        private final transient Action action;

        public SelectionMenuItem(final Action item) {
            super.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DropdownSelectionButton.this.setSelectedItem(item);
                }
            });
            this.action = item;
        }

        @Override
        public Action getAction() {
            return this.action;
        }
    }

    private final class DoubleClickCheckBoxMenuItem
    extends JCheckBoxMenuItem {
        private final transient Action doubleClickAction;

        private DoubleClickCheckBoxMenuItem(Action action) {
            final DoubleClickCheckBoxMenuItem menuItem = this;
            super.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (DropdownSelectionButton.this.getSelectedItems().length > DropdownSelectionButton.this.maxChoiceAmount) {
                        menuItem.setSelected(false);
                    } else {
                        menuItem.setSelected(menuItem.isSelected());
                    }
                }
            });
            this.setToolTipText("On double-click: " + action.getValue("ShortDescription"));
            this.doubleClickAction = action;
        }

        @Override
        public void setSelected(boolean b) {
            if (b) {
                DropdownSelectionButton.this.selectedItems.add(this.getAction());
            } else {
                DropdownSelectionButton.this.selectedItems.remove(this.getAction());
            }
            super.setSelected(b);
            DropdownSelectionButton.this.setSelectedItem(DropdownSelectionButton.this.reduceChoice.apply(DropdownSelectionButton.this.getSelectedItems()));
        }

        @Override
        public Action getAction() {
            return this.doubleClickAction;
        }

        @Override
        protected void processMouseEvent(MouseEvent e) {
            if (e.getClickCount() >= 2) {
                this.doubleClickAction.actionPerformed(new ActionEvent(e, 500, null));
                this.setSelected(true);
                return;
            }
            super.processMouseEvent(e);
        }
    }

    public static class EmptyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;
        private String text;
        private String toolTip;
        private boolean leaveButtonsEnabled;

        public EmptyAction(boolean enabled) {
            this.leaveButtonsEnabled = enabled;
            this.setText("empty");
        }

        public void setText(String t) {
            this.text = t;
            this.putValue("Name", this.text);
            this.putValue("ShortDescription", this.toolTip);
        }

        public void setToolTip(String tip) {
            this.toolTip = tip;
        }

        public String getToolTip() {
            return this.toolTip;
        }

        public String toString() {
            return this.text;
        }

        @Override
        public boolean isEnabled() {
            return this.leaveButtonsEnabled;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
        }
    }
}

