/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.gui.smt.CETree;
import de.uka.ilkd.key.smt.SMTSolver;
import de.uka.ilkd.key.smt.model.Model;
import de.uka.ilkd.key.smt.solvertypes.SolverTypes;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.util.Collection;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Element;
import org.key_project.util.java.StringUtil;

public class InformationWindow
extends JDialog {
    private static final long serialVersionUID = 1L;
    public static final String CE_HELP = "Bounded Counterexample Finder for KeY Proof Obligations\n\n- Shows a bounded model which satisfies the negation of the selected proof obligation\n- Only proof obligations without modalities are supported\n- The OneStepSimplifier neeeds to be activated, otherwise updates need to be handled manually beforehand\n- Double click ond location set, sequence and object nodes(inside a heap) to extend them\n- Choose bit sizes in Options -> SMT Solvers\n- We have identified the following sources for spurious counterexample:\n   - Chosen bit sizes too small. Example: Bit size of Integer is 3 but literal 9 appears in proof obligation.\n   - Finite type instances: Example: There is no maximum integer.\n   - Removal of axioms. Example: There is a location set which contains location (o, f)";
    private JTabbedPane tabbedPane;
    private Model model;

    public InformationWindow(Dialog parent, SMTSolver solver, Collection<Information> information, String title) {
        super(parent);
        this.setTitle(title);
        this.initModel(solver);
        for (Information el : information) {
            this.getTabbedPane().addTab(el.title, this.newTab(el));
        }
        this.setSize(600, 500);
        this.getContentPane().add(this.getTabbedPane());
        this.setModalExclusionType(Dialog.ModalExclusionType.APPLICATION_EXCLUDE);
        this.setDefaultCloseOperation(2);
        this.setLocationByPlatform(true);
        this.setVisible(true);
    }

    private void initModel(SMTSolver solver) {
        Model m;
        if (solver.getType() != SolverTypes.Z3_CE_SOLVER) {
            return;
        }
        if (solver.getSocket().getQuery() == null) {
            return;
        }
        this.model = m = solver.getSocket().getQuery().getModel();
        this.setTitle("Counterexample " + this.getTitle());
        this.getTabbedPane().addTab("Counterexample", this.createModelTab());
        this.createHelpTab();
    }

    private void createHelpTab() {
        JTextArea content = new JTextArea();
        content.setEditable(false);
        content.setText(CE_HELP);
        JScrollPane pane = new JScrollPane();
        pane.getViewport().add(content);
        pane.setVerticalScrollBarPolicy(22);
        this.getTabbedPane().addTab("Help", pane);
    }

    private Component createModelTab() {
        CETree tree = new CETree(this.model);
        JScrollPane pane = new JScrollPane();
        pane.getViewport().add(tree.getTreeComponent());
        pane.setVerticalScrollBarPolicy(22);
        return pane;
    }

    private Component newTab(Information information) {
        final JTextArea lines = new JTextArea("1");
        final JTextArea content = new JTextArea();
        content.setFont(UIManager.getFont("KEY_FONT_CURRENT_GOAL_VIEW"));
        lines.setBackground(Color.LIGHT_GRAY);
        lines.setEditable(false);
        content.setEditable(false);
        content.getDocument().addDocumentListener(new DocumentListener(){

            public String getText() {
                int caretPosition = content.getDocument().getLength();
                Element root = content.getDocument().getDefaultRootElement();
                String text = "1" + StringUtil.NEW_LINE;
                for (int i = 2; i < root.getElementIndex(caretPosition) + 2; ++i) {
                    text = text + i + StringUtil.NEW_LINE;
                }
                return text;
            }

            @Override
            public void changedUpdate(DocumentEvent de) {
                lines.setText(this.getText());
            }

            @Override
            public void insertUpdate(DocumentEvent de) {
                lines.setText(this.getText());
            }

            @Override
            public void removeUpdate(DocumentEvent de) {
                lines.setText(this.getText());
            }
        });
        content.setText(information.content);
        JScrollPane pane = new JScrollPane();
        pane.getViewport().add(content);
        pane.setRowHeaderView(lines);
        pane.setVerticalScrollBarPolicy(22);
        return pane;
    }

    private JTabbedPane getTabbedPane() {
        if (this.tabbedPane == null) {
            this.tabbedPane = new JTabbedPane();
        }
        return this.tabbedPane;
    }

    public static class Information {
        private final String content;
        private final String title;
        private final String solver;

        public Information(String title, String content, String solver) {
            this.content = content;
            this.title = title;
            this.solver = solver;
        }

        public String getContent() {
            return this.content;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSolver() {
            return this.solver;
        }
    }
}

