/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.core.KeYSelectionEvent;
import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.smt.TreePanel;
import de.uka.ilkd.key.proof.TacletIndex;
import de.uka.ilkd.key.rule.NoPosTacletApp;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.taclettranslation.assumptions.SupportedTaclets;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;

class LeafPanel
extends TreePanel {
    private static TacletIndex index;
    private static SelectionListener listener;
    private static final long serialVersionUID = 1L;
    private SupportedTaclets.TreeItem currentNode = null;
    private JCheckBox tacletName = new JCheckBox();
    private JLabel infoButton = new JLabel("<html><U>info</html>");
    private JLabel genericLabel = new JLabel();

    public static KeYSelectionListener getSelectionListener() {
        return listener;
    }

    public LeafPanel(final SupportedTaclets supportedTaclets) {
        this.setBackground(UIManager.getColor("Tree.textBackground"));
        this.addComponent(this.tacletName);
        this.addComponent(this.infoButton);
        this.addComponent(this.genericLabel);
        ToolTipManager.sharedInstance().registerComponent(this.tacletName);
        this.infoButton.setForeground(Color.BLUE);
        this.tacletName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                LeafPanel.this.newMode(LeafPanel.this.currentNode, LeafPanel.this.tacletName.isSelected() ? SupportedTaclets.TreeItem.SelectionMode.all : SupportedTaclets.TreeItem.SelectionMode.nothing, supportedTaclets);
                LeafPanel.this.tree.repaint();
            }
        });
        this.infoButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                LeafPanel.this.showInfo(LeafPanel.this.currentNode);
                super.mouseClicked(e);
            }
        });
    }

    private void showInfo(SupportedTaclets.TreeItem item) {
        NoPosTacletApp app;
        if (index == null) {
            JOptionPane.showMessageDialog(this, "You must load a proof to make the information for this taclet available.", "Taclet View", -1);
            return;
        }
        Set apps = index.allNoPosTacletApps();
        Iterator iterator = apps.iterator();
        while (iterator.hasNext() && !(app = (NoPosTacletApp)iterator.next()).taclet().name().toString().equals(item.toString())) {
        }
    }

    @Override
    protected JPanel init(SupportedTaclets.TreeItem node, SupportedTaclets.TreeItem r, JTree t, DefaultSMTSettings smtSettings) {
        int max = smtSettings != null ? smtSettings.getMaxNumberOfGenerics() : 0;
        this.currentNode = node;
        this.tree = t;
        this.root = r;
        this.tacletName.setText(node.toString());
        this.tacletName.setSelected(node.getMode() == SupportedTaclets.TreeItem.SelectionMode.all);
        int count = node.getGenericCount();
        if (count > 0) {
            this.genericLabel.setVisible(true);
            if (max < count) {
                this.genericLabel.setForeground(Color.RED);
                this.genericLabel.setText("too many generic sorts: " + count);
            } else {
                this.genericLabel.setForeground(Color.GREEN);
                this.genericLabel.setText("generic sorts: " + count);
            }
        } else {
            this.genericLabel.setVisible(false);
        }
        return this;
    }

    static {
        listener = new SelectionListener();
    }

    private static class SelectionListener
    implements KeYSelectionListener {
        private SelectionListener() {
        }

        @Override
        public void selectedNodeChanged(KeYSelectionEvent e) {
            this.react(e);
        }

        private void react(KeYSelectionEvent e) {
            index = e.getSource().getSelectedProof() != null && e.getSource().getSelectedGoal() != null ? e.getSource().getSelectedGoal().indexOfTaclets() : null;
        }

        @Override
        public void selectedProofChanged(KeYSelectionEvent e) {
            this.react(e);
        }
    }
}

