/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.gui.IssueDialog;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.smt.ProgressModel;
import de.uka.ilkd.key.gui.smt.ProgressTable;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class ProgressDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final ProgressTable table;
    private JButton applyButton;
    private JButton stopButton;
    private JScrollPane scrollPane;
    private JProgressBar progressBar;
    private final ProgressDialogListener listener;
    private Modus modus = Modus.stopModus;
    private Box statusMessageBox;

    public ProgressDialog(ProgressModel model, ProgressDialogListener listener, boolean counterexample, int resolution, int progressBarMax, String[] labelTitles, String ... titles) {
        super(MainWindow.getInstance());
        this.table = new ProgressTable(resolution, listener, labelTitles);
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setModel(model, titles);
        this.listener = listener;
        this.setLocationByPlatform(true);
        if (counterexample) {
            this.setTitle("SMT Counterexample Search");
        } else {
            this.setTitle("SMT Interface");
        }
        this.getProgressBar().setMaximum(progressBarMax);
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(this.getStopButton());
        buttonBox.add(Box.createHorizontalStrut(5));
        if (!counterexample) {
            buttonBox.add(this.getApplyButton());
            buttonBox.add(Box.createHorizontalStrut(5));
        }
        GridBagConstraints constraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(5, 5, 0, 5), 0, 0);
        contentPane.add((Component)this.getProgressBar(), constraints);
        ++constraints.gridy;
        constraints.weighty = 2.0;
        contentPane.add((Component)this.getScrollPane(), constraints);
        ++constraints.gridy;
        constraints.weighty = 1.0;
        ++constraints.gridy;
        constraints.weighty = 0.0;
        constraints.insets.bottom = 5;
        contentPane.add((Component)buttonBox, constraints);
        this.pack();
    }

    public void setProgress(int value) {
        this.getProgressBar().setValue(value);
    }

    public JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
        }
        return this.progressBar;
    }

    private JButton getApplyButton() {
        if (this.applyButton == null) {
            this.applyButton = new JButton("Apply");
            this.applyButton.setEnabled(false);
            this.applyButton.addActionListener(e -> {
                try {
                    this.listener.applyButtonClicked();
                }
                catch (Exception exception) {
                    IssueDialog.showExceptionDialog(this, exception);
                }
            });
        }
        return this.applyButton;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(this.table, 22, 32);
            Dimension dim = new Dimension(this.table.getPreferredSize());
            dim.width += (Integer)UIManager.get("ScrollBar.width") + 2;
            dim.height = this.scrollPane.getPreferredSize().height;
            this.scrollPane.setPreferredSize(dim);
        }
        return this.scrollPane;
    }

    private JButton getStopButton() {
        if (this.stopButton == null) {
            this.stopButton = new JButton("Stop");
            this.stopButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ProgressDialog.this.modus.equals((Object)Modus.discardModus)) {
                        ProgressDialog.this.listener.discardButtonClicked();
                    }
                    if (ProgressDialog.this.modus.equals((Object)Modus.stopModus)) {
                        ProgressDialog.this.listener.stopButtonClicked();
                    }
                }
            });
        }
        return this.stopButton;
    }

    public void setModus(Modus m) {
        this.modus = m;
        switch (this.modus) {
            case discardModus: {
                this.stopButton.setText("Discard");
                if (this.applyButton == null) break;
                this.applyButton.setEnabled(true);
                break;
            }
            case stopModus: {
                this.stopButton.setText("Stop");
                if (this.applyButton == null) break;
                this.applyButton.setEnabled(false);
            }
        }
    }

    public static void main(String[] args) throws InterruptedException {
        final ProgressModel model = new ProgressModel();
        model.addColumn(new ProgressModel.TitleColumn("Summary", "1", "2", "3", "4"));
        model.addColumn(new ProgressModel.ProcessColumn(4));
        model.addColumn(new ProgressModel.ProcessColumn(4));
        model.addColumn(new ProgressModel.ProcessColumn(4));
        String[] infoLabels = new String[]{"Processed", "Closed: ", "Unknown: ", "Counter Example:", "Errors:"};
        ProgressDialog dialog = new ProgressDialog(model, null, true, 100, 10, infoLabels, "", "Z3", "Simplify", "Yices");
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        int i = 0;
        while (i < 1000) {
            final int p = i++;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    model.setProgress(p / 10, 1, 2);
                }
            });
            Thread.sleep(10L);
        }
        model.setText("TIMEOUT", 1, 2);
        model.setEditable(true);
    }

    public static interface ProgressDialogListener
    extends ProgressTable.ProgressTableListener {
        public void applyButtonClicked();

        public void stopButtonClicked();

        public void discardButtonClicked();

        public void additionalInformationChosen(Object var1);
    }

    public static enum Modus {
        stopModus,
        discardModus;

    }
}

