/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import java.awt.Color;
import java.util.ArrayList;
import javax.swing.table.AbstractTableModel;

class ProgressModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private ArrayList<Column> columns = new ArrayList();
    private int rowCount = -1;

    public void addColumn(Column column) {
        if (this.rowCount != -1 && this.rowCount != column.getRowCount()) {
            throw new IllegalArgumentException("Columns must have the same number of rows.");
        }
        this.rowCount = column.getRowCount();
        this.columns.add(column);
    }

    public void setProgress(int value, int column, int row) {
        ProcessColumn col = (ProcessColumn)this.columns.get(++column);
        col.setProgress(value, row);
        this.fireTableCellUpdated(row, column);
    }

    public void setText(String text, int column, int row) {
        ProcessColumn col = (ProcessColumn)this.columns.get(++column);
        col.setText(text, row);
        this.fireTableCellUpdated(row, column);
    }

    public void setTextColor(Color color, int x, int y) {
        ProcessColumn col = (ProcessColumn)this.columns.get(++x);
        col.data[y].textColor = color;
        this.fireTableCellUpdated(x, y);
    }

    public void setForegroundColor(Color color, int x, int y) {
        ProcessColumn col = (ProcessColumn)this.columns.get(++x);
        col.data[y].foregroundColor = color;
        this.fireTableCellUpdated(x, y);
    }

    public void setBackgroundColor(Color color, int x, int y) {
        ProcessColumn col = (ProcessColumn)this.columns.get(++x);
        col.data[y].backgroundColor = color;
        this.fireTableCellUpdated(x, y);
    }

    public void setEditable(boolean b) {
        for (Column column : this.columns) {
            if (!(column instanceof ProcessColumn)) continue;
            ((ProcessColumn)column).setEditable(b);
        }
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return this.columns.get(columnIndex).isEditable();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columns.get(columnIndex).getClass();
    }

    @Override
    public Object getValueAt(int row, int col) {
        return this.columns.get(col).getObject(row);
    }

    public Column getColumn(int col) {
        return this.columns.get(col);
    }

    public static class ProcessColumn
    implements Column {
        public final ProcessData[] data;
        private boolean isEditable = false;

        public ProcessColumn(int size) {
            this.data = new ProcessData[size];
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = new ProcessData();
            }
        }

        @Override
        public Object getObject(int row) {
            return this.data[row];
        }

        public void setProgress(int value, int row) {
            this.data[row].progress = value;
        }

        public void setText(String value, int row) {
            this.data[row].text = value;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        public void setEditable(boolean b) {
            this.isEditable = b;
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i].isEditable = b;
            }
        }

        @Override
        public boolean isEditable() {
            return this.isEditable;
        }

        static class ProcessData {
            private int progress = 0;
            private String text = "";
            private boolean isEditable = false;
            private Color textColor = Color.BLACK;
            private Color backgroundColor = Color.WHITE;
            private Color foregroundColor = Color.BLUE;
            private Color selectedTextColor = Color.WHITE;

            ProcessData() {
            }

            public int getProgress() {
                return this.progress;
            }

            public String getText() {
                return this.text;
            }

            public boolean isEditable() {
                return this.isEditable;
            }

            public Color getBackgroundColor() {
                return this.backgroundColor;
            }

            public Color getSelectedTextColor() {
                return this.selectedTextColor;
            }

            public Color getTextColor() {
                return this.textColor;
            }

            public Color getForegroundColor() {
                return this.foregroundColor;
            }
        }
    }

    public static class TitleColumn
    implements Column {
        private final String[] titles;

        public TitleColumn(String ... titles) {
            this.titles = titles;
        }

        @Override
        public Object getObject(int row) {
            return this.titles[row];
        }

        @Override
        public int getRowCount() {
            return this.titles.length;
        }

        @Override
        public boolean isEditable() {
            return false;
        }
    }

    private static interface Column {
        public Object getObject(int var1);

        public int getRowCount();

        public boolean isEditable();
    }
}

