/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.gui.smt.ProgressModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.plaf.basic.BasicProgressBarUI;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

class ProgressTable
extends JTable {
    private static final long serialVersionUID = 1L;
    private static final int NUMBER_OF_VISIBLE_ROWS = 8;
    private final ProgressPanel progressPanelRenderer = new ProgressPanel();
    private ProgressPanel progressPanelEditor;
    private final TableCellRenderer renderer = new TableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ProgressModel.ProcessColumn.ProcessData data = (ProgressModel.ProcessColumn.ProcessData)value;
            ProgressTable.this.prepareProgressPanel(ProgressTable.this.progressPanelRenderer, data);
            return ProgressTable.this.progressPanelRenderer;
        }
    };
    private final TableCellEditor editor = new ProgressCellEditor();
    private Point currentEditorCell = new Point();

    private void prepareProgressPanel(ProgressPanel panel, final ProgressModel.ProcessColumn.ProcessData data) {
        panel.setValue(data.getProgress());
        panel.setText(data.getText());
        panel.infoButton.setEnabled(data.isEditable());
        panel.progressBar.setBackground(data.getBackgroundColor());
        panel.progressBar.setForeground(data.getForegroundColor());
        panel.progressBar.setUI(new BasicProgressBarUI(){

            @Override
            protected Color getSelectionForeground() {
                return data.getSelectedTextColor();
            }

            @Override
            protected Color getSelectionBackground() {
                return data.getTextColor();
            }
        });
    }

    public ProgressTable(int resolution, ProgressTableListener listener, String ... titles) {
        this.setDefaultRenderer(ProgressModel.ProcessColumn.class, this.renderer);
        this.setDefaultEditor(ProgressModel.ProcessColumn.class, this.editor);
        this.init(this.getProgressPanelEditor(), this.getFont(), resolution, listener);
        this.init(this.progressPanelRenderer, this.getFont(), resolution, listener);
    }

    private void init(ProgressPanel panel, Font font, int resolution, final ProgressTableListener listener) {
        panel.setFont(font);
        panel.progressBar.setMaximum(resolution);
        panel.infoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                listener.infoButtonClicked(ProgressTable.this.currentEditorCell.x - 1, ProgressTable.this.currentEditorCell.y);
            }
        });
    }

    public void setModel(ProgressModel model, String ... titles) {
        int i;
        assert (titles.length == model.getColumnCount());
        super.setModel(model);
        for (i = 0; i < titles.length; ++i) {
            TableColumn col = this.getTableHeader().getColumnModel().getColumn(i);
            col.setHeaderValue(titles[i]);
            ProgressTable.packColumn(this, i, 5);
        }
        for (i = 0; i < model.getRowCount(); ++i) {
            this.setRowHeight(this.progressPanelRenderer.getPreferredSize().height + 5);
        }
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension dim = new Dimension(super.getPreferredScrollableViewportSize());
        dim.height = Math.min(8 * (this.progressPanelRenderer.getPreferredSize().height + 5), dim.height);
        return dim;
    }

    public static void packColumn(JTable table, int vColIndex, int margin) {
        TableColumnModel colModel = table.getColumnModel();
        TableColumn col = colModel.getColumn(vColIndex);
        int width = 0;
        TableCellRenderer renderer = col.getHeaderRenderer();
        if (renderer == null) {
            renderer = table.getTableHeader().getDefaultRenderer();
        }
        Component comp = renderer.getTableCellRendererComponent(table, col.getHeaderValue(), false, false, 0, 0);
        width = comp.getPreferredSize().width;
        for (int r = 0; r < table.getRowCount(); ++r) {
            renderer = table.getCellRenderer(r, vColIndex);
            comp = renderer.getTableCellRendererComponent(table, table.getValueAt(r, vColIndex), false, false, r, vColIndex);
            width = Math.max(width, comp.getPreferredSize().width);
        }
        col.setPreferredWidth(width += 10 * margin);
    }

    private ProgressPanel getProgressPanelEditor() {
        if (this.progressPanelEditor == null) {
            this.progressPanelEditor = new ProgressPanel();
        }
        return this.progressPanelEditor;
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (e.getType() == 0) {
            this.repaint();
        }
        super.tableChanged(e);
    }

    private class ProgressCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private static final long serialVersionUID = 1L;

        private ProgressCellEditor() {
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            ProgressTable.this.currentEditorCell.x = column;
            ProgressTable.this.currentEditorCell.y = row;
            ProgressModel.ProcessColumn.ProcessData data = (ProgressModel.ProcessColumn.ProcessData)value;
            ProgressTable.this.prepareProgressPanel(ProgressTable.this.getProgressPanelEditor(), data);
            return ProgressTable.this.getProgressPanelEditor();
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    public static class ProgressPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private JProgressBar progressBar;
        private JButton infoButton;

        private JProgressBar getProgressBar() {
            if (this.progressBar == null) {
                this.progressBar = new JProgressBar();
                int height = this.getInfoButton().getMaximumSize().height;
                this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, height));
                this.progressBar.setString("Test");
                this.progressBar.setStringPainted(true);
                this.progressBar.setFont(this.getFont());
            }
            return this.progressBar;
        }

        private JButton getInfoButton() {
            if (this.infoButton == null) {
                this.infoButton = new JButton("Info");
                this.infoButton.setFont(this.getFont());
                Dimension dim = new Dimension();
                this.infoButton.setMargin(new Insets(0, 0, 0, 0));
                dim.height = this.getFontMetrics(this.getFont()).getHeight() + 2;
                dim.width = dim.height * 3;
                this.infoButton.setMinimumSize(dim);
                this.infoButton.setPreferredSize(dim);
                this.infoButton.setMaximumSize(dim);
            }
            return this.infoButton;
        }

        ProgressPanel() {
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createVerticalStrut(2));
            Box content = Box.createHorizontalBox();
            content.add(Box.createHorizontalStrut(2));
            content.add(this.getProgressBar());
            content.add(Box.createHorizontalStrut(2));
            content.add(this.getInfoButton());
            content.add(Box.createHorizontalStrut(2));
            this.add(content);
            this.add(Box.createVerticalStrut(2));
        }

        public void setValue(int value) {
            this.getProgressBar().setValue(value);
        }

        public void setText(String text) {
            this.getProgressBar().setString(text);
            this.getProgressBar().setStringPainted(text != null && !text.isEmpty());
        }
    }

    public static interface ProgressTableListener {
        public void infoButtonClicked(int var1, int var2);
    }
}

