/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.core.KeYMediator;
import de.uka.ilkd.key.gui.MainWindow;
import de.uka.ilkd.key.gui.colors.ColorSettings;
import de.uka.ilkd.key.gui.smt.InformationWindow;
import de.uka.ilkd.key.gui.smt.ProgressDialog;
import de.uka.ilkd.key.gui.smt.ProgressModel;
import de.uka.ilkd.key.logic.DefaultVisitor;
import de.uka.ilkd.key.logic.Term;
import de.uka.ilkd.key.logic.Visitor;
import de.uka.ilkd.key.logic.op.IProgramMethod;
import de.uka.ilkd.key.logic.op.Modality;
import de.uka.ilkd.key.proof.Goal;
import de.uka.ilkd.key.proof.Proof;
import de.uka.ilkd.key.rule.RuleApp;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.settings.ProofIndependentSMTSettings;
import de.uka.ilkd.key.smt.RuleAppSMT;
import de.uka.ilkd.key.smt.SMTProblem;
import de.uka.ilkd.key.smt.SMTSolver;
import de.uka.ilkd.key.smt.SMTSolverResult;
import de.uka.ilkd.key.smt.SolverLauncher;
import de.uka.ilkd.key.smt.SolverLauncherListener;
import de.uka.ilkd.key.smt.solvertypes.SolverType;
import de.uka.ilkd.key.smt.solvertypes.SolverTypes;
import de.uka.ilkd.key.taclettranslation.assumptions.TacletSetTranslation;
import java.awt.Color;
import java.awt.Dialog;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class SolverListener
implements SolverLauncherListener {
    private ProgressDialog progressDialog;
    private ProgressModel progressModel;
    private Collection<InternSMTProblem> problems = new LinkedList<InternSMTProblem>();
    private Collection<SMTProblem> smtProblems = new LinkedList<SMTProblem>();
    private boolean[][] problemProcessed;
    private int finishedCounter;
    private Timer timer = new Timer();
    private final DefaultSMTSettings settings;
    private final Proof smtProof;
    private static final ColorSettings.ColorProperty RED = ColorSettings.define("[solverListener]red", "", new Color(180, 43, 43));
    private static final ColorSettings.ColorProperty GREEN = ColorSettings.define("[solverListener]green", "", new Color(43, 180, 43));
    private static int FILE_ID = 0;
    private static final int RESOLUTION = 1000;

    public SolverListener(DefaultSMTSettings settings, Proof smtProof) {
        this.settings = settings;
        this.smtProof = smtProof;
    }

    public void launcherStopped(SolverLauncher launcher, Collection<SMTSolver> problemSolvers) {
        this.timer.cancel();
        this.storeInformation();
        this.progressModel.setEditable(true);
        this.refreshDialog();
        this.progressDialog.setModus(ProgressDialog.Modus.discardModus);
        for (InternSMTProblem problem : this.problems) {
            problem.createInformation();
        }
        if (this.settings.getModeOfProgressDialog() == ProofIndependentSMTSettings.ProgressMode.CLOSE) {
            this.applyEvent(launcher);
        }
    }

    private String getTitle(SMTProblem p) {
        Object title = "";
        Iterator it = p.getSolvers().iterator();
        while (it.hasNext()) {
            title = (String)title + ((SMTSolver)it.next()).name();
            if (!it.hasNext()) continue;
            title = (String)title + ", ";
        }
        return title;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyResults() {
        KeYMediator mediator = MainWindow.getInstance().getMediator();
        mediator.stopInterface(true);
        try {
            for (SMTProblem problem : this.smtProblems) {
                if (problem.getFinalResult().isValid() != SMTSolverResult.ThreeValuedTruth.VALID) continue;
                RuleAppSMT app = RuleAppSMT.rule.createApp(null).setTitle(this.getTitle(problem));
                problem.getGoal().apply((RuleApp)app);
            }
        }
        finally {
            mediator.startInterface(true);
        }
    }

    private void showInformation(InternSMTProblem problem) {
        new InformationWindow((Dialog)this.progressDialog, problem.solver, problem.information, "Information for " + problem.toString());
    }

    /*
     * WARNING - void declaration
     */
    private void prepareDialog(Collection<SMTProblem> smtproblems, Collection<SolverType> solverTypes, SolverLauncher launcher) {
        this.smtProblems = smtproblems;
        this.progressModel = new ProgressModel();
        String[] captions = new String[this.smtProblems.size()];
        int i = 0;
        for (SMTProblem sMTProblem : smtproblems) {
            captions[i] = sMTProblem.getName();
            ++i;
        }
        this.progressModel.addColumn(new ProgressModel.TitleColumn(captions));
        String[] titles = new String[solverTypes.size() + 1];
        this.problemProcessed = new boolean[solverTypes.size()][this.smtProblems.size()];
        titles[0] = "";
        i = 1;
        for (SolverType type : solverTypes) {
            this.progressModel.addColumn(new ProgressModel.ProcessColumn(smtproblems.size()));
            titles[i] = type.getName();
            ++i;
        }
        boolean bl = false;
        int y = 0;
        for (SMTProblem problem : smtproblems) {
            void var7_10;
            y = 0;
            for (SMTSolver solver : problem.getSolvers()) {
                this.problems.add(new InternSMTProblem((int)var7_10, y, problem, solver));
                ++y;
            }
            ++var7_10;
        }
        boolean ce = solverTypes.contains(SolverTypes.Z3_CE_SOLVER);
        this.progressDialog = new ProgressDialog(this.progressModel, new ProgressDialogListenerImpl(launcher, ce), ce, 1000, smtproblems.size() * solverTypes.size(), new String[0], titles);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SolverListener.this.progressDialog.setVisible(true);
            }
        });
    }

    private InternSMTProblem getProblem(int col, int row) {
        for (InternSMTProblem problem : this.problems) {
            if (problem.problemIndex != row || problem.solverIndex != col) continue;
            return problem;
        }
        return null;
    }

    private void stopEvent(SolverLauncher launcher) {
        launcher.stop();
    }

    private void discardEvent(SolverLauncher launcher) {
        launcher.stop();
        this.progressDialog.setVisible(false);
    }

    private void applyEvent(SolverLauncher launcher) {
        launcher.stop();
        this.applyResults();
        this.progressDialog.setVisible(false);
    }

    public void launcherStarted(Collection<SMTProblem> smtproblems, Collection<SolverType> solverTypes, SolverLauncher launcher) {
        this.prepareDialog(smtproblems, solverTypes, launcher);
        this.setProgressText(0);
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                SolverListener.this.refreshDialog();
            }
        }, 0L, 10L);
    }

    private void refreshDialog() {
        for (InternSMTProblem problem : this.problems) {
            this.refreshProgessOfProblem(problem);
        }
    }

    private long calculateProgress(InternSMTProblem problem) {
        long maxTime = problem.solver.getTimeout();
        long startTime = problem.solver.getStartTime();
        long currentTime = System.currentTimeMillis();
        return 1000L - (startTime - currentTime) * 1000L / maxTime;
    }

    private float calculateRemainingTime(InternSMTProblem problem) {
        long startTime = problem.solver.getStartTime();
        long currentTime = System.currentTimeMillis();
        long temp = (startTime - currentTime) / 100L;
        return Math.max((float)temp / 10.0f, 0.0f);
    }

    private boolean refreshProgessOfProblem(InternSMTProblem problem) {
        SMTSolver.SolverState state = problem.solver.getState();
        switch (state) {
            case Running: {
                this.running(problem);
                return true;
            }
            case Stopped: {
                this.stopped(problem);
                return false;
            }
            case Waiting: {
                this.waiting(problem);
                return true;
            }
        }
        return true;
    }

    private void waiting(InternSMTProblem problem) {
    }

    private void running(InternSMTProblem problem) {
        problem.startTime();
        long progress = this.calculateProgress(problem);
        this.progressModel.setProgress((int)progress, problem.getSolverIndex(), problem.getProblemIndex());
        float remainingTime = this.calculateRemainingTime(problem);
        this.progressModel.setText(Float.toString(remainingTime) + " sec.", problem.getSolverIndex(), problem.getProblemIndex());
    }

    private void setProgressText(int value) {
        JProgressBar bar = this.progressDialog.getProgressBar();
        if (bar.getMaximum() == 1) {
            bar.setString(value == 0 ? "Processing..." : "Finished.");
            bar.setStringPainted(true);
        } else {
            bar.setString("Processed " + value + " of " + bar.getMaximum() + " problems.");
            bar.setStringPainted(true);
        }
    }

    private void stopped(InternSMTProblem problem) {
        problem.stopTime();
        int x = problem.getSolverIndex();
        int y = problem.getProblemIndex();
        if (!this.problemProcessed[x][y]) {
            ++this.finishedCounter;
            this.progressDialog.setProgress(this.finishedCounter);
            JProgressBar bar = this.progressDialog.getProgressBar();
            bar.setValue(this.finishedCounter);
            this.setProgressText(this.finishedCounter);
            this.problemProcessed[x][y] = true;
        }
        if (problem.solver.wasInterrupted()) {
            this.interrupted(problem);
        } else if (problem.solver.getFinalResult().isValid() == SMTSolverResult.ThreeValuedTruth.VALID) {
            this.successfullyStopped(problem, x, y);
        } else if (problem.solver.getFinalResult().isValid() == SMTSolverResult.ThreeValuedTruth.FALSIFIABLE) {
            this.unsuccessfullyStopped(problem, x, y);
        } else {
            this.unknownStopped(x, y);
        }
    }

    private void interrupted(InternSMTProblem problem) {
        SMTSolver.ReasonOfInterruption reason = problem.solver.getReasonOfInterruption();
        int x = problem.getSolverIndex();
        int y = problem.getProblemIndex();
        switch (reason) {
            case Exception: {
                this.progressModel.setProgress(0, x, y);
                this.progressModel.setTextColor(RED.get(), x, y);
                this.progressModel.setText("Exception!", x, y);
                break;
            }
            case NoInterruption: {
                throw new RuntimeException("This position should not be reachable!");
            }
            case Timeout: {
                this.progressModel.setProgress(0, x, y);
                this.progressModel.setText("Timeout.", x, y);
                break;
            }
            case User: {
                this.progressModel.setText("Interrupted by user.", x, y);
            }
        }
    }

    private void successfullyStopped(InternSMTProblem problem, int x, int y) {
        String timeInfo = " (" + problem.getTimeInSecAsString() + ")";
        this.progressModel.setProgress(0, x, y);
        this.progressModel.setTextColor(GREEN.get(), x, y);
        if (problem.solver.getType() == SolverTypes.Z3_CE_SOLVER) {
            this.progressModel.setText("No Counterexample.", x, y);
        } else {
            this.progressModel.setText("Valid" + timeInfo, x, y);
        }
    }

    private void unsuccessfullyStopped(InternSMTProblem problem, int x, int y) {
        String timeInfo = " (" + problem.getTimeInSecAsString() + ")";
        if (problem.solver.getType() == SolverTypes.Z3_CE_SOLVER) {
            this.progressModel.setProgress(0, x, y);
            this.progressModel.setTextColor(RED.get(), x, y);
            this.progressModel.setText("Counter Example" + timeInfo, x, y);
        } else {
            this.progressModel.setProgress(0, x, y);
            Color c = new Color(200, 150, 0);
            this.progressModel.setTextColor(c, x, y);
            this.progressModel.setText("Possible Counter Example" + timeInfo, x, y);
        }
    }

    private void unknownStopped(int x, int y) {
        this.progressModel.setProgress(0, x, y);
        this.progressModel.setTextColor(Color.BLUE, x, y);
        this.progressModel.setText("Unknown.", x, y);
    }

    private void storeInformation() {
        if (this.settings.storeSMTTranslationToFile() || this.settings.makesUseOfTaclets() && this.settings.storeTacletTranslationToFile()) {
            for (InternSMTProblem problem : this.problems) {
                this.storeInformation(problem.getProblem());
            }
        }
    }

    private void storeInformation(SMTProblem problem) {
        for (SMTSolver solver : problem.getSolvers()) {
            if (this.settings.storeSMTTranslationToFile()) {
                this.storeSMTTranslation(solver, problem.getGoal(), solver.getTranslation());
            }
            if (!this.settings.makesUseOfTaclets() || !this.settings.storeTacletTranslationToFile() || solver.getTacletTranslation() == null) continue;
            this.storeTacletTranslation(solver, problem.getGoal(), solver.getTacletTranslation());
        }
    }

    private void storeTacletTranslation(SMTSolver solver, Goal goal, TacletSetTranslation translation) {
        String path = this.settings.getPathForTacletTranslation();
        path = this.finalizePath(path, solver, goal);
        this.storeToFile(translation.toString(), path);
    }

    private void storeSMTTranslation(SMTSolver solver, Goal goal, String problemString) {
        Object path = this.settings.getPathForSMTTranslation();
        String fileName = goal.proof().name() + "_" + goal.getTime() + "_" + solver.name() + ".smt";
        path = (String)path + File.separator + fileName;
        path = this.finalizePath((String)path, solver, goal);
        this.storeToFile(problemString, (String)path);
    }

    private void storeToFile(String text, String path) {
        try {
            BufferedWriter out2 = new BufferedWriter(new FileWriter(path));
            out2.write(text);
            out2.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not store to file " + path + ".", e);
        }
    }

    private String finalizePath(String path, SMTSolver solver, Goal goal) {
        Calendar c = Calendar.getInstance();
        String date = c.get(1) + "-" + c.get(2) + "-" + c.get(5);
        String time = c.get(11) + "-" + c.get(12) + "-" + c.get(13);
        path = path.replaceAll("%d", date);
        path = path.replaceAll("%s", solver.name());
        path = path.replaceAll("%t", time);
        path = path.replaceAll("%i", Integer.toString(FILE_ID++));
        path = path.replaceAll("%g", Integer.toString(goal.node().serialNr()));
        return path;
    }

    public static String computeSolverTypeWarningMessage(SolverType type) {
        StringBuffer message = new StringBuffer();
        message.append("You are using a version of " + type.getName() + " which has not been tested for this version of KeY.\nIt can therefore be that errors occur that would not occur\nusing the following version or higher:\n");
        message.append(type.getMinimumSupportedVersion());
        return message.toString();
    }

    public static boolean containsModalityOrQuery(Term term) {
        ContainsModalityOrQueryVisitor visitor = new ContainsModalityOrQueryVisitor();
        term.execPostOrder((Visitor)visitor);
        return visitor.containsModOrQuery();
    }

    protected static class ContainsModalityOrQueryVisitor
    extends DefaultVisitor {
        boolean containsModQuery = false;

        protected ContainsModalityOrQueryVisitor() {
        }

        public void visit(Term visited) {
            if (visited.op() instanceof Modality || visited.op() instanceof IProgramMethod) {
                this.containsModQuery = true;
            }
        }

        public boolean containsModOrQuery() {
            return this.containsModQuery;
        }
    }

    private class ProgressDialogListenerImpl
    implements ProgressDialog.ProgressDialogListener {
        private SolverLauncher launcher;
        private boolean counterexample;

        public ProgressDialogListenerImpl(SolverLauncher launcher, boolean counterexample) {
            this.launcher = launcher;
            this.counterexample = counterexample;
        }

        @Override
        public void infoButtonClicked(int column, int row) {
            InternSMTProblem problem = SolverListener.this.getProblem(column, row);
            SolverListener.this.showInformation(problem);
        }

        @Override
        public void stopButtonClicked() {
            SolverListener.this.stopEvent(this.launcher);
        }

        @Override
        public void applyButtonClicked() {
            SolverListener.this.applyEvent(this.launcher);
        }

        @Override
        public void discardButtonClicked() {
            SolverListener.this.discardEvent(this.launcher);
            if (this.counterexample && SolverListener.this.smtProof != null) {
                SolverListener.this.smtProof.dispose();
            }
        }

        @Override
        public void additionalInformationChosen(Object obj) {
            if (obj instanceof String) {
                JOptionPane.showOptionDialog(SolverListener.this.progressDialog, obj, "Warning", -1, 2, null, null, null);
            } else if (obj instanceof InternSMTProblem) {
                SolverListener.this.showInformation((InternSMTProblem)obj);
            }
        }
    }

    public static class InternSMTProblem {
        final int problemIndex;
        final int solverIndex;
        final SMTSolver solver;
        final SMTProblem problem;
        final LinkedList<InformationWindow.Information> information = new LinkedList();
        private boolean stopped = false;
        private boolean running = false;
        private long timeToSolve;

        public InternSMTProblem(int problemIndex, int solverIndex, SMTProblem problem, SMTSolver solver) {
            this.problemIndex = problemIndex;
            this.solverIndex = solverIndex;
            this.problem = problem;
            this.solver = solver;
        }

        public int getSolverIndex() {
            return this.solverIndex;
        }

        public int getProblemIndex() {
            return this.problemIndex;
        }

        public SMTProblem getProblem() {
            return this.problem;
        }

        private void addInformation(String title, String content) {
            this.information.add(new InformationWindow.Information(title, content, this.solver.name()));
        }

        public void createInformation() {
            if (this.solver.getException() != null) {
                StringWriter writer = new StringWriter();
                this.solver.getException().printStackTrace(new PrintWriter(writer));
                this.addInformation("Error-Message", this.solver.getException().toString() + "\n\n" + writer.toString());
            }
            this.addInformation("Solver Input", this.solver.getRawSolverInput());
            if (this.solver.getTacletTranslation() != null) {
                this.addInformation("Taclets", this.solver.getTacletTranslation().toString());
            }
            this.addInformation("Solver Output", this.solver.getRawSolverOutput());
            Collection exceptionsOfTacletTranslation = this.solver.getExceptionsOfTacletTranslation();
            if (!exceptionsOfTacletTranslation.isEmpty()) {
                Object exceptionText = "The following exceptions have ocurred while translating the taclets:\n\n";
                int i = 1;
                for (Throwable e : exceptionsOfTacletTranslation) {
                    exceptionText = (String)exceptionText + i + ". " + e.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    e.printStackTrace(pw);
                    exceptionText = (String)exceptionText + "\n\n" + sw.toString();
                    exceptionText = (String)exceptionText + "\n #######################\n\n";
                    ++i;
                }
                this.addInformation("Warning", (String)exceptionText);
            }
            if (this.solver.getType().supportHasBeenChecked() && !this.solver.getType().isSupportedVersion()) {
                this.addInformation("Solver Support", SolverListener.computeSolverTypeWarningMessage(this.solver.getType()));
            }
            this.solver.getException();
        }

        public LinkedList<InformationWindow.Information> getInformation() {
            return this.information;
        }

        public String toString() {
            return this.solver.name() + " applied on " + this.problem.getName();
        }

        String getTimeInSecAsString() {
            long intPart = this.timeToSolve / 1000L;
            long decPart = this.timeToSolve % 1000L;
            String decString = decPart >= 100L ? Long.toString(decPart) : (decPart >= 10L ? "0" + decPart : "00" + decPart);
            return intPart + "." + decString + "s";
        }

        void startTime() {
            if (!this.running) {
                this.timeToSolve = System.currentTimeMillis();
                this.running = true;
            }
        }

        void stopTime() {
            if (!this.stopped) {
                this.timeToSolve = System.currentTimeMillis() - this.timeToSolve;
                this.stopped = true;
            }
        }
    }
}

