/*
 * Decompiled with CFR 0.152.
 */
package de.uka.ilkd.key.gui.smt;

import de.uka.ilkd.key.core.KeYSelectionListener;
import de.uka.ilkd.key.gui.smt.InnerPanel;
import de.uka.ilkd.key.gui.smt.LeafPanel;
import de.uka.ilkd.key.gui.smt.TreePanel;
import de.uka.ilkd.key.settings.DefaultSMTSettings;
import de.uka.ilkd.key.taclettranslation.assumptions.SupportedTaclets;
import java.awt.Component;
import java.util.EventObject;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TacletTranslationSelection {
    private DefaultTreeCellRenderer cellRenderer = null;
    private JTree selectionTree = null;
    private static final int INNER_PANEL = 0;
    private static final int LEAF_PANEL = 1;
    private static final int PAINT = 0;
    private static final int EDIT = 1;
    private TreePanel[][] treePanels = new TreePanel[2][2];
    private final DefaultSMTSettings smtSettings;

    public TacletTranslationSelection(DefaultSMTSettings smtSettings) {
        this.smtSettings = smtSettings;
        this.treePanels[0][0] = new InnerPanel(smtSettings.getPdSettings().supportedTaclets);
        this.treePanels[0][1] = new InnerPanel(smtSettings.getPdSettings().supportedTaclets);
        this.treePanels[1][0] = new LeafPanel(smtSettings.getPdSettings().supportedTaclets);
        this.treePanels[1][1] = new LeafPanel(smtSettings.getPdSettings().supportedTaclets);
    }

    public static KeYSelectionListener getSelectionListener() {
        return LeafPanel.getSelectionListener();
    }

    protected SupportedTaclets.TreeItem treeItem(TreeNode node) {
        return (SupportedTaclets.TreeItem)((DefaultMutableTreeNode)node).getUserObject();
    }

    private int getItemHeight(TreeModel model) {
        LeafPanel panel1 = new LeafPanel(this.smtSettings.getPdSettings().supportedTaclets);
        InnerPanel panel2 = new InnerPanel(this.smtSettings.getPdSettings().supportedTaclets);
        return Math.max(panel1.getHeight(), panel2.getHeight());
    }

    public JTree getSelectionTree() {
        if (this.selectionTree == null) {
            this.selectionTree = new JTree();
            this.selectionTree.setModel(this.smtSettings.getPdSettings().supportedTaclets.getTreeModel());
            this.selectionTree.setCellRenderer(this.getTreeCellRenderer());
            this.selectionTree.setCellEditor(this.getTreeCellEditor());
            this.selectionTree.setEditable(true);
            int height = this.getItemHeight(this.selectionTree.getModel());
            this.selectionTree.setRowHeight(height);
            ToolTipManager.sharedInstance().registerComponent(this.selectionTree);
        }
        return this.selectionTree;
    }

    private TreeCellEditor getTreeCellEditor() {
        return new DefaultTreeCellEditor(this.getSelectionTree(), this.getTreeCellRenderer()){

            @Override
            public Component getTreeCellEditorComponent(JTree t, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
                SupportedTaclets.TreeItem node = (SupportedTaclets.TreeItem)value;
                SupportedTaclets.TreeItem root = (SupportedTaclets.TreeItem)t.getModel().getRoot();
                return leaf ? TacletTranslationSelection.this.treePanels[1][1].init(node, root, t, TacletTranslationSelection.this.smtSettings) : TacletTranslationSelection.this.treePanels[0][1].init(node, root, t, TacletTranslationSelection.this.smtSettings);
            }

            @Override
            public boolean isCellEditable(EventObject arg0) {
                return true;
            }
        };
    }

    private DefaultTreeCellRenderer getTreeCellRenderer() {
        if (this.cellRenderer == null) {
            this.cellRenderer = new DefaultTreeCellRenderer(){
                private static final long serialVersionUID = 1L;

                @Override
                public Component getTreeCellRendererComponent(JTree tree, Object value, boolean select, boolean expanded, boolean leaf, int row, boolean arg6) {
                    SupportedTaclets.TreeItem node = (SupportedTaclets.TreeItem)value;
                    SupportedTaclets.TreeItem root = (SupportedTaclets.TreeItem)tree.getModel().getRoot();
                    return leaf ? TacletTranslationSelection.this.treePanels[1][0].init(node, root, tree, TacletTranslationSelection.this.smtSettings) : TacletTranslationSelection.this.treePanels[0][0].init(node, root, tree, TacletTranslationSelection.this.smtSettings);
                }
            };
        }
        return this.cellRenderer;
    }
}

